/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.common.enums;

import com.xiaomi.mone.tpc.common.enums.Base;
import com.xiaomi.mone.tpc.common.enums.NodeTypeEnum;
import com.xiaomi.mone.tpc.common.util.ListUtil;
import java.util.List;
import java.util.stream.Collectors;

public enum NodeUserRelTypeEnum implements Base
{
    MANAGER(0, "\u7ba1\u7406\u5458", ListUtil.list(NodeTypeEnum.TOP_TYPE, NodeTypeEnum.PRO_GROUP_TYPE, NodeTypeEnum.PRO_TYPE, NodeTypeEnum.PRO_SUB_GROUP)),
    MEMBER(1, "\u6210\u5458", ListUtil.list(NodeTypeEnum.PRO_GROUP_TYPE, NodeTypeEnum.PRO_TYPE, NodeTypeEnum.PRO_SUB_GROUP));

    private Integer code;
    private String desc;
    private List<Integer> nodeTypes;

    private NodeUserRelTypeEnum(Integer mode, String desc, List<NodeTypeEnum> nodeTypes) {
        this.code = mode;
        this.desc = desc;
        if (nodeTypes != null && !nodeTypes.isEmpty()) {
            this.nodeTypes = nodeTypes.stream().map(NodeTypeEnum::getCode).collect(Collectors.toList());
        }
    }

    public static final NodeUserRelTypeEnum getEnum(Integer code) {
        if (code == null) {
            return null;
        }
        for (NodeUserRelTypeEnum userTypeEnum : NodeUserRelTypeEnum.values()) {
            if (!code.equals(userTypeEnum.code)) continue;
            return userTypeEnum;
        }
        return null;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public List<Integer> getNodeTypes() {
        return this.nodeTypes;
    }

    public String toString() {
        return "NodeUserRelTypeEnum." + this.name() + "(code=" + this.getCode() + ", desc=" + this.getDesc() + ", nodeTypes=" + String.valueOf(this.getNodeTypes()) + ")";
    }
}

