/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc.driver;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.livy.Job;
import org.apache.livy.JobContext;
import org.apache.livy.rsc.driver.RSCDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobWrapper<T>
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(JobWrapper.class);
    public final String jobId;
    private final RSCDriver driver;
    private final Job<T> job;
    private boolean isCancelled = false;
    private Future<?> future;

    public JobWrapper(RSCDriver driver, String jobId, Job<T> job) {
        this.driver = driver;
        this.jobId = jobId;
        this.job = job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        try {
            JobWrapper jobWrapper = this;
            synchronized (jobWrapper) {
                if (this.isCancelled) {
                    throw new CancellationException("Job has been cancelled");
                }
                this.driver.jobContext().sc().setJobGroup(this.jobId, "", true);
            }
            this.jobStarted();
            Object result = this.job.call((JobContext)this.driver.jobContext());
            this.finished(result, null);
        }
        catch (Throwable t) {
            LOG.info("Failed to run job " + this.jobId, t);
            this.finished(null, t);
            throw new ExecutionException(t);
        }
        finally {
            this.driver.activeJobs.remove(this.jobId);
        }
        return null;
    }

    synchronized void submit(ExecutorService executor) {
        if (!this.isCancelled) {
            this.future = executor.submit(this);
        }
    }

    synchronized boolean cancel() {
        if (this.isCancelled) {
            return false;
        }
        this.isCancelled = true;
        this.driver.jobContext().sc().cancelJobGroup(this.jobId);
        return this.future != null ? this.future.cancel(true) : true;
    }

    protected void finished(T result, Throwable error) {
        if (error == null) {
            this.driver.jobFinished(this.jobId, result, null);
        } else {
            this.driver.jobFinished(this.jobId, null, error);
        }
    }

    protected void jobStarted() {
        this.driver.jobStarted(this.jobId);
    }
}

