/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.date.SafeDateFormat;

public final class DateUtil {
    public static final Date DATE_ZERO = new Date(0L);
    private static final Map<String, String> VALID_DFS = ImmutableMap.of((Object)"^\\d{4}-\\d{1,2}-\\d{1,2}", (Object)"yyyy-MM-dd", (Object)"^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{2}:\\d{2}:\\d{2}", (Object)"yyyy-MM-dd HH:mm:ss", (Object)"^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{2}:\\d{2}:\\d{2}\\.\\d{1,3}", (Object)"yyyy-MM-dd HH:mm:ss.SSS");
    private static final Map<String, SafeDateFormat> DATE_FORMATS = new ConcurrentHashMap<String, SafeDateFormat>();

    public static Date parse(String value) {
        for (Map.Entry<String, String> entry : VALID_DFS.entrySet()) {
            if (!value.matches(entry.getKey())) continue;
            return DateUtil.parse(value, entry.getValue());
        }
        throw new IllegalArgumentException(String.format("Expected date format is: %s, but got '%s'", VALID_DFS.values(), value));
    }

    public static Date parse(String value, String df) {
        SafeDateFormat dateFormat = DateUtil.getDateFormat(df);
        return dateFormat.parse(value);
    }

    public static Date now() {
        return new Date();
    }

    private static SafeDateFormat getDateFormat(String df) {
        SafeDateFormat previous;
        SafeDateFormat dateFormat = DATE_FORMATS.get(df);
        if (dateFormat == null && (previous = DATE_FORMATS.putIfAbsent(df, dateFormat = new SafeDateFormat(df))) != null) {
            dateFormat = previous;
        }
        return dateFormat;
    }

    public static Object toPattern(String df) {
        SafeDateFormat dateFormat = DateUtil.getDateFormat(df);
        return dateFormat.toPattern();
    }
}

