/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.manager;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.base.ToolClient;
import org.apache.hugegraph.base.ToolManager;
import org.apache.hugegraph.structure.Task;

public class TasksManager
extends ToolManager {
    public static final Set<String> TASK_STATUSES = ImmutableSet.of((Object)"UNKNOWN", (Object)"NEW", (Object)"QUEUED", (Object)"RESTORING", (Object)"RUNNING", (Object)"SUCCESS", (Object[])new String[]{"CANCELLED", "FAILED"});
    private static final Set<String> UNCOMPLETED_STATUSES = ImmutableSet.of((Object)"UNKNOWN", (Object)"NEW", (Object)"QUEUED", (Object)"RESTORING", (Object)"RUNNING");
    private static final Set<String> COMPLETED_STATUSES = ImmutableSet.of((Object)"SUCCESS", (Object)"CANCELLED", (Object)"FAILED");
    private static long TASK_LIMIT = 10000L;

    public TasksManager(ToolClient.ConnectionInfo info) {
        super(info, "tasks");
    }

    public List<Task> list(String status, long limit) {
        return this.client.tasks().list(status, limit);
    }

    public Task get(long taskId) {
        return this.client.tasks().get(taskId);
    }

    public void delete(long taskId) {
        this.client.tasks().delete(taskId);
    }

    public void cancel(long taskId) {
        this.client.tasks().cancel(taskId);
    }

    public void clear(boolean force) {
        List<Task> tasks;
        if (force) {
            for (String status : UNCOMPLETED_STATUSES) {
                do {
                    tasks = this.list(status, TASK_LIMIT);
                    tasks.forEach(t -> this.cancel(t.id()));
                } while ((long)tasks.size() >= TASK_LIMIT);
            }
        }
        for (String status : COMPLETED_STATUSES) {
            do {
                tasks = this.list(status, TASK_LIMIT);
                tasks.forEach(t -> this.delete(t.id()));
            } while ((long)tasks.size() >= TASK_LIMIT);
        }
    }
}

