/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.base;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.base.Directory;
import org.apache.hugegraph.exception.ToolsException;
import org.apache.hugegraph.rest.ClientException;
import org.apache.hugegraph.util.E;

public class LocalDirectory
extends Directory {
    public LocalDirectory(String directory) {
        super(directory);
    }

    @Override
    public List<String> files() {
        ArrayList<String> fileList = new ArrayList<String>(8);
        File dir = new File(this.directory());
        String[] files = dir.list();
        if (files == null) {
            return ImmutableList.of();
        }
        for (String f : files) {
            File file = Paths.get(dir.getAbsolutePath(), f).toFile();
            if (!file.isFile()) continue;
            fileList.add(file.getName());
        }
        return fileList;
    }

    @Override
    public void removeDirectory() {
        LocalDirectory.removeDirectory(this.directory());
    }

    @Override
    public void ensureDirectoryExist(boolean create) {
        LocalDirectory.ensureDirectoryExist(this.directory(), create);
    }

    @Override
    public String suffix(boolean compress) {
        return compress ? ".zip" : "";
    }

    @Override
    public InputStream inputStream(String file) {
        if (file.endsWith(this.suffix(true))) {
            return this.zipInputStream(file);
        }
        return this.textInputStream(file);
    }

    private ZipInputStream zipInputStream(String file) {
        ZipInputStream zis;
        String path = Paths.get(this.directory(), file).toString();
        FileInputStream is = null;
        try {
            is = new FileInputStream(path);
            zis = new ZipInputStream(is);
            E.checkState((zis.getNextEntry() != null ? 1 : 0) != 0, (String)"Invalid zip file '%s'", (Object[])new Object[]{file});
        }
        catch (IOException | IllegalStateException e) {
            LocalDirectory.closeAndIgnoreException(is);
            throw new ClientException("Failed to read from local file: %s", (Throwable)e, new Object[]{path});
        }
        return zis;
    }

    private InputStream textInputStream(String file) {
        String path = Paths.get(this.directory(), file).toString();
        try {
            return new FileInputStream(path);
        }
        catch (IOException e) {
            throw new ClientException("Failed to read from local file: %s", (Throwable)e, new Object[]{path});
        }
    }

    @Override
    public OutputStream outputStream(String file, boolean compress, boolean override) {
        String path = Paths.get(this.directory(), file + this.suffix(compress)).toString();
        FileOutputStream os = null;
        ZipOutputStream zos = null;
        try {
            os = new FileOutputStream(path, !override);
            if (!compress) {
                return os;
            }
            zos = new ZipOutputStream(os);
            ZipEntry entry = new ZipEntry(file);
            zos.putNextEntry(entry);
        }
        catch (IOException e) {
            LocalDirectory.closeAndIgnoreException(zos);
            LocalDirectory.closeAndIgnoreException(os);
            throw new ClientException("Failed to write to local file: %s", (Throwable)e, new Object[]{path});
        }
        return zos;
    }

    public static LocalDirectory constructDir(String directory, String graph) {
        if (directory == null || directory.isEmpty()) {
            directory = "./" + graph;
        }
        return new LocalDirectory(directory);
    }

    public static void ensureDirectoryExist(String directory) {
        LocalDirectory.ensureDirectoryExist(directory, true);
    }

    private static void ensureDirectoryExist(String directory, boolean create) {
        File file = new File(directory);
        if (file.exists()) {
            E.checkState((boolean)file.isDirectory(), (String)"Can't use directory '%s' because a file with same name exists.", (Object[])new Object[]{file.getAbsolutePath()});
        } else if (create) {
            E.checkState((boolean)file.mkdirs(), (String)"The directory does not exist and created failed: '%s'", (Object[])new Object[]{file.getAbsolutePath()});
        } else {
            E.checkState((boolean)false, (String)"The directory does not exist: '%s'", (Object[])new Object[]{file.getAbsolutePath()});
        }
    }

    private static void removeDirectory(String directory) {
        File dir = new File(directory);
        E.checkState((dir.exists() && dir.isDirectory() ? 1 : 0) != 0, (String)"The directory does not exist: '%s'", (Object[])new Object[]{dir.getAbsolutePath()});
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException e) {
            throw new ToolsException("Failed to delete directory '%s'", dir.getAbsolutePath());
        }
    }
}

