/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorSelectDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;

public class VectorSelectOperator
extends Operator<SelectDesc>
implements VectorizationOperator,
VectorizationContextRegion {
    private static final long serialVersionUID = 1L;
    private VectorizationContext vContext;
    private VectorSelectDesc vectorDesc;
    private VectorExpression[] vExpressions = null;
    private int[] projectedOutputColumns = null;
    private transient VectorExpressionWriter[] valueWriters = null;
    private VectorizationContext vOutContext;

    public VectorSelectOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        this(ctx);
        this.conf = (SelectDesc)conf;
        this.vContext = vContext;
        this.vectorDesc = (VectorSelectDesc)vectorDesc;
        this.vExpressions = this.vectorDesc.getSelectExpressions();
        this.projectedOutputColumns = this.vectorDesc.getProjectedOutputColumns();
        this.vOutContext = new VectorizationContext(this.getName(), vContext);
        this.vOutContext.resetProjectionColumns();
        List<String> outputColumnNames = ((SelectDesc)this.conf).getOutputColumnNames();
        for (int i = 0; i < this.projectedOutputColumns.length; ++i) {
            String columnName = outputColumnNames.get(i);
            this.vOutContext.addProjectionColumn(columnName, this.projectedOutputColumns[i]);
        }
    }

    @VisibleForTesting
    public VectorSelectOperator() {
    }

    public VectorSelectOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public VectorizationContext getInputVectorizationContext() {
        return this.vContext;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        if (((SelectDesc)this.conf).isSelStarNoCompute()) {
            return;
        }
        VectorExpression.doTransientInit(this.vExpressions);
        ArrayList<ObjectInspector> objectInspectors = new ArrayList<ObjectInspector>();
        List<ExprNodeDesc> colList = ((SelectDesc)this.conf).getColList();
        for (VectorExpressionWriter vew : this.valueWriters = VectorExpressionWriterFactory.getExpressionWriters(colList)) {
            objectInspectors.add(vew.getObjectInspector());
        }
        List<String> outputFieldNames = ((SelectDesc)this.conf).getOutputColumnNames();
        this.outputObjInspector = ObjectInspectorFactory.getStandardStructObjectInspector(outputFieldNames, objectInspectors);
    }

    @Override
    public void setNextVectorBatchGroupStatus(boolean isLastGroupBatch) throws HiveException {
        for (Operator op : this.childOperators) {
            op.setNextVectorBatchGroupStatus(isLastGroupBatch);
        }
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        if (((SelectDesc)this.conf).isSelStarNoCompute()) {
            this.forward(row, this.inputObjInspectors[tag], true);
            return;
        }
        VectorizedRowBatch vrg = (VectorizedRowBatch)row;
        for (int i = 0; i < this.vExpressions.length; ++i) {
            try {
                this.vExpressions[i].evaluate(vrg);
                continue;
            }
            catch (RuntimeException e) {
                throw new HiveException("Error evaluating " + ((SelectDesc)this.conf).getColList().get(i).getExprString(), e);
            }
        }
        int[] originalProjections = vrg.projectedColumns;
        int originalProjectionSize = vrg.projectionSize;
        vrg.projectionSize = this.projectedOutputColumns.length;
        vrg.projectedColumns = this.projectedOutputColumns;
        this.forward(vrg, this.outputObjInspector, true);
        vrg.projectionSize = originalProjectionSize;
        vrg.projectedColumns = originalProjections;
    }

    public VectorExpression[] getvExpressions() {
        return this.vExpressions;
    }

    public VectorExpression[] getVExpressions() {
        return this.vExpressions;
    }

    public void setvExpressions(VectorExpression[] vExpressions) {
        this.vExpressions = vExpressions;
    }

    public void setVExpressions(VectorExpression[] vExpressions) {
        this.vExpressions = vExpressions;
    }

    @Override
    public VectorizationContext getOutputVectorizationContext() {
        return this.vOutContext;
    }

    @Override
    public OperatorType getType() {
        return OperatorType.SELECT;
    }

    @Override
    public String getName() {
        return VectorSelectOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "SEL";
    }

    @Override
    public VectorDesc getVectorDesc() {
        return this.vectorDesc;
    }
}

