/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.traverser.Kout;
import org.apache.hugegraph.structure.traverser.KoutRequest;

public class KoutAPI
extends TraversersAPI {
    public KoutAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "kout";
    }

    public List<Object> get(Object sourceId, Direction direction, String label, int depth, boolean nearest, long degree, long capacity, int limit) {
        String source = GraphAPI.formatVertexId(sourceId, false);
        KoutAPI.checkPositive(depth, "Depth of k-out");
        KoutAPI.checkDegree(degree);
        KoutAPI.checkCapacity(capacity);
        KoutAPI.checkLimit(limit);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_depth", depth);
        params.put("nearest", nearest);
        params.put("max_degree", degree);
        params.put("capacity", capacity);
        params.put("limit", limit);
        RestResult result = this.client.get(this.path(), params);
        return result.readList("vertices", Object.class);
    }

    public Kout post(KoutRequest request) {
        this.client.checkApiVersion("0.58", "customized kout");
        RestResult result = this.client.post(this.path(), request);
        return (Kout)result.readObject(Kout.class);
    }
}

