/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class MetaFixer {
    private static final Logger LOG = LoggerFactory.getLogger(MetaFixer.class);
    private static final String MAX_MERGE_COUNT_KEY = "hbase.master.metafixer.max.merge.count";
    private static final int MAX_MERGE_COUNT_DEFAULT = 10;
    private final MasterServices masterServices;
    private final int maxMergeCount;

    MetaFixer(MasterServices masterServices) {
        this.masterServices = masterServices;
        this.maxMergeCount = this.masterServices.getConfiguration().getInt(MAX_MERGE_COUNT_KEY, 10);
    }

    void fix() throws IOException {
        CatalogJanitor.Report report = this.masterServices.getCatalogJanitor().getLastReport();
        if (report == null) {
            LOG.info("CatalogJanitor has not generated a report yet; run 'catalogjanitor_run' in shell or wait until CatalogJanitor chore runs.");
            return;
        }
        this.fixHoles(report);
        this.fixOverlaps(report);
        this.masterServices.runReplicationBarrierCleaner();
    }

    void fixHoles(CatalogJanitor.Report report) throws IOException {
        List<Pair<RegionInfo, RegionInfo>> holes = report.getHoles();
        if (holes.isEmpty()) {
            LOG.debug("No holes.");
            return;
        }
        for (Pair<RegionInfo, RegionInfo> p : holes) {
            RegionInfo ri = this.getHoleCover(p);
            if (ri == null) continue;
            Configuration configuration = this.masterServices.getConfiguration();
            HRegion.createRegionDir(configuration, ri, FSUtils.getRootDir((Configuration)configuration));
            MetaTableAccessor.addRegionToMeta((Connection)this.masterServices.getConnection(), (RegionInfo)ri);
            this.masterServices.getAssignmentManager().getRegionStates().updateRegionState(ri, RegionState.State.CLOSED);
            LOG.info("Fixed hole by adding {} in CLOSED state; region NOT assigned (assign to ONLINE).", (Object)ri);
        }
    }

    private RegionInfo getHoleCover(Pair<RegionInfo, RegionInfo> hole) {
        RegionInfo holeCover = null;
        RegionInfo left = (RegionInfo)hole.getFirst();
        RegionInfo right = (RegionInfo)hole.getSecond();
        if (left.getTable().equals((Object)right.getTable())) {
            if (Bytes.compareTo((byte[])left.getEndKey(), (byte[])right.getStartKey()) >= 0) {
                LOG.warn("Skipping hole fix; left-side endKey is not less than right-side startKey; left=<{}>, right=<{}>", (Object)left, (Object)right);
                return holeCover;
            }
            holeCover = this.buildRegionInfo(left.getTable(), left.getEndKey(), right.getStartKey());
        } else {
            boolean leftUndefined = left.equals(RegionInfo.UNDEFINED);
            boolean rightUnefined = right.equals(RegionInfo.UNDEFINED);
            boolean last = left.isLast();
            boolean first = right.isFirst();
            if (leftUndefined && rightUnefined) {
                LOG.warn("Skipping hole fix; both the hole left-side and right-side RegionInfos are UNDEFINED; left=<{}>, right=<{}>", (Object)left, (Object)right);
                return holeCover;
            }
            if (leftUndefined || last) {
                holeCover = this.buildRegionInfo(right.getTable(), HConstants.EMPTY_START_ROW, right.getStartKey());
            } else if (rightUnefined || first) {
                holeCover = this.buildRegionInfo(left.getTable(), left.getEndKey(), HConstants.EMPTY_END_ROW);
            } else {
                LOG.warn("Skipping hole fix; don't know what to do with left=<{}>, right=<{}>", (Object)left, (Object)right);
                return holeCover;
            }
        }
        return holeCover;
    }

    private RegionInfo buildRegionInfo(TableName tn, byte[] start, byte[] end) {
        return RegionInfoBuilder.newBuilder((TableName)tn).setStartKey(start).setEndKey(end).build();
    }

    void fixOverlaps(CatalogJanitor.Report report) throws IOException {
        for (Set set : MetaFixer.calculateMerges(this.maxMergeCount, report.getOverlaps())) {
            RegionInfo[] regionsArray = set.toArray(new RegionInfo[0]);
            try {
                this.masterServices.mergeRegions(regionsArray, false, 0L, 0L);
            }
            catch (MergeRegionException mre) {
                LOG.warn("Failed overlap fix of {}", (Object)regionsArray, (Object)mre);
            }
        }
    }

    @VisibleForTesting
    static List<SortedSet<RegionInfo>> calculateMerges(int maxMergeCount, List<Pair<RegionInfo, RegionInfo>> overlaps) {
        if (overlaps.isEmpty()) {
            LOG.debug("No overlaps.");
            return Collections.emptyList();
        }
        ArrayList<SortedSet<RegionInfo>> merges = new ArrayList<SortedSet<RegionInfo>>();
        TreeSet<Object> currentMergeSet = new TreeSet<Object>();
        RegionInfo regionInfoWithlargestEndKey = null;
        for (Pair<RegionInfo, RegionInfo> pair : overlaps) {
            if (!(regionInfoWithlargestEndKey == null || MetaFixer.isOverlap(regionInfoWithlargestEndKey, pair) && currentMergeSet.size() < maxMergeCount)) {
                merges.add(currentMergeSet);
                currentMergeSet = new TreeSet();
            }
            currentMergeSet.add(pair.getFirst());
            currentMergeSet.add(pair.getSecond());
            regionInfoWithlargestEndKey = MetaFixer.getRegionInfoWithLargestEndKey(MetaFixer.getRegionInfoWithLargestEndKey((RegionInfo)pair.getFirst(), (RegionInfo)pair.getSecond()), regionInfoWithlargestEndKey);
        }
        merges.add(currentMergeSet);
        return merges;
    }

    @VisibleForTesting
    static RegionInfo getRegionInfoWithLargestEndKey(RegionInfo a, RegionInfo b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (!a.getTable().equals((Object)b.getTable())) {
            return b;
        }
        if (a.isLast()) {
            return a;
        }
        if (b.isLast()) {
            return b;
        }
        int compare = Bytes.compareTo((byte[])a.getEndKey(), (byte[])b.getEndKey());
        return compare == 0 || compare > 0 ? a : b;
    }

    @VisibleForTesting
    static boolean isOverlap(RegionInfo ri, Pair<RegionInfo, RegionInfo> pair) {
        if (ri == null || pair == null) {
            return false;
        }
        return ri.isOverlap((RegionInfo)pair.getFirst()) || ri.isOverlap((RegionInfo)pair.getSecond());
    }
}

