/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.schema;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.schema.SchemaElementAPI;
import org.apache.hugegraph.api.task.TaskAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.SchemaElement;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.structure.constant.WriteType;
import org.apache.hugegraph.structure.schema.PropertyKey;
import org.apache.hugegraph.util.E;

public class PropertyKeyAPI
extends SchemaElementAPI {
    public PropertyKeyAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return HugeType.PROPERTY_KEY.string();
    }

    public PropertyKey.PropertyKeyWithTask create(PropertyKey propertyKey) {
        Object pkey = this.checkCreateOrUpdate(propertyKey);
        RestResult result = this.client.post(this.path(), pkey);
        if (this.client.apiVersionLt("0.65")) {
            return new PropertyKey.PropertyKeyWithTask((PropertyKey)result.readObject(PropertyKey.class), 0L);
        }
        return (PropertyKey.PropertyKeyWithTask)result.readObject(PropertyKey.PropertyKeyWithTask.class);
    }

    public PropertyKey.PropertyKeyWithTask append(PropertyKey propertyKey) {
        String id = propertyKey.name();
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"append");
        Object pkey = this.checkCreateOrUpdate(propertyKey);
        RestResult result = this.client.put(this.path(), id, pkey, (Map)params);
        return (PropertyKey.PropertyKeyWithTask)result.readObject(PropertyKey.PropertyKeyWithTask.class);
    }

    public PropertyKey.PropertyKeyWithTask eliminate(PropertyKey propertyKey) {
        String id = propertyKey.name();
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"eliminate");
        Object pkey = this.checkCreateOrUpdate(propertyKey);
        RestResult result = this.client.put(this.path(), id, pkey, (Map)params);
        return (PropertyKey.PropertyKeyWithTask)result.readObject(PropertyKey.PropertyKeyWithTask.class);
    }

    public PropertyKey.PropertyKeyWithTask clear(PropertyKey propertyKey) {
        if (this.client.apiVersionLt("0.65")) {
            throw new NotSupportException("action clear on property key", new Object[0]);
        }
        String id = propertyKey.name();
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"clear");
        Object pkey = this.checkCreateOrUpdate(propertyKey);
        RestResult result = this.client.put(this.path(), id, pkey, (Map)params);
        return (PropertyKey.PropertyKeyWithTask)result.readObject(PropertyKey.PropertyKeyWithTask.class);
    }

    public PropertyKey get(String name) {
        RestResult result = this.client.get(this.path(), name);
        return (PropertyKey)result.readObject(PropertyKey.class);
    }

    public List<PropertyKey> list() {
        RestResult result = this.client.get(this.path());
        return result.readList(this.type(), PropertyKey.class);
    }

    public List<PropertyKey> list(List<String> names) {
        this.client.checkApiVersion("0.48", "getting schema by names");
        E.checkArgument((names != null && !names.isEmpty() ? 1 : 0) != 0, (String)"The property key names can't be null or empty", (Object[])new Object[0]);
        ImmutableMap params = ImmutableMap.of((Object)"names", names);
        RestResult result = this.client.get(this.path(), (Map)params);
        return result.readList(this.type(), PropertyKey.class);
    }

    public long delete(String name) {
        if (this.client.apiVersionLt("0.65")) {
            this.client.delete(this.path(), name);
            return 0L;
        }
        RestResult result = this.client.delete(this.path(), name);
        Map task = (Map)result.readObject(Map.class);
        return TaskAPI.parseTaskId(task);
    }

    @Override
    protected Object checkCreateOrUpdate(SchemaElement schemaElement) {
        PropertyKey propertyKey;
        SchemaElement pkey = propertyKey = (PropertyKey)schemaElement;
        if (this.client.apiVersionLt("0.47")) {
            E.checkArgument((boolean)propertyKey.aggregateType().isNone(), (String)"Not support aggregate property until api version 0.47", (Object[])new Object[0]);
            pkey = propertyKey.switchV46();
        } else if (this.client.apiVersionLt("0.59")) {
            E.checkArgument((propertyKey.writeType() == WriteType.OLTP ? 1 : 0) != 0, (String)"Not support olap property key until api version 0.59", (Object[])new Object[0]);
            pkey = propertyKey.switchV58();
        }
        return pkey;
    }
}

