/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.auth;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.auth.AuthAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.auth.Group;
import org.apache.hugegraph.structure.constant.HugeType;

public class GroupAPI
extends AuthAPI {
    public GroupAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return HugeType.GROUP.string();
    }

    public Group create(Group group) {
        RestResult result = this.client.post(this.path(), group);
        return (Group)result.readObject(Group.class);
    }

    public Group get(Object id) {
        RestResult result = this.client.get(this.path(), GroupAPI.formatEntityId(id));
        return (Group)result.readObject(Group.class);
    }

    public List<Group> list(int limit) {
        GroupAPI.checkLimit(limit, "Limit");
        ImmutableMap params = ImmutableMap.of((Object)"limit", (Object)limit);
        RestResult result = this.client.get(this.path(), (Map)params);
        return result.readList(this.type(), Group.class);
    }

    public Group update(Group group) {
        String id = GroupAPI.formatEntityId(group.id());
        RestResult result = this.client.put(this.path(), id, group);
        return (Group)result.readObject(Group.class);
    }

    public void delete(Object id) {
        this.client.delete(this.path(), GroupAPI.formatEntityId(id));
    }
}

