/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.protobuf.ReplicationProtbufUtil;
import org.apache.hadoop.hbase.replication.HBaseReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSinkManager;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HBaseInterClusterReplicationEndpoint
extends HBaseReplicationEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseInterClusterReplicationEndpoint.class);
    private static final long DEFAULT_MAX_TERMINATION_WAIT_MULTIPLIER = 2L;
    private ClusterConnection conn;
    private Configuration localConf;
    private Configuration conf;
    private long sleepForRetries;
    private int maxRetriesMultiplier;
    private int socketTimeoutMultiplier;
    private long maxTerminationWait;
    private int replicationRpcLimit;
    private MetricsSource metrics;
    private ReplicationSinkManager replicationSinkMgr;
    private boolean peersSelected = false;
    private String replicationClusterId = "";
    private ThreadPoolExecutor exec;
    private int maxThreads;
    private Path baseNamespaceDir;
    private Path hfileArchiveDir;
    private boolean replicationBulkLoadDataEnabled;
    private Abortable abortable;
    private boolean dropOnDeletedTables;
    private boolean isSerial = false;

    @Override
    public void init(ReplicationEndpoint.Context context) throws IOException {
        super.init(context);
        this.conf = HBaseConfiguration.create((Configuration)this.ctx.getConfiguration());
        this.localConf = HBaseConfiguration.create((Configuration)this.ctx.getLocalConfiguration());
        this.decorateConf();
        this.maxRetriesMultiplier = this.conf.getInt("replication.source.maxretriesmultiplier", 300);
        this.socketTimeoutMultiplier = this.conf.getInt("replication.source.socketTimeoutMultiplier", this.maxRetriesMultiplier);
        long maxTerminationWaitMultiplier = this.conf.getLong("replication.source.maxterminationmultiplier", 2L);
        this.maxTerminationWait = maxTerminationWaitMultiplier * this.conf.getLong("hbase.rpc.timeout", 60000L);
        this.conn = (ClusterConnection)ConnectionFactory.createConnection((Configuration)this.conf);
        this.sleepForRetries = this.conf.getLong("replication.source.sleepforretries", 1000L);
        this.metrics = context.getMetrics();
        this.replicationSinkMgr = new ReplicationSinkManager(this.conn, this.ctx.getPeerId(), this, this.conf);
        this.maxThreads = this.conf.getInt("hbase.replication.source.maxthreads", 10);
        this.exec = Threads.getBoundedCachedThreadPool((int)this.maxThreads, (long)60L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)new ThreadFactoryBuilder().setDaemon(true).setNameFormat("SinkThread-%d").build());
        this.abortable = this.ctx.getAbortable();
        this.replicationRpcLimit = (int)(0.95 * (double)this.conf.getLong("hbase.ipc.max.request.size", 0x10000000L));
        this.dropOnDeletedTables = this.conf.getBoolean("hbase.replication.drop.on.deleted.table", false);
        this.replicationBulkLoadDataEnabled = this.conf.getBoolean("hbase.replication.bulkload.enabled", false);
        if (this.replicationBulkLoadDataEnabled) {
            this.replicationClusterId = this.conf.get("hbase.replication.cluster.id");
        }
        Path rootDir = FSUtils.getRootDir((Configuration)this.conf);
        Path baseNSDir = new Path("data");
        this.baseNamespaceDir = new Path(rootDir, baseNSDir);
        this.hfileArchiveDir = new Path(rootDir, new Path("archive", baseNSDir));
        this.isSerial = context.getPeerConfig().isSerial();
    }

    private void decorateConf() {
        String replicationCodec = this.conf.get("hbase.replication.rpc.codec");
        if (StringUtils.isNotEmpty((CharSequence)replicationCodec)) {
            this.conf.set("hbase.client.rpc.codec", replicationCodec);
        }
    }

    private void connectToPeers() {
        this.getRegionServers();
        int sleepMultiplier = 1;
        while (this.isRunning() && this.replicationSinkMgr.getNumSinks() == 0) {
            this.replicationSinkMgr.chooseSinks();
            if (!this.isRunning() || this.replicationSinkMgr.getNumSinks() != 0 || !this.sleepForRetries("Waiting for peers", sleepMultiplier)) continue;
            ++sleepMultiplier;
        }
    }

    protected boolean sleepForRetries(String msg, int sleepMultiplier) {
        block3: {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} {}, sleeping {} times {}", new Object[]{this.logPeerId(), msg, this.sleepForRetries, sleepMultiplier});
                }
                Thread.sleep(this.sleepForRetries * (long)sleepMultiplier);
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("{} Interrupted while sleeping between retries", (Object)this.logPeerId());
            }
        }
        return sleepMultiplier < this.maxRetriesMultiplier;
    }

    private int getEstimatedEntrySize(WAL.Entry e) {
        long size = e.getKey().estimatedSerializedSizeOf() + e.getEdit().estimatedSerializedSizeOf();
        return (int)size;
    }

    private List<List<WAL.Entry>> createParallelBatches(List<WAL.Entry> entries) {
        int numSinks = Math.max(this.replicationSinkMgr.getNumSinks(), 1);
        int n = Math.min(Math.min(this.maxThreads, entries.size() / 100 + 1), numSinks);
        List<List<WAL.Entry>> entryLists = Stream.generate(ArrayList::new).limit(n).collect(Collectors.toList());
        int[] sizes = new int[n];
        for (WAL.Entry e : entries) {
            int index = Math.abs(Bytes.hashCode((byte[])e.getKey().getEncodedRegionName()) % n);
            int entrySize = this.getEstimatedEntrySize(e);
            if (sizes[index] > 0 && sizes[index] + entrySize > this.replicationRpcLimit) {
                entryLists.add(entryLists.get(index));
                entryLists.set(index, new ArrayList());
                sizes[index] = 0;
            }
            entryLists.get(index).add(e);
            int n2 = index;
            sizes[n2] = sizes[n2] + entrySize;
        }
        return entryLists;
    }

    private List<List<WAL.Entry>> createSerialBatches(List<WAL.Entry> entries) {
        TreeMap<byte[], List> regionEntries = new TreeMap<byte[], List>(Bytes.BYTES_COMPARATOR);
        for (WAL.Entry e : entries) {
            regionEntries.computeIfAbsent(e.getKey().getEncodedRegionName(), key -> new ArrayList()).add(e);
        }
        return new ArrayList<List<WAL.Entry>>(regionEntries.values());
    }

    private List<List<WAL.Entry>> createBatches(List<WAL.Entry> entries) {
        if (this.isSerial) {
            return this.createSerialBatches(entries);
        }
        return this.createParallelBatches(entries);
    }

    private TableName parseTable(String msg) {
        Pattern p = Pattern.compile("TableNotFoundException: '([\\S]*)'");
        Matcher m = p.matcher(msg);
        if (m.find()) {
            String table = m.group(1);
            try {
                TableName.valueOf((byte[])TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)table)));
                return TableName.valueOf((String)table);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private List<List<WAL.Entry>> filterBatches(List<List<WAL.Entry>> oldEntryList, TableName table) {
        return oldEntryList.stream().map(entries -> entries.stream().filter(e -> !e.getKey().getTableName().equals((Object)table)).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private void reconnectToPeerCluster() {
        ClusterConnection connection = null;
        try {
            connection = (ClusterConnection)ConnectionFactory.createConnection((Configuration)this.conf);
        }
        catch (IOException ioe) {
            LOG.warn("{} Failed to create connection for peer cluster", (Object)this.logPeerId(), (Object)ioe);
        }
        if (connection != null) {
            this.conn = connection;
        }
    }

    private long parallelReplicate(CompletionService<Integer> pool, ReplicationEndpoint.ReplicateContext replicateContext, List<List<WAL.Entry>> batches) throws IOException {
        int futures = 0;
        for (int i = 0; i < batches.size(); ++i) {
            List<WAL.Entry> entries = batches.get(i);
            if (entries.isEmpty()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} Submitting {} entries of total size {}", new Object[]{this.logPeerId(), entries.size(), replicateContext.getSize()});
            }
            pool.submit(this.createReplicator(entries, i, replicateContext.getTimeout()));
            ++futures;
        }
        IOException iox = null;
        long lastWriteTime = 0L;
        for (int i = 0; i < futures; ++i) {
            try {
                Future<Integer> f = pool.take();
                int index = f.get();
                List<WAL.Entry> batch = batches.get(index);
                batches.set(index, Collections.emptyList());
                long writeTime = batch.get(batch.size() - 1).getKey().getWriteTime();
                if (writeTime <= lastWriteTime) continue;
                lastWriteTime = writeTime;
                continue;
            }
            catch (InterruptedException ie) {
                iox = new IOException(ie);
                continue;
            }
            catch (ExecutionException ee) {
                iox = (IOException)ee.getCause();
            }
        }
        if (iox != null) {
            throw iox;
        }
        return lastWriteTime;
    }

    @Override
    public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
        int numSinks;
        ExecutorCompletionService<Integer> pool = new ExecutorCompletionService<Integer>(this.exec);
        String walGroupId = replicateContext.getWalGroupId();
        int sleepMultiplier = 1;
        if (!this.peersSelected && this.isRunning()) {
            this.connectToPeers();
            this.peersSelected = true;
        }
        if ((numSinks = this.replicationSinkMgr.getNumSinks()) == 0) {
            LOG.warn("{} No replication sinks found, returning without replicating. The source should retry with the same set of edits.", (Object)this.logPeerId());
            return false;
        }
        List<List<WAL.Entry>> batches = this.createBatches(replicateContext.getEntries());
        while (this.isRunning() && !this.exec.isShutdown()) {
            if (!this.isPeerEnabled()) {
                if (!this.sleepForRetries("Replication is disabled", sleepMultiplier)) continue;
                ++sleepMultiplier;
                continue;
            }
            if (this.conn == null || this.conn.isClosed()) {
                this.reconnectToPeerCluster();
            }
            try {
                long lastWriteTime = this.parallelReplicate(pool, replicateContext, batches);
                if (lastWriteTime > 0L) {
                    this.metrics.setAgeOfLastShippedOp(lastWriteTime, walGroupId);
                }
                return true;
            }
            catch (IOException ioe) {
                this.metrics.refreshAgeOfLastShippedOp(walGroupId);
                if (ioe instanceof RemoteException) {
                    ioe = ((RemoteException)((Object)ioe)).unwrapRemoteException();
                    LOG.warn("{} Can't replicate because of an error on the remote cluster: ", (Object)this.logPeerId(), (Object)ioe);
                    if (ioe instanceof TableNotFoundException) {
                        TableName table;
                        if (this.dropOnDeletedTables && (table = this.parseTable(ioe.getMessage())) != null) {
                            try {
                                Connection localConn = ConnectionFactory.createConnection((Configuration)this.ctx.getLocalConfiguration());
                                Throwable throwable = null;
                                try {
                                    if (!localConn.getAdmin().tableExists(table)) {
                                        LOG.info("{} Missing table detected at sink, local table also does not exist, filtering edits for '{}'", (Object)this.logPeerId(), (Object)table);
                                        batches = this.filterBatches(batches, table);
                                        continue;
                                    }
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (localConn == null) continue;
                                    if (throwable != null) {
                                        try {
                                            localConn.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    localConn.close();
                                    continue;
                                }
                            }
                            catch (IOException iox) {
                                LOG.warn("{} Exception checking for local table: ", (Object)this.logPeerId(), (Object)iox);
                            }
                        }
                    } else {
                        LOG.warn("{} Peer encountered RemoteException, rechecking all sinks: ", (Object)this.logPeerId(), (Object)ioe);
                        this.replicationSinkMgr.chooseSinks();
                    }
                } else if (ioe instanceof SocketTimeoutException) {
                    this.sleepForRetries("Encountered a SocketTimeoutException. Since the call to the remote cluster timed out, which is usually caused by a machine failure or a massive slowdown", this.socketTimeoutMultiplier);
                } else if (ioe instanceof ConnectException || ioe instanceof UnknownHostException) {
                    LOG.warn("{} Peer is unavailable, rechecking all sinks: ", (Object)this.logPeerId(), (Object)ioe);
                    this.replicationSinkMgr.chooseSinks();
                } else {
                    LOG.warn("{} Can't replicate because of a local or network error: ", (Object)this.logPeerId(), (Object)ioe);
                }
                if (!this.sleepForRetries("Since we are unable to replicate", sleepMultiplier)) continue;
                ++sleepMultiplier;
            }
        }
        return false;
    }

    protected boolean isPeerEnabled() {
        return this.ctx.getReplicationPeer().isPeerEnabled();
    }

    @Override
    protected void doStop() {
        this.disconnect();
        if (this.conn != null) {
            try {
                this.conn.close();
                this.conn = null;
            }
            catch (IOException e) {
                LOG.warn("{} Failed to close the connection", (Object)this.logPeerId());
            }
        }
        this.exec.shutdown();
        try {
            this.exec.awaitTermination(this.maxTerminationWait, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!this.exec.isTerminated()) {
            String errMsg = "HBaseInterClusterReplicationEndpoint termination failed. The ThreadPoolExecutor failed to finish all tasks within " + this.maxTerminationWait + "ms. Aborting to prevent Replication from deadlocking. See HBASE-16081.";
            this.abortable.abort(errMsg, (Throwable)new IOException(errMsg));
        }
        this.notifyStopped();
    }

    @VisibleForTesting
    protected int replicateEntries(List<WAL.Entry> entries, int batchIndex, int timeout) throws IOException {
        ReplicationSinkManager.SinkPeer sinkPeer = null;
        try {
            int entriesHashCode = System.identityHashCode(entries);
            if (LOG.isTraceEnabled()) {
                long size = entries.stream().mapToLong(this::getEstimatedEntrySize).sum();
                LOG.trace("{} Replicating batch {} of {} entries with total size {} bytes to {}", new Object[]{this.logPeerId(), entriesHashCode, entries.size(), size, this.replicationClusterId});
            }
            sinkPeer = this.replicationSinkMgr.getReplicationSink();
            AdminProtos.AdminService.BlockingInterface rrs = sinkPeer.getRegionServer();
            try {
                ReplicationProtbufUtil.replicateWALEntry(rrs, entries.toArray(new WAL.Entry[entries.size()]), this.replicationClusterId, this.baseNamespaceDir, this.hfileArchiveDir, timeout);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} Completed replicating batch {}", (Object)this.logPeerId(), (Object)entriesHashCode);
                }
            }
            catch (IOException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} Failed replicating batch {}", new Object[]{this.logPeerId(), entriesHashCode, e});
                }
                throw e;
            }
            this.replicationSinkMgr.reportSinkSuccess(sinkPeer);
        }
        catch (IOException ioe) {
            if (sinkPeer != null) {
                this.replicationSinkMgr.reportBadSink(sinkPeer);
            }
            throw ioe;
        }
        return batchIndex;
    }

    private int serialReplicateRegionEntries(List<WAL.Entry> entries, int batchIndex, int timeout) throws IOException {
        int batchSize = 0;
        int index = 0;
        ArrayList<WAL.Entry> batch = new ArrayList<WAL.Entry>();
        for (WAL.Entry entry : entries) {
            int entrySize = this.getEstimatedEntrySize(entry);
            if (batchSize > 0 && batchSize + entrySize > this.replicationRpcLimit) {
                this.replicateEntries(batch, index++, timeout);
                batch.clear();
                batchSize = 0;
            }
            batch.add(entry);
            batchSize += entrySize;
        }
        if (batchSize > 0) {
            this.replicateEntries(batch, index, timeout);
        }
        return batchIndex;
    }

    @VisibleForTesting
    protected Callable<Integer> createReplicator(List<WAL.Entry> entries, int batchIndex, int timeout) {
        return this.isSerial ? () -> this.serialReplicateRegionEntries(entries, batchIndex, timeout) : () -> this.replicateEntries(entries, batchIndex, timeout);
    }

    private String logPeerId() {
        return "[Source for peer " + this.ctx.getPeerId() + "]:";
    }
}

