/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DaemonThreadFactory;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.master.cleaner.CleanerChore;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DirScanPool
implements ConfigurationObserver {
    private static final Logger LOG = LoggerFactory.getLogger(DirScanPool.class);
    private volatile int size;
    private final ThreadPoolExecutor pool;
    private int cleanerLatch;
    private boolean reconfigNotification;

    public DirScanPool(Configuration conf) {
        String poolSize = conf.get("hbase.cleaner.scan.dir.concurrent.size", "0.25");
        this.size = CleanerChore.calculatePoolSize(poolSize);
        this.size = this.size == 0 ? CleanerChore.calculatePoolSize("0.25") : this.size;
        this.pool = DirScanPool.initializePool(this.size);
        LOG.info("Cleaner pool size is {}", (Object)this.size);
        this.cleanerLatch = 0;
    }

    private static ThreadPoolExecutor initializePool(int size) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(size, size, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("dir-scan-pool"));
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    @Override
    public synchronized void onConfigurationChange(Configuration conf) {
        int newSize = CleanerChore.calculatePoolSize(conf.get("hbase.cleaner.scan.dir.concurrent.size", "0.25"));
        if (newSize == this.size) {
            LOG.trace("Size from configuration is same as previous={}, no need to update.", (Object)newSize);
            return;
        }
        this.size = newSize;
        this.reconfigNotification = true;
    }

    synchronized void latchCountUp() {
        ++this.cleanerLatch;
    }

    synchronized void latchCountDown() {
        --this.cleanerLatch;
        this.notifyAll();
    }

    synchronized void execute(Runnable runnable) {
        this.pool.execute(runnable);
    }

    public synchronized void shutdownNow() {
        if (this.pool == null || this.pool.isShutdown()) {
            return;
        }
        this.pool.shutdownNow();
    }

    synchronized void tryUpdatePoolSize(long timeout) {
        if (!this.reconfigNotification) {
            return;
        }
        this.reconfigNotification = false;
        long stopTime = System.currentTimeMillis() + timeout;
        while (this.cleanerLatch != 0 && timeout > 0L) {
            try {
                this.wait(timeout);
                timeout = stopTime - System.currentTimeMillis();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        LOG.info("Update chore's pool size from {} to {}", (Object)this.pool.getPoolSize(), (Object)this.size);
        this.pool.setCorePoolSize(this.size);
    }

    public int getSize() {
        return this.size;
    }
}

