/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.source.kafka;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.hugegraph.loader.source.AbstractSource;
import org.apache.hugegraph.loader.source.SourceType;
import org.apache.hugegraph.loader.source.file.FileFormat;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.loader.source.file.SkippedLine;

public class KafkaSource
extends AbstractSource {
    @JsonProperty(value="bootstrap_server")
    private String bootstrapServer;
    @JsonProperty(value="topic")
    private String topic;
    @JsonProperty(value="group")
    private String group;
    @JsonProperty(value="from_beginning")
    private boolean fromBeginning = false;
    private FileFormat format;
    @JsonProperty(value="delimiter")
    private String delimiter;
    @JsonProperty(value="date_format")
    private String dateFormat;
    @JsonProperty(value="extra_date_formats")
    private List<String> extraDateFormats;
    @JsonProperty(value="time_zone")
    private String timeZone;
    @JsonProperty(value="skipped_line")
    private SkippedLine skippedLine;
    @JsonProperty(value="batch_size")
    private int batchSize = 500;
    @JsonProperty(value="early_stop")
    private boolean earlyStop = false;

    @Override
    public SourceType type() {
        return SourceType.KAFKA;
    }

    @Override
    public FileSource asFileSource() {
        FileSource source = new FileSource();
        source.header(this.header());
        source.charset(this.charset());
        source.listFormat(this.listFormat());
        return source;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaSource)) {
            return false;
        }
        KafkaSource other = (KafkaSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$bootstrapServer = this.getBootstrapServer();
        String other$bootstrapServer = other.getBootstrapServer();
        if (this$bootstrapServer == null ? other$bootstrapServer != null : !this$bootstrapServer.equals(other$bootstrapServer)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        if (this.isFromBeginning() != other.isFromBeginning()) {
            return false;
        }
        FileFormat this$format = this.getFormat();
        FileFormat other$format = other.getFormat();
        if (this$format == null ? other$format != null : !((Object)((Object)this$format)).equals((Object)other$format)) {
            return false;
        }
        String this$delimiter = this.getDelimiter();
        String other$delimiter = other.getDelimiter();
        if (this$delimiter == null ? other$delimiter != null : !this$delimiter.equals(other$delimiter)) {
            return false;
        }
        String this$dateFormat = this.getDateFormat();
        String other$dateFormat = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat)) {
            return false;
        }
        List<String> this$extraDateFormats = this.getExtraDateFormats();
        List<String> other$extraDateFormats = other.getExtraDateFormats();
        if (this$extraDateFormats == null ? other$extraDateFormats != null : !((Object)this$extraDateFormats).equals(other$extraDateFormats)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        SkippedLine this$skippedLine = this.getSkippedLine();
        SkippedLine other$skippedLine = other.getSkippedLine();
        if (this$skippedLine == null ? other$skippedLine != null : !this$skippedLine.equals(other$skippedLine)) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        return this.isEarlyStop() == other.isEarlyStop();
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $bootstrapServer = this.getBootstrapServer();
        result = result * 59 + ($bootstrapServer == null ? 43 : $bootstrapServer.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        result = result * 59 + (this.isFromBeginning() ? 79 : 97);
        FileFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)((Object)$format)).hashCode());
        String $delimiter = this.getDelimiter();
        result = result * 59 + ($delimiter == null ? 43 : $delimiter.hashCode());
        String $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
        List<String> $extraDateFormats = this.getExtraDateFormats();
        result = result * 59 + ($extraDateFormats == null ? 43 : ((Object)$extraDateFormats).hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        SkippedLine $skippedLine = this.getSkippedLine();
        result = result * 59 + ($skippedLine == null ? 43 : $skippedLine.hashCode());
        result = result * 59 + this.getBatchSize();
        result = result * 59 + (this.isEarlyStop() ? 79 : 97);
        return result;
    }

    public String getBootstrapServer() {
        return this.bootstrapServer;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isFromBeginning() {
        return this.fromBeginning;
    }

    public FileFormat getFormat() {
        return this.format;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public List<String> getExtraDateFormats() {
        return this.extraDateFormats;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public SkippedLine getSkippedLine() {
        return this.skippedLine;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isEarlyStop() {
        return this.earlyStop;
    }

    @JsonProperty(value="bootstrap_server")
    public void setBootstrapServer(String bootstrapServer) {
        this.bootstrapServer = bootstrapServer;
    }

    @JsonProperty(value="topic")
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @JsonProperty(value="group")
    public void setGroup(String group) {
        this.group = group;
    }

    @JsonProperty(value="from_beginning")
    public void setFromBeginning(boolean fromBeginning) {
        this.fromBeginning = fromBeginning;
    }

    public void setFormat(FileFormat format) {
        this.format = format;
    }

    @JsonProperty(value="delimiter")
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @JsonProperty(value="date_format")
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @JsonProperty(value="extra_date_formats")
    public void setExtraDateFormats(List<String> extraDateFormats) {
        this.extraDateFormats = extraDateFormats;
    }

    @JsonProperty(value="time_zone")
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @JsonProperty(value="skipped_line")
    public void setSkippedLine(SkippedLine skippedLine) {
        this.skippedLine = skippedLine;
    }

    @JsonProperty(value="batch_size")
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @JsonProperty(value="early_stop")
    public void setEarlyStop(boolean earlyStop) {
        this.earlyStop = earlyStop;
    }

    public String toString() {
        return "KafkaSource(bootstrapServer=" + this.getBootstrapServer() + ", topic=" + this.getTopic() + ", group=" + this.getGroup() + ", fromBeginning=" + this.isFromBeginning() + ", format=" + (Object)((Object)this.getFormat()) + ", delimiter=" + this.getDelimiter() + ", dateFormat=" + this.getDateFormat() + ", extraDateFormats=" + this.getExtraDateFormats() + ", timeZone=" + this.getTimeZone() + ", skippedLine=" + this.getSkippedLine() + ", batchSize=" + this.getBatchSize() + ", earlyStop=" + this.isEarlyStop() + ")";
    }
}

