/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.parser;

import java.util.Map;
import org.apache.hugegraph.loader.exception.ReadException;
import org.apache.hugegraph.loader.parser.LineParser;
import org.apache.hugegraph.loader.reader.line.Line;
import org.apache.hugegraph.loader.util.JsonUtil;
import org.apache.hugegraph.rest.SerializeException;

public class JsonLineParser
implements LineParser {
    @Override
    public Line parse(String[] header, String rawLine) {
        try {
            Map<String, Object> keyValues = JsonUtil.convertMap(rawLine, String.class, Object.class);
            String[] names = JsonLineParser.names(keyValues);
            Object[] values = JsonLineParser.values(keyValues, names);
            return new Line(rawLine, names, values);
        }
        catch (SerializeException e) {
            throw new ReadException(rawLine, "Deserialize line '%s' error", e, rawLine);
        }
    }

    @Override
    public String[] split(String rawLine) {
        throw new UnsupportedOperationException("JsonLineParser.split()");
    }

    private static String[] names(Map<String, Object> keyValues) {
        return keyValues.keySet().toArray(new String[0]);
    }

    private static Object[] values(Map<String, Object> keyValues, String[] names) {
        Object[] values = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            values[i] = keyValues.get(names[i]);
        }
        return values;
    }
}

