/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.metrics;

import java.util.ArrayList;
import java.util.List;

public class RangesTimer {
    private final int capacity;
    private final List<TimeRange> ranges;
    private long lastEnd;
    private long totalTime;

    public RangesTimer(int capacity) {
        this.capacity = capacity;
        this.ranges = new ArrayList<TimeRange>(capacity);
        this.lastEnd = 0L;
        this.totalTime = 0L;
    }

    public synchronized long totalTime() {
        if (!this.ranges.isEmpty()) {
            long incrTime = this.calculate();
            this.totalTime += incrTime;
            this.ranges.clear();
        }
        return this.totalTime;
    }

    public synchronized void addTimeRange(long start, long end) {
        if (this.ranges.size() >= this.capacity) {
            long incrTime = this.calculate();
            this.totalTime += incrTime;
            this.ranges.clear();
        }
        this.ranges.add(new TimeRange(start, end));
    }

    private long calculate() {
        assert (!this.ranges.isEmpty());
        this.ranges.sort((o1, o2) -> (int)(o1.start() - o2.start()));
        long time = 0L;
        long start = this.lastEnd;
        long end = this.lastEnd;
        for (TimeRange range : this.ranges) {
            if (range.start() <= end) {
                end = Math.max(end, range.end());
            } else {
                time += end - start;
                start = range.start();
                end = range.end();
            }
            this.lastEnd = Math.max(this.lastEnd, end);
        }
        return time += end - start;
    }

    private static class TimeRange {
        private final long start;
        private final long end;

        public TimeRange(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long start() {
            return this.start;
        }

        public long end() {
            return this.end;
        }
    }
}

