/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.mapping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.loader.constant.Checkable;
import org.apache.hugegraph.loader.constant.Constants;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.mapping.BackendStoreInfo;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.loader.util.JsonUtil;
import org.apache.hugegraph.loader.util.LoadUtil;
import org.apache.hugegraph.loader.util.MappingUtil;
import org.apache.hugegraph.util.E;

@JsonPropertyOrder(value={"version", "structs"})
public class LoadMapping
implements Checkable {
    @JsonProperty(value="version")
    private String version = "2.0";
    @JsonProperty(value="structs")
    private List<InputStruct> structs;
    @JsonProperty(value="backendStoreInfo")
    private BackendStoreInfo backendStoreInfo;

    public BackendStoreInfo getBackendStoreInfo() {
        return this.backendStoreInfo;
    }

    public static LoadMapping of(String filePath) {
        LoadMapping mapping;
        File file = FileUtils.getFile((String[])new String[]{filePath});
        try {
            String json = FileUtils.readFileToString((File)file, (Charset)Constants.CHARSET);
            mapping = MappingUtil.parse(json);
        }
        catch (IOException e) {
            throw new LoadException("Failed to read mapping mapping file '%s'", (Throwable)e, filePath);
        }
        catch (IllegalArgumentException e) {
            throw new LoadException("Failed to parse mapping mapping file '%s'", (Throwable)e, filePath);
        }
        try {
            mapping.check();
        }
        catch (IllegalArgumentException e) {
            throw new LoadException("Invalid mapping file '%s'", (Throwable)e, filePath);
        }
        return mapping;
    }

    public LoadMapping(@JsonProperty(value="structs") List<InputStruct> structs) {
        this.structs = structs;
    }

    @JsonCreator
    public LoadMapping(@JsonProperty(value="structs") List<InputStruct> structs, @JsonProperty(value="backendStoreInfo") BackendStoreInfo backendStoreInfo) {
        this.structs = structs;
        this.backendStoreInfo = backendStoreInfo;
    }

    @Override
    public void check() throws IllegalArgumentException {
        E.checkArgument((!StringUtils.isEmpty((CharSequence)this.version) ? 1 : 0) != 0, (String)"The version can't be null or empty", (Object[])new Object[0]);
        E.checkArgument((boolean)this.version.equals("2.0"), (String)"The version must be '%s', but got '%s'", (Object[])new Object[]{"2.0", this.version});
        E.checkArgument((!CollectionUtils.isEmpty(this.structs) ? 1 : 0) != 0, (String)"The structs can't be null or empty", (Object[])new Object[0]);
        this.structs.forEach(InputStruct::check);
        Set uniqueIds = this.structs.stream().map(InputStruct::id).collect(Collectors.toSet());
        E.checkArgument((this.structs.size() == uniqueIds.size() ? 1 : 0) != 0, (String)"The structs cannot contain the same id mapping", (Object[])new Object[0]);
    }

    public List<InputStruct> structs() {
        return this.structs;
    }

    public List<InputStruct> structsForFailure(LoadOptions options) {
        ArrayList<InputStruct> targetStructs = new ArrayList<InputStruct>();
        String dir = LoadUtil.getStructDirPrefix(options);
        String path = Paths.get(dir, "failure-data").toString();
        File pathDir = FileUtils.getFile((String[])new String[]{path});
        if (!pathDir.exists()) {
            return targetStructs;
        }
        Map<String, FailureFile> failureFiles = this.groupFailureFiles(pathDir);
        for (String inputId : failureFiles.keySet()) {
            InputStruct struct = this.struct(inputId);
            String charset = struct.input().charset();
            FailureFile failureFile = failureFiles.get(inputId);
            FileSource source = struct.input().asFileSource();
            if (failureFile.headerFile != null) {
                String json;
                try {
                    json = FileUtils.readFileToString((File)failureFile.headerFile, (String)charset);
                }
                catch (IOException e) {
                    throw new LoadException("Failed to read header file %s", failureFile.headerFile);
                }
                List<String> header = JsonUtil.convertList(json, String.class);
                source.header(header.toArray(new String[0]));
            }
            source.path(failureFile.dataFile.getAbsolutePath());
            source.skippedLine().regex("(^#|^//).*|");
            struct.input(source);
            targetStructs.add(struct);
        }
        return targetStructs;
    }

    private Map<String, FailureFile> groupFailureFiles(File pathDir) {
        File[] subFiles = pathDir.listFiles();
        E.checkArgument((subFiles != null && subFiles.length >= 1 ? 1 : 0) != 0, (String)"Every input struct should have a failure data file, and a header file if need it", (Object[])new Object[0]);
        LinkedHashMap<String, FailureFile> failureFiles = new LinkedHashMap<String, FailureFile>();
        for (File subFile : subFiles) {
            String inputId = LoadUtil.getFileNamePrefix(subFile);
            String suffix = LoadUtil.getFileNameSuffix(subFile);
            FailureFile failureFile = (FailureFile)failureFiles.get(inputId);
            if (failureFile == null) {
                failureFile = new FailureFile();
            }
            if (".error".equals(suffix)) {
                failureFile.dataFile = subFile;
            } else {
                E.checkArgument((boolean)".header".equals(suffix), (String)"The failure data file must end with %s or %s", (Object[])new Object[]{".error", ".header"});
                failureFile.headerFile = subFile;
            }
            failureFiles.put(inputId, failureFile);
        }
        return failureFiles;
    }

    public InputStruct struct(String id) {
        for (InputStruct struct : this.structs) {
            if (!struct.id().equals(id)) continue;
            return struct;
        }
        throw new IllegalArgumentException(String.format("There is no input struct with id '%s'", id));
    }

    private static class FailureFile {
        private File headerFile;
        private File dataFile;

        private FailureFile() {
        }
    }
}

