/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.direct.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HRegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.tool.BulkLoadHFilesTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.util.Log;
import org.apache.spark.Partitioner;
import org.slf4j.Logger;
import scala.Tuple2;

public class SinkToHBase
implements Serializable {
    private final LoadOptions loadOptions;
    public static final Logger LOG = Log.logger(SinkToHBase.class);

    public SinkToHBase(LoadOptions loadOptions) {
        this.loadOptions = loadOptions;
    }

    public Optional<Configuration> getHBaseConfiguration() {
        Configuration baseConf = HBaseConfiguration.create();
        baseConf.set("hbase.zookeeper.quorum", this.loadOptions.hbaseZKQuorum);
        baseConf.set("hbase.zookeeper.property.clientPort", this.loadOptions.hbaseZKPort);
        baseConf.set("zookeeper.znode.parent", this.loadOptions.hbaseZKParent);
        return Optional.of(baseConf);
    }

    private Optional<Connection> getConnection() {
        Optional<Configuration> baseConf = this.getHBaseConfiguration();
        Connection conn = null;
        try {
            conn = ConnectionFactory.createConnection((Configuration)baseConf.get());
        }
        catch (IOException e) {
            LOG.error("get hbase connection failed", (Throwable)e);
        }
        return Optional.ofNullable(conn);
    }

    public Tuple2<IntPartitioner, TableDescriptor> getPartitionerByTableName(int numPartitions, String tableName) throws IOException {
        Optional<Connection> optionalConnection = this.getConnection();
        TableDescriptor descriptor = optionalConnection.get().getTable(TableName.valueOf((String)tableName)).getDescriptor();
        LOG.debug("getPartitionerByTableName get TableDescriptor " + descriptor.getTableName());
        optionalConnection.get().close();
        return new Tuple2((Object)new IntPartitioner(numPartitions, tableName), (Object)descriptor);
    }

    public void loadHfiles(String path, String tableName) throws Exception {
        Connection conn = this.getConnection().get();
        Table table = conn.getTable(TableName.valueOf((String)tableName));
        Configuration conf = conn.getConfiguration();
        BulkLoadHFilesTool bulkLoadHFilesTool = new BulkLoadHFilesTool(conf);
        bulkLoadHFilesTool.bulkLoad(table.getName(), new Path(path));
        table.close();
        conn.close();
    }

    public class IntPartitioner
    extends Partitioner {
        private final int numPartitions;
        public Map<List<String>, Integer> rangeMap;
        private String tableName;

        public IntPartitioner(int numPartitions, String tableName) throws IOException {
            this.numPartitions = numPartitions;
            this.rangeMap = this.getRangeMap(tableName);
            this.tableName = tableName;
        }

        private Map<List<String>, Integer> getRangeMap(String tableName) throws IOException {
            Connection conn = (Connection)SinkToHBase.this.getConnection().get();
            HRegionLocator locator = (HRegionLocator)conn.getRegionLocator(TableName.valueOf((String)tableName));
            Pair startEndKeys = locator.getStartEndKeys();
            HashMap<List<String>, Integer> rangeMap = new HashMap<List<String>, Integer>();
            for (int i = 0; i < ((byte[][])startEndKeys.getFirst()).length; ++i) {
                String startKey = Bytes.toString((byte[])((byte[][])startEndKeys.getFirst())[i]);
                String endKey = Bytes.toString((byte[])((byte[][])startEndKeys.getSecond())[i]);
                rangeMap.put(new ArrayList<String>(Arrays.asList(startKey, endKey)), i);
            }
            conn.close();
            return rangeMap;
        }

        public int numPartitions() {
            return this.numPartitions;
        }

        public int getPartition(Object key) {
            if (key instanceof ImmutableBytesWritable) {
                try {
                    ImmutableBytesWritable immutableBytesWritableKey = (ImmutableBytesWritable)key;
                    if (this.rangeMap == null || this.rangeMap.isEmpty()) {
                        this.rangeMap = this.getRangeMap(this.tableName);
                    }
                    String keyString = Bytes.toString((byte[])immutableBytesWritableKey.get());
                    for (List<String> range : this.rangeMap.keySet()) {
                        if (keyString.compareToIgnoreCase(range.get(0)) < 0 || keyString.compareToIgnoreCase(range.get(1)) >= 0 && !"".equals(range.get(1))) continue;
                        return this.rangeMap.get(range);
                    }
                    LOG.error("Didn't find proper key in rangeMap, so returning 0 ...");
                    return 0;
                }
                catch (Exception e) {
                    LOG.error("When trying to get partitionID, encountered exception: {} \t key = {}", (Object)e, key);
                    return 0;
                }
            }
            LOG.error("key is NOT ImmutableBytesWritable type ...");
            return 0;
        }
    }
}

