/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.reader.jdbc;

import java.sql.SQLException;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hugegraph.loader.exception.InitException;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.reader.AbstractReader;
import org.apache.hugegraph.loader.reader.jdbc.RowFetcher;
import org.apache.hugegraph.loader.reader.line.Line;
import org.apache.hugegraph.loader.source.jdbc.JDBCSource;

public class JDBCReader
extends AbstractReader {
    private final JDBCSource source;
    private final RowFetcher fetcher;
    private List<Line> batch;
    private int offsetInBatch;

    public JDBCReader(JDBCSource source) {
        this.source = source;
        try {
            this.fetcher = new RowFetcher(source);
        }
        catch (Exception e) {
            throw new LoadException("Failed to connect database via '%s'", (Throwable)e, source.url());
        }
        this.batch = null;
        this.offsetInBatch = 0;
    }

    public JDBCSource source() {
        return this.source;
    }

    @Override
    public void init(LoadContext context, InputStruct struct) throws InitException {
        this.progress(context, struct);
        if (!this.source.existsCustomSQL()) {
            try {
                this.source.header(this.fetcher.readHeader());
                this.fetcher.readPrimaryKey();
            }
            catch (SQLException e) {
                throw new InitException("Failed to fetch table structure info", e);
            }
        }
    }

    @Override
    public void confirmOffset() {
    }

    @Override
    public boolean hasNext() {
        if (this.batch == null || this.offsetInBatch >= this.batch.size()) {
            try {
                this.batch = this.fetcher.nextBatch();
                this.offsetInBatch = 0;
            }
            catch (Exception e) {
                throw new LoadException("Error while reading the next row", e);
            }
        }
        return this.batch != null && !this.batch.isEmpty();
    }

    @Override
    public Line next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Reached end of table");
        }
        return this.batch.get(this.offsetInBatch++);
    }

    @Override
    public void close() {
        this.fetcher.close();
    }
}

