/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;

public final class HubbleUtil {
    public static final Pattern HOST_PATTERN = Pattern.compile("(([0-9]{1,3}\\.){3}[0-9]{1,3}|([0-9A-Za-z_!~*'()-]+\\.)*[0-9A-Za-z_!~*'()-]+)$");

    public static Date nowDate() {
        return new Date();
    }

    public static Instant nowTime() {
        return Instant.now();
    }

    public static boolean equalCollection(Collection<?> c1, Collection<?> c2) {
        if (c1 != null && c2 == null || c1 == null && c2 != null) {
            return false;
        }
        return c1 == null || CollectionUtils.isEqualCollection(c1, c2);
    }

    public static String generateSimpleId() {
        return UUID.randomUUID().toString();
    }

    public static String md5(String rawText) {
        return DigestUtils.md5Hex((String)rawText);
    }
}

