/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.handler;

import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.hugegraph.entity.UserInfo;
import org.apache.hugegraph.service.UserInfoService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.WebUtils;

@Component
public class MessageSourceHandler {
    private static final Logger log = LogManager.getLogger(MessageSourceHandler.class);
    private static final Locale DEFAULT_LOCALE = Locale.SIMPLIFIED_CHINESE;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private UserInfoService service;

    public String getMessage(String message, Object ... args) {
        Locale locale = this.getLocale();
        try {
            return this.messageSource.getMessage(message, args, locale);
        }
        catch (NoSuchMessageException e) {
            log.error("There is no message for key '{}'", (Object)message);
            return message;
        }
    }

    private Locale getLocale() {
        try {
            RequestContextHolder.currentRequestAttributes();
        }
        catch (IllegalStateException e) {
            return DEFAULT_LOCALE;
        }
        UserInfo userInfo = this.getUserInfo();
        if (userInfo != null && userInfo.getLocale() != null) {
            return LocaleUtils.toLocale((String)userInfo.getLocale());
        }
        if (this.request.getLocale() != null) {
            return RequestContextUtils.getLocale((HttpServletRequest)this.request);
        }
        return LocaleContextHolder.getLocale();
    }

    private UserInfo getUserInfo() {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)this.request, (String)"user");
        if (cookie == null || cookie.getValue() == null) {
            return null;
        }
        String username = cookie.getValue();
        return this.service.getByName(username);
    }
}

