/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.entity.load;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import org.apache.hugegraph.annotation.MergeProperty;
import org.apache.hugegraph.common.Constant;
import org.apache.hugegraph.common.Mergeable;
import org.apache.hugegraph.entity.load.ListFormat;

public class FileSetting
implements Mergeable {
    @MergeProperty
    @JsonProperty(value="has_header")
    private boolean hasHeader;
    @JsonProperty(value="column_names")
    private List<String> columnNames;
    @JsonProperty(value="column_values")
    private List<String> columnValues;
    @MergeProperty
    @JsonProperty(value="format")
    private String format = "CSV";
    @MergeProperty
    @JsonProperty(value="delimiter")
    @JsonSerialize(using=DelimiterSerializer.class)
    @JsonDeserialize(using=DelimiterDeserializer.class)
    private String delimiter = ",";
    @MergeProperty
    @JsonProperty(value="charset")
    private String charset = Constant.CHARSET.name();
    @MergeProperty
    @JsonProperty(value="date_format")
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";
    @MergeProperty
    @JsonProperty(value="time_zone")
    private String timeZone = "GMT+8";
    @MergeProperty
    @JsonProperty(value="skipped_line")
    private String skippedLine = "(^#|^//).*|";
    @MergeProperty
    @JsonProperty(value="list_format")
    private ListFormat listFormat = new ListFormat();

    public void changeFormatIfNeeded() {
        if (!",".equals(this.delimiter)) {
            this.format = "TEXT";
        }
    }

    public static FileSettingBuilder builder() {
        return new FileSettingBuilder();
    }

    public boolean isHasHeader() {
        return this.hasHeader;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<String> getColumnValues() {
        return this.columnValues;
    }

    public String getFormat() {
        return this.format;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getSkippedLine() {
        return this.skippedLine;
    }

    public ListFormat getListFormat() {
        return this.listFormat;
    }

    @JsonProperty(value="has_header")
    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    @JsonProperty(value="column_names")
    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    @JsonProperty(value="column_values")
    public void setColumnValues(List<String> columnValues) {
        this.columnValues = columnValues;
    }

    @JsonProperty(value="format")
    public void setFormat(String format) {
        this.format = format;
    }

    @JsonProperty(value="delimiter")
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @JsonProperty(value="charset")
    public void setCharset(String charset) {
        this.charset = charset;
    }

    @JsonProperty(value="date_format")
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @JsonProperty(value="time_zone")
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @JsonProperty(value="skipped_line")
    public void setSkippedLine(String skippedLine) {
        this.skippedLine = skippedLine;
    }

    @JsonProperty(value="list_format")
    public void setListFormat(ListFormat listFormat) {
        this.listFormat = listFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSetting)) {
            return false;
        }
        FileSetting other = (FileSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasHeader() != other.isHasHeader()) {
            return false;
        }
        List<String> this$columnNames = this.getColumnNames();
        List<String> other$columnNames = other.getColumnNames();
        if (this$columnNames == null ? other$columnNames != null : !((Object)this$columnNames).equals(other$columnNames)) {
            return false;
        }
        List<String> this$columnValues = this.getColumnValues();
        List<String> other$columnValues = other.getColumnValues();
        if (this$columnValues == null ? other$columnValues != null : !((Object)this$columnValues).equals(other$columnValues)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$delimiter = this.getDelimiter();
        String other$delimiter = other.getDelimiter();
        if (this$delimiter == null ? other$delimiter != null : !this$delimiter.equals(other$delimiter)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        String this$dateFormat = this.getDateFormat();
        String other$dateFormat = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        String this$skippedLine = this.getSkippedLine();
        String other$skippedLine = other.getSkippedLine();
        if (this$skippedLine == null ? other$skippedLine != null : !this$skippedLine.equals(other$skippedLine)) {
            return false;
        }
        ListFormat this$listFormat = this.getListFormat();
        ListFormat other$listFormat = other.getListFormat();
        return !(this$listFormat == null ? other$listFormat != null : !this$listFormat.equals(other$listFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileSetting;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasHeader() ? 79 : 97);
        List<String> $columnNames = this.getColumnNames();
        result = result * 59 + ($columnNames == null ? 43 : ((Object)$columnNames).hashCode());
        List<String> $columnValues = this.getColumnValues();
        result = result * 59 + ($columnValues == null ? 43 : ((Object)$columnValues).hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $delimiter = this.getDelimiter();
        result = result * 59 + ($delimiter == null ? 43 : $delimiter.hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        String $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        String $skippedLine = this.getSkippedLine();
        result = result * 59 + ($skippedLine == null ? 43 : $skippedLine.hashCode());
        ListFormat $listFormat = this.getListFormat();
        result = result * 59 + ($listFormat == null ? 43 : $listFormat.hashCode());
        return result;
    }

    public String toString() {
        return "FileSetting(hasHeader=" + this.isHasHeader() + ", columnNames=" + this.getColumnNames() + ", columnValues=" + this.getColumnValues() + ", format=" + this.getFormat() + ", delimiter=" + this.getDelimiter() + ", charset=" + this.getCharset() + ", dateFormat=" + this.getDateFormat() + ", timeZone=" + this.getTimeZone() + ", skippedLine=" + this.getSkippedLine() + ", listFormat=" + this.getListFormat() + ")";
    }

    public FileSetting() {
    }

    public FileSetting(boolean hasHeader, List<String> columnNames, List<String> columnValues, String format, String delimiter, String charset, String dateFormat, String timeZone, String skippedLine, ListFormat listFormat) {
        this.hasHeader = hasHeader;
        this.columnNames = columnNames;
        this.columnValues = columnValues;
        this.format = format;
        this.delimiter = delimiter;
        this.charset = charset;
        this.dateFormat = dateFormat;
        this.timeZone = timeZone;
        this.skippedLine = skippedLine;
        this.listFormat = listFormat;
    }

    public static class FileSettingBuilder {
        private boolean hasHeader;
        private List<String> columnNames;
        private List<String> columnValues;
        private String format;
        private String delimiter;
        private String charset;
        private String dateFormat;
        private String timeZone;
        private String skippedLine;
        private ListFormat listFormat;

        FileSettingBuilder() {
        }

        @JsonProperty(value="has_header")
        public FileSettingBuilder hasHeader(boolean hasHeader) {
            this.hasHeader = hasHeader;
            return this;
        }

        @JsonProperty(value="column_names")
        public FileSettingBuilder columnNames(List<String> columnNames) {
            this.columnNames = columnNames;
            return this;
        }

        @JsonProperty(value="column_values")
        public FileSettingBuilder columnValues(List<String> columnValues) {
            this.columnValues = columnValues;
            return this;
        }

        @JsonProperty(value="format")
        public FileSettingBuilder format(String format) {
            this.format = format;
            return this;
        }

        @JsonProperty(value="delimiter")
        public FileSettingBuilder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        @JsonProperty(value="charset")
        public FileSettingBuilder charset(String charset) {
            this.charset = charset;
            return this;
        }

        @JsonProperty(value="date_format")
        public FileSettingBuilder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        @JsonProperty(value="time_zone")
        public FileSettingBuilder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        @JsonProperty(value="skipped_line")
        public FileSettingBuilder skippedLine(String skippedLine) {
            this.skippedLine = skippedLine;
            return this;
        }

        @JsonProperty(value="list_format")
        public FileSettingBuilder listFormat(ListFormat listFormat) {
            this.listFormat = listFormat;
            return this;
        }

        public FileSetting build() {
            return new FileSetting(this.hasHeader, this.columnNames, this.columnValues, this.format, this.delimiter, this.charset, this.dateFormat, this.timeZone, this.skippedLine, this.listFormat);
        }

        public String toString() {
            return "FileSetting.FileSettingBuilder(hasHeader=" + this.hasHeader + ", columnNames=" + this.columnNames + ", columnValues=" + this.columnValues + ", format=" + this.format + ", delimiter=" + this.delimiter + ", charset=" + this.charset + ", dateFormat=" + this.dateFormat + ", timeZone=" + this.timeZone + ", skippedLine=" + this.skippedLine + ", listFormat=" + this.listFormat + ")";
        }
    }

    public static class DelimiterDeserializer
    extends StdDeserializer<String> {
        protected DelimiterDeserializer() {
            super(String.class);
        }

        public String deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            String delimiter = jsonParser.getText();
            if ("\\t".equals(delimiter)) {
                return "\t";
            }
            return delimiter;
        }
    }

    public static class DelimiterSerializer
    extends StdSerializer<String> {
        protected DelimiterSerializer() {
            super(String.class);
        }

        public void serialize(String delimiter, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            if ("\t".equals(delimiter)) {
                jsonGenerator.writeString("\\t");
            } else {
                jsonGenerator.writeString(delimiter);
            }
        }
    }
}

