/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.controller.schema;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.common.Constant;
import org.apache.hugegraph.controller.schema.SchemaController;
import org.apache.hugegraph.entity.schema.ConflictCheckEntity;
import org.apache.hugegraph.entity.schema.ConflictDetail;
import org.apache.hugegraph.entity.schema.EdgeLabelEntity;
import org.apache.hugegraph.entity.schema.EdgeLabelStyle;
import org.apache.hugegraph.entity.schema.EdgeLabelUpdateEntity;
import org.apache.hugegraph.entity.schema.VertexLabelEntity;
import org.apache.hugegraph.service.schema.EdgeLabelService;
import org.apache.hugegraph.service.schema.PropertyIndexService;
import org.apache.hugegraph.service.schema.PropertyKeyService;
import org.apache.hugegraph.service.schema.VertexLabelService;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.Ex;
import org.apache.hugegraph.util.HubbleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1.2/graph-connections/{connId}/schema/edgelabels"})
public class EdgeLabelController
extends SchemaController {
    private static final List<String> PRESET_COLORS = ImmutableList.of((Object)"#2B65FF", (Object)"#0EB880", (Object)"#76C100", (Object)"#ED7600", (Object)"#E65055", (Object)"#A64EE6", (Object)"#108CEE", (Object)"#00B5D9", (Object)"#F2CA00", (Object)"#E048AE", (Object)"#5C73E6", (Object)"#569380", (Object[])new String[]{"#76C100", "#FE9227", "#FE585D", "#FD6ACE", "#4D8DDA", "#57C7E3", "#F2CA00", "#C570FF"});
    @Autowired
    private PropertyKeyService pkService;
    @Autowired
    private PropertyIndexService piService;
    @Autowired
    private VertexLabelService vlService;
    @Autowired
    private EdgeLabelService elService;

    @GetMapping(value={"optional-colors"})
    public List<String> getOptionalColors(@PathVariable(value="connId") int connId) {
        return PRESET_COLORS;
    }

    @GetMapping
    public IPage<EdgeLabelEntity> list(@PathVariable(value="connId") int connId, @RequestParam(name="content", required=false) String content, @RequestParam(name="name_order", required=false) String nameOrder, @RequestParam(name="page_no", required=false, defaultValue="1") int pageNo, @RequestParam(name="page_size", required=false, defaultValue="10") int pageSize) {
        return this.listInPage(id -> this.elService.list((int)id), connId, content, nameOrder, pageNo, pageSize);
    }

    @GetMapping(value={"{name}"})
    public EdgeLabelEntity get(@PathVariable(value="connId") int connId, @PathVariable(value="name") String name) {
        return this.elService.get(name, connId);
    }

    @PostMapping
    public void create(@PathVariable(value="connId") int connId, @RequestBody EdgeLabelEntity entity) {
        this.checkParamsValid(entity, connId, true);
        this.checkEntityUnique(entity, connId, true);
        entity.setCreateTime(HubbleUtil.nowDate());
        this.elService.add(entity, connId);
    }

    @PostMapping(value={"check_conflict"})
    public ConflictDetail checkConflict(@PathVariable(value="connId") int connId, @RequestParam(value="reused_conn_id") int reusedConnId, @RequestBody ConflictCheckEntity entity) {
        Ex.check(!CollectionUtils.isEmpty(entity.getElEntities()), "common.param.cannot-be-empty", "edgelabels");
        Ex.check(CollectionUtils.isEmpty(entity.getPkEntities()), "common.param.must-be-null", "propertykeys");
        Ex.check(CollectionUtils.isEmpty(entity.getPiEntities()), "common.param.must-be-null", "propertyindexes");
        Ex.check(CollectionUtils.isEmpty(entity.getVlEntities()), "common.param.must-be-null", "vertexlabels");
        Ex.check(connId != reusedConnId, "schema.conn.cannot-reuse-self", new Object[0]);
        HashSet<String> pkNames = new HashSet<String>();
        HashSet<String> piNames = new HashSet<String>();
        HashSet<String> vlNames = new HashSet<String>();
        for (EdgeLabelEntity e : entity.getElEntities()) {
            pkNames.addAll(e.getPropNames());
            piNames.addAll(e.getIndexProps());
            vlNames.addAll(e.getLinkLabels());
        }
        List<VertexLabelEntity> vlEntities = this.vlService.list(vlNames, reusedConnId, false);
        for (VertexLabelEntity e : vlEntities) {
            pkNames.addAll(e.getPropNames());
            piNames.addAll(e.getIndexProps());
        }
        entity.setPkEntities(this.pkService.list(pkNames, reusedConnId, false));
        entity.setPiEntities(this.piService.list(piNames, reusedConnId, false));
        entity.setVlEntities(vlEntities);
        return this.elService.checkConflict(entity, connId, false);
    }

    @PostMapping(value={"recheck_conflict"})
    public ConflictDetail recheckConflict(@PathVariable(value="connId") int connId, @RequestBody ConflictCheckEntity entity) {
        Ex.check(!CollectionUtils.isEmpty(entity.getElEntities()), "common.param.cannot-be-empty", "edgelabels");
        return this.elService.checkConflict(entity, connId, true);
    }

    @PostMapping(value={"reuse"})
    public void reuse(@PathVariable(value="connId") int connId, @RequestBody ConflictDetail detail) {
        this.elService.reuse(detail, connId);
    }

    @PutMapping(value={"{name}"})
    public void update(@PathVariable(value="connId") int connId, @PathVariable(value="name") String name, @RequestBody EdgeLabelUpdateEntity entity) {
        Ex.check(!StringUtils.isEmpty((Object)name), "common.param.cannot-be-null-or-empty", name);
        entity.setName(name);
        this.elService.checkExist(name, connId);
        EdgeLabelController.checkParamsValid(this.pkService, entity, connId);
        this.elService.update(entity, connId);
    }

    @DeleteMapping
    public void delete(@PathVariable(value="connId") int connId, @RequestParam(value="names") List<String> names) {
        for (String name : names) {
            this.elService.checkExist(name, connId);
            this.elService.remove(name, connId);
        }
    }

    private void checkParamsValid(EdgeLabelEntity entity, int connId, boolean checkCreateTime) {
        String name = entity.getName();
        Ex.check(name != null, "common.param.cannot-be-null", "name");
        Ex.check(Constant.SCHEMA_NAME_PATTERN.matcher(name).matches(), "schema.edgelabel.unmatch-regex", new Object[0]);
        Ex.check(checkCreateTime, () -> entity.getCreateTime() == null, "common.param.must-be-null", "create_time");
        this.checkRelation(entity, connId);
        EdgeLabelController.checkProperties(this.pkService, entity.getProperties(), false, connId);
        this.checkSortKeys(entity);
        EdgeLabelController.checkPropertyIndexes(entity, connId);
        EdgeLabelController.checkDisplayFields(entity);
    }

    private void checkRelation(EdgeLabelEntity entity, int connId) {
        String sourceLabel = entity.getSourceLabel();
        String targetLabel = entity.getTargetLabel();
        Ex.check(!StringUtils.isEmpty((Object)sourceLabel), "common.param.cannot-be-null-or-empty", "edgelabel.source_label");
        Ex.check(!StringUtils.isEmpty((Object)targetLabel), "common.param.cannot-be-null-or-empty", "edgelabel.target_label");
        this.vlService.checkExist(sourceLabel, connId);
        this.vlService.checkExist(targetLabel, connId);
    }

    private void checkSortKeys(EdgeLabelEntity entity) {
        List<String> sortKeys = entity.getSortKeys();
        if (entity.isLinkMultiTimes()) {
            Ex.check(!CollectionUtils.isEmpty(entity.getProperties()), "schema.edgelabel.property.cannot-be-null-or-empty", entity.getName());
            Ex.check(!CollectionUtils.isEmpty(sortKeys), "schema.edgelabel.sortkey.cannot-be-null-or-empty", entity.getName());
            Set<String> propNames = entity.getPropNames();
            Ex.check(propNames.containsAll(sortKeys), "schema.edgelabel.sortkey.must-belong-to.property", entity.getName(), sortKeys, propNames);
            Ex.check(!CollectionUtil.hasIntersection(sortKeys, entity.getNullableProps()), "schmea.edgelabel.sortkey.cannot-be-nullable", entity.getName());
        } else {
            Ex.check(CollectionUtils.isEmpty(sortKeys), "schema.edgelabel.sortkey.should-be-null-or-empty", entity.getName());
        }
    }

    private static void checkDisplayFields(EdgeLabelEntity entity) {
        EdgeLabelStyle style = entity.getStyle();
        List<String> displayFields = style.getDisplayFields();
        if (!CollectionUtils.isEmpty(displayFields)) {
            Set<String> nullableProps = entity.getNullableProps();
            Ex.check(!CollectionUtil.hasIntersection(displayFields, nullableProps), "schema.display-fields.cannot-be-nullable", new Object[0]);
        }
    }

    private void checkEntityUnique(EdgeLabelEntity newEntity, int connId, boolean creating) {
        String name = newEntity.getName();
        this.elService.checkNotExist(name, connId);
    }
}

