/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.controller.query;

import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hugegraph.controller.query.GremlinController;
import org.apache.hugegraph.entity.enums.AsyncTaskStatus;
import org.apache.hugegraph.entity.enums.ExecuteStatus;
import org.apache.hugegraph.entity.enums.ExecuteType;
import org.apache.hugegraph.entity.query.AdjacentQuery;
import org.apache.hugegraph.entity.query.ExecuteHistory;
import org.apache.hugegraph.entity.query.GremlinQuery;
import org.apache.hugegraph.entity.query.GremlinResult;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.service.query.ExecuteHistoryService;
import org.apache.hugegraph.service.query.GremlinQueryService;
import org.apache.hugegraph.util.Ex;
import org.apache.hugegraph.util.HubbleUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1.2/graph-connections/{connId}/gremlin-query"})
public class GremlinQueryController
extends GremlinController {
    private static final Logger log = LogManager.getLogger(GremlinQueryController.class);
    private static final Set<String> CONDITION_OPERATORS = ImmutableSet.of((Object)"eq", (Object)"gt", (Object)"gte", (Object)"lt", (Object)"lte");
    @Autowired
    private GremlinQueryService queryService;
    @Autowired
    private ExecuteHistoryService historyService;

    @PostMapping
    public GremlinResult execute(@PathVariable(value="connId") int connId, @RequestBody GremlinQuery query) {
        this.checkParamsValid(query);
        Date createTime = HubbleUtil.nowDate();
        ExecuteStatus status = ExecuteStatus.RUNNING;
        ExecuteHistory history = new ExecuteHistory(null, connId, 0L, ExecuteType.GREMLIN, query.getContent(), status, AsyncTaskStatus.UNKNOWN, -1L, createTime);
        this.historyService.save(history);
        StopWatch timer = StopWatch.createStarted();
        try {
            GremlinResult result = this.queryService.executeQuery(connId, query);
            status = ExecuteStatus.SUCCESS;
            GremlinResult gremlinResult = result;
            return gremlinResult;
        }
        catch (Throwable e) {
            status = ExecuteStatus.FAILED;
            throw e;
        }
        finally {
            timer.stop();
            long duration = timer.getTime(TimeUnit.MILLISECONDS);
            history.setStatus(status);
            history.setDuration(duration);
            this.historyService.update(history);
        }
    }

    @PostMapping(value={"async-task"})
    public ExecuteStatus executeAsyncTask(@PathVariable(value="connId") int connId, @RequestBody GremlinQuery query) {
        this.checkParamsValid(query);
        Date createTime = HubbleUtil.nowDate();
        ExecuteStatus status = ExecuteStatus.ASYNC_TASK_RUNNING;
        ExecuteHistory history = new ExecuteHistory(null, connId, 0L, ExecuteType.GREMLIN_ASYNC, query.getContent(), status, AsyncTaskStatus.UNKNOWN, -1L, createTime);
        this.historyService.save(history);
        StopWatch timer = StopWatch.createStarted();
        long asyncId = 0L;
        try {
            asyncId = this.queryService.executeAsyncTask(connId, query);
            ExecuteStatus executeStatus = status = ExecuteStatus.ASYNC_TASK_SUCCESS;
            return executeStatus;
        }
        catch (Throwable e) {
            status = ExecuteStatus.ASYNC_TASK_FAILED;
            throw e;
        }
        finally {
            timer.stop();
            long duration = timer.getTime(TimeUnit.MILLISECONDS);
            history.setStatus(status);
            history.setDuration(duration);
            history.setAsyncId(asyncId);
            this.historyService.update(history);
        }
    }

    @PutMapping
    public GremlinResult expand(@PathVariable(value="connId") int connId, @RequestBody AdjacentQuery query) {
        this.checkParamsValid(query);
        try {
            return this.queryService.expandVertex(connId, query);
        }
        catch (Exception e) {
            Throwable rootCause = Ex.rootCause(e);
            throw new ExternalException("gremlin.expand.failed", rootCause, rootCause.getMessage());
        }
    }

    private void checkParamsValid(GremlinQuery query) {
        Ex.check(!StringUtils.isEmpty((CharSequence)query.getContent()), "common.param.cannot-be-null-or-empty", "gremlin-query.content");
        GremlinQueryController.checkContentLength(query.getContent());
    }

    private void checkParamsValid(AdjacentQuery query) {
        Ex.check(!StringUtils.isEmpty((CharSequence)query.getVertexId()), "common.param.cannot-be-null-or-empty", "vertex_id");
        Ex.check(!StringUtils.isEmpty((CharSequence)query.getVertexLabel()), "common.param.cannot-be-null-or-empty", "vertex_label");
        if (query.getConditions() != null && !query.getConditions().isEmpty()) {
            for (AdjacentQuery.Condition condition : query.getConditions()) {
                Ex.check(!StringUtils.isEmpty((CharSequence)condition.getKey()), "common.param.cannot-be-null-or-empty", "condition.key");
                Ex.check(!StringUtils.isEmpty((CharSequence)condition.getOperator()), "common.param.cannot-be-null-or-empty", "condition.operator");
                Ex.check(CONDITION_OPERATORS.contains(condition.getOperator()), "common.param.should-belong-to", "condition.operator", CONDITION_OPERATORS);
                Ex.check(condition.getValue() != null, "common.param.cannot-be-null", "condition.value");
            }
        }
    }
}

