/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.controller.load;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.controller.BaseController;
import org.apache.hugegraph.entity.enums.JobStatus;
import org.apache.hugegraph.entity.load.EdgeMapping;
import org.apache.hugegraph.entity.load.ElementMapping;
import org.apache.hugegraph.entity.load.FileMapping;
import org.apache.hugegraph.entity.load.FileSetting;
import org.apache.hugegraph.entity.load.JobManager;
import org.apache.hugegraph.entity.load.LoadParameter;
import org.apache.hugegraph.entity.load.VertexMapping;
import org.apache.hugegraph.entity.schema.EdgeLabelEntity;
import org.apache.hugegraph.entity.schema.VertexLabelEntity;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.service.load.FileMappingService;
import org.apache.hugegraph.service.load.JobManagerService;
import org.apache.hugegraph.service.schema.EdgeLabelService;
import org.apache.hugegraph.service.schema.VertexLabelService;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.Ex;
import org.apache.hugegraph.util.HubbleUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1.2/graph-connections/{connId}/job-manager/{jobId}/file-mappings"})
public class FileMappingController
extends BaseController {
    private static final Logger log = LogManager.getLogger(FileMappingController.class);
    @Autowired
    private VertexLabelService vlService;
    @Autowired
    private EdgeLabelService elService;
    @Autowired
    private FileMappingService service;
    @Autowired
    private JobManagerService jobService;

    @GetMapping
    public IPage<FileMapping> list(@PathVariable(value="connId") int connId, @PathVariable(value="jobId") int jobId, @RequestParam(name="page_no", required=false, defaultValue="1") int pageNo, @RequestParam(name="page_size", required=false, defaultValue="10") int pageSize) {
        return this.service.list(connId, jobId, pageNo, pageSize);
    }

    @GetMapping(value={"{id}"})
    public FileMapping get(@PathVariable(value="id") int id) {
        FileMapping mapping = this.service.get(id);
        if (mapping == null) {
            throw new ExternalException("load.file-mapping.not-exist.id", id);
        }
        return mapping;
    }

    @DeleteMapping(value={"{id}"})
    public void delete(@PathVariable(value="id") int id) {
        FileMapping mapping = this.service.get(id);
        if (mapping == null) {
            throw new ExternalException("load.file-mapping.not-exist.id", id);
        }
        this.service.deleteDiskFile(mapping);
        this.service.remove(id);
    }

    @DeleteMapping
    public void clear() {
        List<FileMapping> mappings = this.service.listAll();
        for (FileMapping mapping : mappings) {
            this.service.remove(mapping.getId());
        }
    }

    @PostMapping(value={"{id}/file-setting"})
    public FileMapping fileSetting(@PathVariable(value="id") int id, @RequestBody FileSetting newEntity) {
        Ex.check(!StringUtils.isEmpty((CharSequence)newEntity.getDelimiter()), "load.file-mapping.file-setting.delimiter-cannot-be-empty", new Object[0]);
        Ex.check(!StringUtils.isEmpty((CharSequence)newEntity.getCharset()), "load.file-mapping.file-setting.charset-cannot-be-empty", new Object[0]);
        Ex.check(!StringUtils.isEmpty((CharSequence)newEntity.getDateFormat()), "load.file-mapping.file-setting.dateformat-cannot-be-empty", new Object[0]);
        Ex.check(!StringUtils.isEmpty((CharSequence)newEntity.getTimeZone()), "load.file-mapping.file-setting.timezone-cannot-be-empty", new Object[0]);
        Ex.check(!StringUtils.isEmpty((CharSequence)newEntity.getSkippedLine()), "load.file-mapping.file-setting.skippedline-cannot-be-empty", new Object[0]);
        FileMapping mapping = this.service.get(id);
        if (mapping == null) {
            throw new ExternalException("load.file-mapping.not-exist.id", id);
        }
        newEntity.changeFormatIfNeeded();
        FileSetting oldEntity = mapping.getFileSetting();
        FileSetting entity = this.mergeEntity(oldEntity, newEntity);
        mapping.setFileSetting(entity);
        this.service.extractColumns(mapping);
        this.service.update(mapping);
        return mapping;
    }

    @PostMapping(value={"{id}/vertex-mappings"})
    public FileMapping addVertexMapping(@PathVariable(value="connId") int connId, @PathVariable(value="id") int id, @RequestBody VertexMapping newEntity) {
        FileMapping mapping = this.service.get(id);
        if (mapping == null) {
            throw new ExternalException("load.file-mapping.not-exist.id", id);
        }
        this.checkVertexMappingValid(connId, newEntity, mapping);
        newEntity.setId(HubbleUtil.generateSimpleId());
        mapping.getVertexMappings().add(newEntity);
        this.service.update(mapping);
        return mapping;
    }

    @PutMapping(value={"{id}/vertex-mappings/{vmid}"})
    public FileMapping updateVertexMapping(@PathVariable(value="connId") int connId, @PathVariable(value="id") int id, @PathVariable(value="vmid") String vmId, @RequestBody VertexMapping newEntity) {
        FileMapping mapping = this.service.get(id);
        if (mapping == null) {
            throw new ExternalException("load.file-mapping.not-exist.id", id);
        }
        this.checkVertexMappingValid(connId, newEntity, mapping);
        VertexMapping vertexMapping = mapping.getVertexMapping(vmId);
        Ex.check(vertexMapping != null, "load.file-mapping.vertex-mapping.not-exist.id", vmId);
        newEntity.setId(vmId);
        Set<VertexMapping> vertexMappings = mapping.getVertexMappings();
        vertexMappings.remove(vertexMapping);
        vertexMappings.add(newEntity);
        this.service.update(mapping);
        return mapping;
    }

    @DeleteMapping(value={"{id}/vertex-mappings/{vmid}"})
    public FileMapping deleteVertexMapping(@PathVariable(value="id") int id, @PathVariable(value="vmid") String vmid) {
        FileMapping mapping = this.service.get(id);
        if (mapping == null) {
            throw new ExternalException("load.file-mapping.not-exist.id", id);
        }
        VertexMapping vertexMapping = mapping.getVertexMapping(vmid);
        boolean removed = mapping.getVertexMappings().remove(vertexMapping);
        if (!removed) {
            throw new ExternalException("load.file-mapping.vertex-mapping.not-exist.id", vmid);
        }
        this.service.update(mapping);
        return mapping;
    }

    @PostMapping(value={"{id}/edge-mappings"})
    public FileMapping addEdgeMapping(@PathVariable(value="connId") int connId, @PathVariable(value="id") int id, @RequestBody EdgeMapping newEntity) {
        FileMapping mapping = this.service.get(id);
        if (mapping == null) {
            throw new ExternalException("load.file-mapping.not-exist.id", id);
        }
        this.checkEdgeMappingValid(connId, newEntity, mapping);
        newEntity.setId(HubbleUtil.generateSimpleId());
        mapping.getEdgeMappings().add(newEntity);
        this.service.update(mapping);
        return mapping;
    }

    @PutMapping(value={"{id}/edge-mappings/{emid}"})
    public FileMapping updateEdgeMapping(@PathVariable(value="connId") int connId, @PathVariable(value="id") int id, @PathVariable(value="emid") String emId, @RequestBody EdgeMapping newEntity) {
        FileMapping mapping = this.service.get(id);
        if (mapping == null) {
            throw new ExternalException("load.file-mapping.not-exist.id", id);
        }
        this.checkEdgeMappingValid(connId, newEntity, mapping);
        EdgeMapping edgeMapping = mapping.getEdgeMapping(emId);
        Ex.check(edgeMapping != null, "load.file-mapping.edge-mapping.not-exist.id", emId);
        newEntity.setId(emId);
        Set<EdgeMapping> edgeMappings = mapping.getEdgeMappings();
        edgeMappings.remove(edgeMapping);
        edgeMappings.add(newEntity);
        this.service.update(mapping);
        return mapping;
    }

    @DeleteMapping(value={"{id}/edge-mappings/{emid}"})
    public FileMapping deleteEdgeMapping(@PathVariable(value="id") int id, @PathVariable(value="emid") String emid) {
        FileMapping mapping = this.service.get(id);
        if (mapping == null) {
            throw new ExternalException("load.file-mapping.not-exist.id", id);
        }
        EdgeMapping edgeMapping = mapping.getEdgeMapping(emid);
        boolean removed = mapping.getEdgeMappings().remove(edgeMapping);
        if (!removed) {
            throw new ExternalException("load.file-mapping.edge-mapping.not-exist.id", emid);
        }
        this.service.update(mapping);
        return mapping;
    }

    @PostMapping(value={"load-parameter"})
    public void loadParameter(@RequestBody LoadParameter newEntity) {
        this.checkLoadParameter(newEntity);
        List<FileMapping> mappings = this.service.listAll();
        for (FileMapping mapping : mappings) {
            LoadParameter oldEntity = mapping.getLoadParameter();
            LoadParameter entity = this.mergeEntity(oldEntity, newEntity);
            mapping.setLoadParameter(entity);
            this.service.update(mapping);
        }
    }

    @PutMapping(value={"next-step"})
    public JobManager nextStep(@PathVariable(value="jobId") int jobId) {
        JobManager jobEntity = this.jobService.get(jobId);
        Ex.check(jobEntity != null, "job-manager.not-exist.id", jobId);
        Ex.check(jobEntity.getJobStatus() == JobStatus.MAPPING, "job.manager.status.unexpected", new Object[]{JobStatus.MAPPING, jobEntity.getJobStatus()});
        jobEntity.setJobStatus(JobStatus.SETTING);
        this.jobService.update(jobEntity);
        return jobEntity;
    }

    private void checkVertexMappingValid(int connId, VertexMapping vertexMapping, FileMapping fileMapping) {
        VertexLabelEntity vl = this.vlService.get(vertexMapping.getLabel(), connId);
        Ex.check(!vl.getIdStrategy().isAutomatic(), "load.file-mapping.vertex.automatic-id-unsupported", new Object[0]);
        Ex.check(!CollectionUtils.isEmpty(vertexMapping.getIdFields()), "load.file-mapping.vertex.id-fields-cannot-be-empty", new Object[0]);
        FileSetting fileSetting = fileMapping.getFileSetting();
        List<String> columnNames = fileSetting.getColumnNames();
        Ex.check(columnNames.containsAll(vertexMapping.getIdFields()), "load.file-mapping.vertex.id-fields-should-in-column-names", vertexMapping.getIdFields(), columnNames);
        if (vl.getIdStrategy().isPrimaryKey()) {
            Ex.check(vertexMapping.getIdFields().size() == vl.getPrimaryKeys().size(), "load.file-mapping.vertex.id-fields-should-same-size-pks", new Object[0]);
            Ex.check(!CollectionUtils.containsAny(vertexMapping.fieldMappingToMap().values(), vl.getPrimaryKeys()), "load.file-mapping.vertex.mapping-fields-cannot-contains-pk", new Object[0]);
        } else {
            Ex.check(vertexMapping.getIdFields().size() == 1, "load.file-mapping.vertex.id-fields-should-only-one", new Object[0]);
        }
        Ex.check(CollectionUtil.allUnique(vertexMapping.fieldMappingToMap().values()), "load.file-mapping.mapping-fields-should-no-duplicate", new Object[0]);
        this.checkMappingValid(vertexMapping, fileMapping);
    }

    private void checkEdgeMappingValid(int connId, EdgeMapping edgeMapping, FileMapping fileMapping) {
        EdgeLabelEntity el = this.elService.get(edgeMapping.getLabel(), connId);
        VertexLabelEntity source = this.vlService.get(el.getSourceLabel(), connId);
        VertexLabelEntity target = this.vlService.get(el.getTargetLabel(), connId);
        Ex.check(!source.getIdStrategy().isAutomatic(), "load.file-mapping.vertex.automatic-id-unsupported", new Object[0]);
        Ex.check(!target.getIdStrategy().isAutomatic(), "load.file-mapping.vertex.automatic-id-unsupported", new Object[0]);
        Ex.check(!CollectionUtils.isEmpty(edgeMapping.getSourceFields()), "load.file-mapping.edge.source-fields-cannot-be-empty", new Object[0]);
        Ex.check(!CollectionUtils.isEmpty(edgeMapping.getTargetFields()), "load.file-mapping.edge.target-fields-cannot-be-empty", new Object[0]);
        FileSetting fileSetting = fileMapping.getFileSetting();
        List<String> columnNames = fileSetting.getColumnNames();
        Ex.check(columnNames.containsAll(edgeMapping.getSourceFields()), "load.file-mapping.edge.source-fields-should-in-column-names", edgeMapping.getSourceFields(), columnNames);
        Ex.check(columnNames.containsAll(edgeMapping.getTargetFields()), "load.file-mapping.edge.target-fields-should-in-column-names", edgeMapping.getTargetFields(), columnNames);
        Ex.check(CollectionUtil.allUnique(edgeMapping.fieldMappingToMap().values()), "load.file-mapping.mapping-fields-should-no-duplicate", new Object[0]);
        this.checkMappingValid(edgeMapping, fileMapping);
    }

    private void checkMappingValid(ElementMapping elementMapping, FileMapping fileMapping) {
        Set<String> keys;
        FileSetting fileSetting = fileMapping.getFileSetting();
        List<String> columnNames = fileSetting.getColumnNames();
        if (elementMapping.getFieldMappings() != null) {
            keys = elementMapping.fieldMappingToMap().keySet();
            Ex.check(columnNames.containsAll(keys), "load.file-mapping.field.keys-should-in-column-names", new Object[0]);
        }
        if (elementMapping.getValueMappings() != null) {
            keys = elementMapping.valueMappingToMap().keySet();
            Ex.check(columnNames.containsAll(keys), "load.file-mapping.value.keys-should-in-column-names", new Object[0]);
        }
    }

    private void checkLoadParameter(LoadParameter newEntity) {
        Ex.check(newEntity.getMaxParseErrors() == -1 || newEntity.getMaxParseErrors() > 0, "load.file-mapping.load-parameter.max-parse-error.illegal", new Object[0]);
        Ex.check(newEntity.getMaxInsertErrors() == -1 || newEntity.getMaxInsertErrors() > 0, "load.file-mapping.load-parameter.max-insert-error.illegal", new Object[0]);
        Ex.check(newEntity.getInsertTimeout() > 0, "load.file-mapping.load-parameter.insert-timeout.illegal", new Object[0]);
        Ex.check(newEntity.getRetryTimes() > 0, "load.file-mapping.load-parameter.retry-times.illegal", new Object[0]);
        Ex.check(newEntity.getRetryInterval() > 0, "load.file-mapping.load-parameter.retry-interval.illegal", new Object[0]);
    }
}

