/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.options.HubbleOptions;
import org.apache.tomcat.util.http.CookieProcessor;
import org.apache.tomcat.util.http.LegacyCookieProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.stereotype.Component;

@Component
public class TomcatServletConfig
implements WebServerFactoryCustomizer<TomcatServletWebServerFactory> {
    @Autowired
    private HugeConfig config;

    public void customize(TomcatServletWebServerFactory factory) {
        String host = (String)this.config.get(HubbleOptions.SERVER_HOST);
        try {
            factory.setAddress(InetAddress.getByName(host));
        }
        catch (UnknownHostException e) {
            throw new ExternalException("service.unknown-host", (Throwable)e, host);
        }
        factory.setPort(((Integer)this.config.get(HubbleOptions.SERVER_PORT)).intValue());
        factory.addContextCustomizers(new TomcatContextCustomizer[]{context -> context.setCookieProcessor((CookieProcessor)new LegacyCookieProcessor())});
    }
}

