/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.ObjectUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class AsyncRegionLocatorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncRegionLocatorHelper.class);

    private AsyncRegionLocatorHelper() {
    }

    static boolean canUpdateOnError(HRegionLocation loc, HRegionLocation oldLoc) {
        return oldLoc != null && oldLoc.getSeqNum() <= loc.getSeqNum() && oldLoc.getServerName().equals(loc.getServerName());
    }

    static void updateCachedLocationOnError(HRegionLocation loc, Throwable exception, Function<HRegionLocation, HRegionLocation> cachedLocationSupplier, Consumer<HRegionLocation> addToCache, Consumer<HRegionLocation> removeFromCache, MetricsConnection metrics) {
        HRegionLocation oldLoc = cachedLocationSupplier.apply(loc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Try updating {} , the old value is {}, error={}", new Object[]{loc, oldLoc, exception != null ? exception.toString() : "none"});
        }
        if (!AsyncRegionLocatorHelper.canUpdateOnError(loc, oldLoc)) {
            return;
        }
        Throwable cause = ClientExceptionsUtil.findException(exception);
        if (LOG.isDebugEnabled()) {
            LOG.debug("The actual exception when updating {} is {}", (Object)loc, (Object)(cause != null ? cause.toString() : "none"));
        }
        if (cause == null || !ClientExceptionsUtil.isMetaClearingException(cause)) {
            LOG.debug("Will not update {} because the exception is null or not the one we care about", (Object)loc);
            return;
        }
        if (cause instanceof RegionMovedException) {
            RegionMovedException rme = (RegionMovedException)cause;
            HRegionLocation newLoc = new HRegionLocation(loc.getRegion(), rme.getServerName(), rme.getLocationSeqNum());
            LOG.debug("Try updating {} with the new location {} constructed by {}", new Object[]{loc, newLoc, rme.toString()});
            addToCache.accept(newLoc);
        } else {
            LOG.debug("Try removing {} from cache", (Object)loc);
            if (metrics != null) {
                metrics.incrCacheDroppingExceptions(exception);
            }
            removeFromCache.accept(loc);
        }
    }

    static RegionLocations createRegionLocations(HRegionLocation loc) {
        int replicaId = loc.getRegion().getReplicaId();
        HRegionLocation[] locs = new HRegionLocation[replicaId + 1];
        locs[replicaId] = loc;
        return new RegionLocations(locs);
    }

    static RegionLocations replaceRegionLocation(RegionLocations oldLocs, HRegionLocation loc) {
        int replicaId = loc.getRegion().getReplicaId();
        HRegionLocation[] locs = oldLocs.getRegionLocations();
        locs = Arrays.copyOf(locs, Math.max(replicaId + 1, locs.length));
        locs[replicaId] = loc;
        return new RegionLocations(locs);
    }

    static RegionLocations removeRegionLocation(RegionLocations oldLocs, int replicaId) {
        HRegionLocation[] locs = oldLocs.getRegionLocations();
        if (locs.length < replicaId + 1) {
            return oldLocs;
        }
        locs = Arrays.copyOf(locs, locs.length);
        locs[replicaId] = null;
        if (ObjectUtils.firstNonNull(locs) != null) {
            return new RegionLocations(locs);
        }
        return null;
    }

    static boolean isGood(RegionLocations locs, int replicaId) {
        if (locs == null) {
            return false;
        }
        HRegionLocation loc = locs.getRegionLocation(replicaId);
        return loc != null && loc.getServerName() != null;
    }
}

