/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.palo;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.EdgeId;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.id.IdUtil;
import org.apache.hugegraph.backend.id.SplicingIdGenerator;
import org.apache.hugegraph.backend.serializer.TableBackendEntry;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.TableDefine;
import org.apache.hugegraph.backend.store.mysql.MysqlBackendEntry;
import org.apache.hugegraph.backend.store.mysql.MysqlSessions;
import org.apache.hugegraph.backend.store.mysql.MysqlTables;
import org.apache.hugegraph.backend.store.palo.PaloTable;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;

public class PaloTables {
    private static final String NOT_NULL = "NOT NULL";
    private static final String DEFAULT_EMPTY = "DEFAULT ''";
    private static final String DATATYPE_PK = "INT";
    private static final String DATATYPE_SL = "INT";
    private static final String DATATYPE_IL = "INT";
    private static final String TINYINT = "TINYINT";
    private static final String INT = "INT";
    private static final String DECIMAL = "DECIMAL(27, 9)";
    private static final String VARCHAR = "VARCHAR(255)";
    private static final String TEXT = "VARCHAR(65533)";

    public static class ShardIndex
    extends Index {
        public static final String TABLE = HugeType.SHARD_INDEX.string();

        public ShardIndex(String store) {
            super(ShardIndex.joinTableName((String)store, (String)TABLE));
            this.define = new TableDefine();
            this.define.column(HugeKeys.INDEX_LABEL_ID, new String[]{"INT", PaloTables.NOT_NULL});
            this.define.column(HugeKeys.FIELD_VALUES, new String[]{PaloTables.VARCHAR, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.ELEMENT_IDS, new String[]{PaloTables.VARCHAR, PaloTables.NOT_NULL});
            this.define.keys(new HugeKeys[]{HugeKeys.INDEX_LABEL_ID, HugeKeys.FIELD_VALUES, HugeKeys.ELEMENT_IDS});
        }

        @Override
        protected final String entryId(MysqlBackendEntry entry) {
            Double fieldValue = (Double)entry.column(HugeKeys.FIELD_VALUES);
            Integer labelId = (Integer)entry.column(HugeKeys.INDEX_LABEL_ID);
            return SplicingIdGenerator.concat((String[])new String[]{labelId.toString(), fieldValue.toString()});
        }
    }

    public static class RangeDoubleIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_DOUBLE_INDEX.string();

        public RangeDoubleIndex(String store) {
            super(store, TABLE);
        }
    }

    public static class RangeLongIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_LONG_INDEX.string();

        public RangeLongIndex(String store) {
            super(store, TABLE);
        }
    }

    public static class RangeFloatIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_FLOAT_INDEX.string();

        public RangeFloatIndex(String store) {
            super(store, TABLE);
        }
    }

    public static class RangeIntIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_INT_INDEX.string();

        public RangeIntIndex(String store) {
            super(store, TABLE);
        }
    }

    public static abstract class RangeIndex
    extends Index {
        public RangeIndex(String store, String table) {
            super(RangeIndex.joinTableName((String)store, (String)table));
            this.define = new TableDefine();
            this.define.column(HugeKeys.INDEX_LABEL_ID, new String[]{"INT", PaloTables.NOT_NULL});
            this.define.column(HugeKeys.FIELD_VALUES, new String[]{PaloTables.DECIMAL, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.ELEMENT_IDS, new String[]{PaloTables.VARCHAR, PaloTables.NOT_NULL});
            this.define.keys(new HugeKeys[]{HugeKeys.INDEX_LABEL_ID, HugeKeys.FIELD_VALUES, HugeKeys.ELEMENT_IDS});
        }

        @Override
        protected final String entryId(MysqlBackendEntry entry) {
            Double fieldValue = (Double)entry.column(HugeKeys.FIELD_VALUES);
            Integer labelId = (Integer)entry.column(HugeKeys.INDEX_LABEL_ID);
            return SplicingIdGenerator.concat((String[])new String[]{labelId.toString(), fieldValue.toString()});
        }
    }

    public static class UniqueIndex
    extends SecondaryIndex {
        public static final String TABLE = HugeType.UNIQUE_INDEX.string();

        public UniqueIndex(String store) {
            super(store, TABLE);
        }
    }

    public static class SearchIndex
    extends SecondaryIndex {
        public static final String TABLE = HugeType.SEARCH_INDEX.string();

        public SearchIndex(String store) {
            super(store, TABLE);
        }
    }

    public static class SecondaryIndex
    extends Index {
        public static final String TABLE = HugeType.SECONDARY_INDEX.string();

        public SecondaryIndex(String store) {
            this(store, TABLE);
        }

        protected SecondaryIndex(String store, String table) {
            super(SecondaryIndex.joinTableName((String)store, (String)table));
            this.define = new TableDefine();
            this.define.column(HugeKeys.FIELD_VALUES, new String[]{PaloTables.VARCHAR, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.INDEX_LABEL_ID, new String[]{"INT", PaloTables.NOT_NULL});
            this.define.column(HugeKeys.ELEMENT_IDS, new String[]{PaloTables.VARCHAR, PaloTables.NOT_NULL});
            this.define.keys(new HugeKeys[]{HugeKeys.FIELD_VALUES, HugeKeys.INDEX_LABEL_ID, HugeKeys.ELEMENT_IDS});
        }

        @Override
        protected final String entryId(MysqlBackendEntry entry) {
            String fieldValues = (String)entry.column(HugeKeys.FIELD_VALUES);
            Integer labelId = (Integer)entry.column(HugeKeys.INDEX_LABEL_ID);
            return SplicingIdGenerator.concat((String[])new String[]{fieldValues, labelId.toString()});
        }
    }

    public static abstract class Index
    extends PaloTableTemplate {
        public Index(String table) {
            super(table);
        }

        protected BackendEntry mergeEntries(BackendEntry e1, BackendEntry e2) {
            String nextId;
            String currentId;
            MysqlBackendEntry current = (MysqlBackendEntry)e1;
            MysqlBackendEntry next = (MysqlBackendEntry)e2;
            E.checkState((current == null || current.type().isIndex() ? 1 : 0) != 0, (String)"The current entry must be null or INDEX", (Object[])new Object[0]);
            E.checkState((next != null && next.type().isIndex() ? 1 : 0) != 0, (String)"The next entry must be INDEX", (Object[])new Object[0]);
            long maxSize = 500L;
            if (current != null && (long)current.subRows().size() < maxSize && (currentId = this.entryId(current)).equals(nextId = this.entryId(next))) {
                current.subRow(next.row());
                return current;
            }
            return next;
        }

        protected abstract String entryId(MysqlBackendEntry var1);
    }

    public static class Edge
    extends PaloTableTemplate {
        private final Directions direction;
        private final String delByLabelTemplate;

        public Edge(String store, Directions direction) {
            super(Edge.joinTableName((String)store, (String)MysqlTables.Edge.table((Directions)direction)));
            this.direction = direction;
            this.delByLabelTemplate = String.format("DELETE FROM %s PARTITION %s WHERE %s = ?;", this.table(), this.table(), Edge.formatKey((HugeKeys)HugeKeys.LABEL));
            this.define = new TableDefine();
            this.define.column(HugeKeys.OWNER_VERTEX, new String[]{PaloTables.VARCHAR, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.DIRECTION, new String[]{PaloTables.TINYINT, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.LABEL, new String[]{"INT", PaloTables.NOT_NULL});
            this.define.column(HugeKeys.SORT_VALUES, new String[]{PaloTables.VARCHAR, PaloTables.NOT_NULL, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.OTHER_VERTEX, new String[]{PaloTables.VARCHAR, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.PROPERTIES, new String[]{PaloTables.TEXT, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.EXPIRED_TIME, new String[]{PaloTables.DECIMAL, PaloTables.NOT_NULL});
            this.define.keys(new HugeKeys[]{HugeKeys.OWNER_VERTEX, HugeKeys.DIRECTION, HugeKeys.LABEL, HugeKeys.SORT_VALUES, HugeKeys.OTHER_VERTEX});
        }

        protected List<Object> idColumnValue(Id id) {
            EdgeId edgeId;
            if (!(id instanceof EdgeId)) {
                String[] idParts = EdgeId.split((Id)id);
                if (idParts.length == 1) {
                    return Arrays.asList(idParts);
                }
                id = IdUtil.readString((String)id.asString());
                edgeId = EdgeId.parse((String)id.asString());
            } else {
                edgeId = (EdgeId)id;
            }
            E.checkState((edgeId.direction() == this.direction ? 1 : 0) != 0, (String)"Can't query %s edges from %s edges table", (Object[])new Object[]{edgeId.direction(), this.direction});
            ArrayList<Object> list = new ArrayList<Object>(5);
            list.add(IdUtil.writeStoredString((Id)edgeId.ownerVertexId()));
            list.add(edgeId.direction().code());
            list.add(edgeId.edgeLabelId().asLong());
            list.add(edgeId.sortValues());
            list.add(IdUtil.writeStoredString((Id)edgeId.otherVertexId()));
            return list;
        }

        public void delete(MysqlSessions.Session session, TableBackendEntry.Row entry) {
            List<Object> idParts = this.idColumnValue(entry.id());
            if (idParts.size() > 1 || !entry.columns().isEmpty()) {
                super.delete(session, entry);
                return;
            }
            this.deleteEdgesByLabel(session, entry.id());
        }

        private void deleteEdgesByLabel(MysqlSessions.Session session, Id label) {
            PreparedStatement deleteStmt;
            try {
                deleteStmt = session.prepareStatement(this.delByLabelTemplate);
                deleteStmt.setObject(1, label.asLong());
            }
            catch (SQLException e) {
                throw new BackendException("Failed to prepare statement '%s'", new Object[]{this.delByLabelTemplate});
            }
            session.add(deleteStmt);
        }

        protected BackendEntry mergeEntries(BackendEntry e1, BackendEntry e2) {
            MysqlBackendEntry current = (MysqlBackendEntry)e1;
            MysqlBackendEntry next = (MysqlBackendEntry)e2;
            E.checkState((current == null || current.type().isVertex() ? 1 : 0) != 0, (String)"The current entry must be null or VERTEX", (Object[])new Object[0]);
            E.checkState((next != null && next.type().isEdge() ? 1 : 0) != 0, (String)"The next entry must be EDGE", (Object[])new Object[0]);
            long maxSize = 500L;
            if (current != null && (long)current.subRows().size() < maxSize) {
                Id nextVertexId = IdGenerator.of((String)((String)next.column(HugeKeys.OWNER_VERTEX)));
                if (current.id().equals(nextVertexId)) {
                    current.subRow(next.row());
                    return current;
                }
            }
            return this.wrapByVertex(next);
        }

        private MysqlBackendEntry wrapByVertex(MysqlBackendEntry edge) {
            assert (edge.type().isEdge());
            String ownerVertex = (String)edge.column(HugeKeys.OWNER_VERTEX);
            E.checkState((ownerVertex != null ? 1 : 0) != 0, (String)"Invalid backend entry", (Object[])new Object[0]);
            Id vertexId = IdGenerator.of((String)ownerVertex);
            MysqlBackendEntry vertex = new MysqlBackendEntry(HugeType.VERTEX, vertexId);
            vertex.column(HugeKeys.ID, (Object)ownerVertex);
            vertex.column(HugeKeys.PROPERTIES, (Object)"");
            vertex.subRow(edge.row());
            return vertex;
        }
    }

    public static class Vertex
    extends PaloTableTemplate {
        public static final String TABLE = HugeType.VERTEX.string();

        public Vertex(String store) {
            super(Vertex.joinTableName((String)store, (String)TABLE));
            this.define = new TableDefine();
            this.define.column(HugeKeys.ID, new String[]{PaloTables.VARCHAR, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.LABEL, new String[]{"INT", PaloTables.NOT_NULL});
            this.define.column(HugeKeys.PROPERTIES, new String[]{PaloTables.TEXT, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.EXPIRED_TIME, new String[]{PaloTables.DECIMAL, PaloTables.NOT_NULL});
            this.define.keys(new HugeKeys[]{HugeKeys.ID});
        }
    }

    public static class IndexLabel
    extends PaloTableTemplate {
        public static final String TABLE = HugeType.INDEX_LABEL.string();

        public IndexLabel() {
            super(TABLE);
            this.define = new TableDefine();
            this.define.column(HugeKeys.ID, new String[]{"INT", PaloTables.NOT_NULL});
            this.define.column(HugeKeys.NAME, new String[]{PaloTables.VARCHAR, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.BASE_TYPE, new String[]{PaloTables.TINYINT, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.BASE_VALUE, new String[]{"INT", PaloTables.NOT_NULL});
            this.define.column(HugeKeys.INDEX_TYPE, new String[]{PaloTables.TINYINT, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.FIELDS, new String[]{PaloTables.VARCHAR, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.USER_DATA, new String[]{PaloTables.VARCHAR, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.STATUS, new String[]{PaloTables.TINYINT, PaloTables.NOT_NULL});
            this.define.keys(new HugeKeys[]{HugeKeys.ID});
        }
    }

    public static class PropertyKey
    extends PaloTableTemplate {
        public static final String TABLE = HugeType.PROPERTY_KEY.string();

        public PropertyKey() {
            super(TABLE);
            this.define = new TableDefine();
            this.define.column(HugeKeys.ID, new String[]{"INT", PaloTables.NOT_NULL});
            this.define.column(HugeKeys.NAME, new String[]{PaloTables.VARCHAR, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.DATA_TYPE, new String[]{PaloTables.TINYINT, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.CARDINALITY, new String[]{PaloTables.TINYINT, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.PROPERTIES, new String[]{PaloTables.VARCHAR, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.USER_DATA, new String[]{PaloTables.VARCHAR, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.STATUS, new String[]{PaloTables.TINYINT, PaloTables.NOT_NULL});
            this.define.keys(new HugeKeys[]{HugeKeys.ID});
        }
    }

    public static class EdgeLabel
    extends PaloTableTemplate {
        public static final String TABLE = HugeType.EDGE_LABEL.string();

        public EdgeLabel() {
            super(TABLE);
            this.define = new TableDefine();
            this.define.column(HugeKeys.ID, new String[]{"INT", PaloTables.NOT_NULL});
            this.define.column(HugeKeys.NAME, new String[]{PaloTables.VARCHAR, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.FREQUENCY, new String[]{PaloTables.TINYINT, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.SOURCE_LABEL, new String[]{"INT", PaloTables.NOT_NULL});
            this.define.column(HugeKeys.TARGET_LABEL, new String[]{"INT", PaloTables.NOT_NULL});
            this.define.column(HugeKeys.SORT_KEYS, new String[]{PaloTables.VARCHAR, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.PROPERTIES, new String[]{PaloTables.VARCHAR, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.NULLABLE_KEYS, new String[]{PaloTables.VARCHAR, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.INDEX_LABELS, new String[]{PaloTables.VARCHAR, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.ENABLE_LABEL_INDEX, new String[]{PaloTables.TINYINT, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.USER_DATA, new String[]{PaloTables.VARCHAR, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.STATUS, new String[]{PaloTables.TINYINT, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.TTL, new String[]{"INT", PaloTables.NOT_NULL});
            this.define.column(HugeKeys.TTL_START_TIME, new String[]{"INT"});
            this.define.keys(new HugeKeys[]{HugeKeys.ID});
        }
    }

    public static class VertexLabel
    extends PaloTableTemplate {
        public static final String TABLE = HugeType.VERTEX_LABEL.string();

        public VertexLabel() {
            super(TABLE);
            this.define = new TableDefine();
            this.define.column(HugeKeys.ID, new String[]{"INT", PaloTables.NOT_NULL});
            this.define.column(HugeKeys.NAME, new String[]{PaloTables.VARCHAR, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.ID_STRATEGY, new String[]{PaloTables.TINYINT, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.PRIMARY_KEYS, new String[]{PaloTables.VARCHAR, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.PROPERTIES, new String[]{PaloTables.VARCHAR, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.NULLABLE_KEYS, new String[]{PaloTables.VARCHAR, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.INDEX_LABELS, new String[]{PaloTables.VARCHAR, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.ENABLE_LABEL_INDEX, new String[]{PaloTables.TINYINT, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.USER_DATA, new String[]{PaloTables.VARCHAR, PaloTables.DEFAULT_EMPTY});
            this.define.column(HugeKeys.STATUS, new String[]{PaloTables.TINYINT, PaloTables.NOT_NULL});
            this.define.column(HugeKeys.TTL, new String[]{"INT", PaloTables.NOT_NULL});
            this.define.column(HugeKeys.TTL_START_TIME, new String[]{"INT"});
            this.define.keys(new HugeKeys[]{HugeKeys.ID});
        }
    }

    public static class PaloTableTemplate
    extends PaloTable {
        protected TableDefine define;

        public PaloTableTemplate(String table) {
            super(table);
        }

        public TableDefine tableDefine() {
            return this.define;
        }
    }
}

