/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.server;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jersey3.InstrumentedResourceMethodApplicationListener;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.security.SecuritySchemes;
import jakarta.ws.rs.ApplicationPath;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.api.filter.RedirectFilterDynamicFeature;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.WorkLoad;
import org.apache.hugegraph.event.EventHub;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

@SecuritySchemes(value={@SecurityScheme(name="basic", type=SecuritySchemeType.HTTP, scheme="basic"), @SecurityScheme(name="bearer", type=SecuritySchemeType.HTTP, scheme="bearer")})
@ApplicationPath(value="/")
@OpenAPIDefinition(info=@Info(title="HugeGraph RESTful API", version="1.3.0", description="All management API for HugeGraph", contact=@Contact(url="https://github.com/apache/hugegraph", name="HugeGraph")), security={@SecurityRequirement(name="basic"), @SecurityRequirement(name="bearer")})
public class ApplicationConfig
extends ResourceConfig {
    public ApplicationConfig(HugeConfig conf, EventHub hub) {
        this.packages(new String[]{"org.apache.hugegraph.api"});
        this.register(JacksonFeature.class);
        this.register(RolesAllowedDynamicFeature.class);
        this.register(RedirectFilterDynamicFeature.class);
        this.register((Object)new ConfFactory(conf));
        this.register((Object)new GraphManagerFactory(conf, hub));
        this.register((Object)new WorkLoadFactory());
        MetricRegistry registry = MetricManager.INSTANCE.getRegistry();
        this.register(new InstrumentedResourceMethodApplicationListener(registry));
        this.register(OpenApiResource.class);
    }

    private class WorkLoadFactory
    extends AbstractBinder
    implements Factory<WorkLoad> {
        private final WorkLoad load = new WorkLoad();

        public WorkLoad provide() {
            return this.load;
        }

        public void dispose(WorkLoad workLoad) {
        }

        protected void configure() {
            this.bindFactory(this).to(WorkLoad.class).in(RequestScoped.class);
        }
    }

    private class GraphManagerFactory
    extends AbstractBinder
    implements Factory<GraphManager> {
        private GraphManager manager = null;

        public GraphManagerFactory(final HugeConfig conf, final EventHub hub) {
            ApplicationConfig.this.register(new ApplicationEventListener(){
                private final ApplicationEvent.Type eventInited = ApplicationEvent.Type.INITIALIZATION_FINISHED;
                private final ApplicationEvent.Type eventDestroyed = ApplicationEvent.Type.DESTROY_FINISHED;

                public void onEvent(ApplicationEvent event) {
                    if (event.getType() == this.eventInited) {
                        GraphManager manager = new GraphManager(conf, hub);
                        try {
                            manager.init();
                        }
                        catch (Throwable e) {
                            manager.close();
                            throw e;
                        }
                        GraphManagerFactory.this.manager = manager;
                    } else if (event.getType() == this.eventDestroyed && GraphManagerFactory.this.manager != null) {
                        GraphManagerFactory.this.manager.close();
                    }
                }

                public RequestEventListener onRequest(RequestEvent event) {
                    return null;
                }
            });
        }

        protected void configure() {
            this.bindFactory(this).to(GraphManager.class).in(RequestScoped.class);
        }

        public GraphManager provide() {
            if (this.manager == null) {
                String message = "Please wait for the server to initialize";
                throw new MultiException((Throwable)new HugeException(message), false);
            }
            return this.manager;
        }

        public void dispose(GraphManager manager) {
        }
    }

    private class ConfFactory
    extends AbstractBinder
    implements Factory<HugeConfig> {
        private final HugeConfig conf;

        public ConfFactory(HugeConfig conf) {
            E.checkNotNull((Object)conf, (String)"configuration");
            this.conf = conf;
        }

        protected void configure() {
            this.bindFactory(this).to(HugeConfig.class).in(RequestScoped.class);
        }

        public HugeConfig provide() {
            return this.conf;
        }

        public void dispose(HugeConfig conf) {
        }
    }
}

