/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.traversers.TraverserAPI;
import org.apache.hugegraph.api.traversers.Vertices;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.TemplatePathsTraverser;
import org.apache.hugegraph.traversal.algorithm.steps.RepeatEdgeStep;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/templatepaths")
@Singleton
@Tag(name="TemplatePathsAPI")
public class TemplatePathsAPI
extends TraverserAPI {
    private static final Logger LOG = Log.logger(TemplatePathsAPI.class);

    private static List<RepeatEdgeStep> steps(HugeGraph g, List<TemplatePathStep> steps) {
        ArrayList<RepeatEdgeStep> edgeSteps = new ArrayList<RepeatEdgeStep>(steps.size());
        for (TemplatePathStep step : steps) {
            edgeSteps.add(TemplatePathsAPI.repeatEdgeStep(g, step));
        }
        return edgeSteps;
    }

    private static RepeatEdgeStep repeatEdgeStep(HugeGraph graph, TemplatePathStep step) {
        return new RepeatEdgeStep(graph, step.direction, step.labels, step.properties, step.maxDegree, step.skipDegree, step.maxTimes);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String post(@Context GraphManager manager, @PathParam(value="graph") String graph, Request request) {
        Iterator iterVertex;
        E.checkArgumentNotNull((Object)request, (String)"The request body can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.sources, (String)"The sources of request can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.targets, (String)"The targets of request can't be null", (Object[])new Object[0]);
        E.checkArgument((request.steps != null && !request.steps.isEmpty() ? 1 : 0) != 0, (String)"The steps of request can't be empty", (Object[])new Object[0]);
        LOG.debug("Graph [{}] get template paths from source vertices '{}', target vertices '{}', with steps '{}', capacity '{}', limit '{}', with_vertex '{}' and with_edge '{}'", new Object[]{graph, request.sources, request.targets, request.steps, request.capacity, request.limit, request.withVertex, request.withEdge});
        API.ApiMeasurer measure = new API.ApiMeasurer();
        HugeGraph g = TemplatePathsAPI.graph(manager, graph);
        Iterator<Vertex> sources = request.sources.vertices(g);
        Iterator<Vertex> targets = request.targets.vertices(g);
        List<RepeatEdgeStep> steps = TemplatePathsAPI.steps(g, request.steps);
        TemplatePathsTraverser traverser = new TemplatePathsTraverser(g);
        TemplatePathsTraverser.WrappedPathSet wrappedPathSet = traverser.templatePaths(sources, targets, steps, request.withRing, request.capacity, (long)request.limit);
        measure.addIterCount(traverser.vertexIterCounter.get(), traverser.edgeIterCounter.get());
        Set paths = wrappedPathSet.paths();
        HashSet vertexIds = new HashSet();
        for (HugeTraverser.Path path : paths) {
            vertexIds.addAll(path.vertices());
        }
        if (request.withVertex && !vertexIds.isEmpty()) {
            iterVertex = g.vertices(vertexIds.toArray());
            measure.addIterCount(vertexIds.size(), 0L);
        } else {
            iterVertex = vertexIds.iterator();
        }
        Set edges = wrappedPathSet.edges();
        Iterator iterEdge = request.withEdge && !edges.isEmpty() ? edges.iterator() : HugeTraverser.EdgeRecord.getEdgeIds((Set)edges).iterator();
        return manager.serializer((Graph)g, measure.measures()).writePaths("paths", paths, false, iterVertex, iterEdge);
    }

    protected static class TemplatePathStep
    extends TraverserAPI.Step {
        @JsonProperty(value="max_times")
        public int maxTimes = 1;

        protected TemplatePathStep() {
        }

        @Override
        public String toString() {
            return String.format("TemplatePathStep{direction=%s,labels=%s,properties=%s,maxDegree=%s,skipDegree=%s,maxTimes=%s}", this.direction, this.labels, this.properties, this.maxDegree, this.skipDegree, this.maxTimes);
        }
    }

    private static class Request {
        @JsonProperty(value="sources")
        public Vertices sources;
        @JsonProperty(value="targets")
        public Vertices targets;
        @JsonProperty(value="steps")
        public List<TemplatePathStep> steps;
        @JsonProperty(value="with_ring")
        public boolean withRing = false;
        @JsonProperty(value="capacity")
        public long capacity = Long.parseLong("10000000");
        @JsonProperty(value="limit")
        public int limit = Integer.parseInt("10");
        @JsonProperty(value="with_vertex")
        public boolean withVertex = false;
        @JsonProperty(value="with_edge")
        public boolean withEdge = false;

        private Request() {
        }

        public String toString() {
            return String.format("TemplatePathsRequest{sources=%s,targets=%s,steps=%s,withRing=%s,capacity=%s,limit=%s,withVertex=%s,withEdge=%s}", this.sources, this.targets, this.steps, this.withRing, this.capacity, this.limit, this.withVertex, this.withEdge);
        }
    }
}

