/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.schema;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.RedirectFilter;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.schema.Userdata;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.type.define.GraphMode;
import org.apache.hugegraph.type.define.IdStrategy;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/schema/vertexlabels")
@Singleton
@Tag(name="VertexLabelAPI")
public class VertexLabelAPI
extends API {
    private static final Logger LOG = Log.logger(VertexLabelAPI.class);

    @POST
    @Timed
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=vertex_label_write"})
    @RedirectFilter.RedirectMasterRole
    public String create(@Context GraphManager manager, @PathParam(value="graph") String graph, JsonVertexLabel jsonVertexLabel) {
        LOG.debug("Graph [{}] create vertex label: {}", (Object)graph, (Object)jsonVertexLabel);
        VertexLabelAPI.checkCreatingBody(jsonVertexLabel);
        HugeGraph g = VertexLabelAPI.graph(manager, graph);
        VertexLabel.Builder builder = jsonVertexLabel.convert2Builder(g);
        VertexLabel vertexLabel = (VertexLabel)builder.create();
        return manager.serializer((Graph)g).writeVertexLabel(vertexLabel);
    }

    @PUT
    @Timed
    @Path(value="{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=vertex_label_write"})
    @RedirectFilter.RedirectMasterRole
    public String update(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="name") String name, @QueryParam(value="action") String action, JsonVertexLabel jsonVertexLabel) {
        LOG.debug("Graph [{}] {} vertex label: {}", new Object[]{graph, action, jsonVertexLabel});
        VertexLabelAPI.checkUpdatingBody(jsonVertexLabel);
        E.checkArgument((boolean)name.equals(jsonVertexLabel.name), (String)"The name in url(%s) and body(%s) are different", (Object[])new Object[]{name, jsonVertexLabel.name});
        boolean append = VertexLabelAPI.checkAndParseAction(action);
        HugeGraph g = VertexLabelAPI.graph(manager, graph);
        VertexLabel.Builder builder = jsonVertexLabel.convert2Builder(g);
        VertexLabel vertexLabel = append ? (VertexLabel)builder.append() : (VertexLabel)builder.eliminate();
        return manager.serializer((Graph)g).writeVertexLabel(vertexLabel);
    }

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=vertex_label_read"})
    public String list(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="names") List<String> names) {
        ArrayList<VertexLabel> labels;
        boolean listAll = CollectionUtils.isEmpty(names);
        if (listAll) {
            LOG.debug("Graph [{}] list vertex labels", (Object)graph);
        } else {
            LOG.debug("Graph [{}] get vertex labels by names {}", (Object)graph, names);
        }
        HugeGraph g = VertexLabelAPI.graph(manager, graph);
        if (listAll) {
            labels = g.schema().getVertexLabels();
        } else {
            labels = new ArrayList<VertexLabel>(names.size());
            for (String name : names) {
                labels.add(g.schema().getVertexLabel(name));
            }
        }
        return manager.serializer((Graph)g).writeVertexLabels(labels);
    }

    @GET
    @Timed
    @Path(value="{name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=vertex_label_read"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="name") String name) {
        LOG.debug("Graph [{}] get vertex label by name '{}'", (Object)graph, (Object)name);
        HugeGraph g = VertexLabelAPI.graph(manager, graph);
        VertexLabel vertexLabel = g.schema().getVertexLabel(name);
        return manager.serializer((Graph)g).writeVertexLabel(vertexLabel);
    }

    @DELETE
    @Timed
    @Path(value="{name}")
    @StatusFilter.Status(value=202)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=vertex_label_delete"})
    @RedirectFilter.RedirectMasterRole
    public Map<String, Id> delete(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="name") String name) {
        LOG.debug("Graph [{}] remove vertex label by name '{}'", (Object)graph, (Object)name);
        HugeGraph g = VertexLabelAPI.graph(manager, graph);
        g.schema().getVertexLabel(name);
        return ImmutableMap.of((Object)"task_id", (Object)g.schema().vertexLabel(name).remove());
    }

    @JsonIgnoreProperties(value={"index_labels", "status"})
    private static class JsonVertexLabel
    implements Checkable {
        @JsonProperty(value="id")
        public long id;
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="id_strategy")
        public IdStrategy idStrategy;
        @JsonProperty(value="properties")
        public String[] properties;
        @JsonProperty(value="primary_keys")
        public String[] primaryKeys;
        @JsonProperty(value="nullable_keys")
        public String[] nullableKeys;
        @JsonProperty(value="ttl")
        public long ttl;
        @JsonProperty(value="ttl_start_time")
        public String ttlStartTime;
        @JsonProperty(value="enable_label_index")
        public Boolean enableLabelIndex;
        @JsonProperty(value="user_data")
        public Userdata userdata;
        @JsonProperty(value="check_exist")
        public Boolean checkExist;

        private JsonVertexLabel() {
        }

        @Override
        public void checkCreate(boolean isBatch) {
            E.checkArgumentNotNull((Object)this.name, (String)"The name of vertex label can't be null", (Object[])new Object[0]);
        }

        private VertexLabel.Builder convert2Builder(HugeGraph g) {
            VertexLabel.Builder builder = g.schema().vertexLabel(this.name);
            if (this.id != 0L) {
                E.checkArgument((this.id > 0L ? 1 : 0) != 0, (String)"Only positive number can be assign as vertex label id", (Object[])new Object[0]);
                E.checkArgument((g.mode() == GraphMode.RESTORING ? 1 : 0) != 0, (String)"Only accept vertex label id when graph in RESTORING mode, but '%s' is in mode '%s'", (Object[])new Object[]{g, g.mode()});
                builder.id(this.id);
            }
            if (this.idStrategy != null) {
                builder.idStrategy(this.idStrategy);
            }
            if (this.properties != null) {
                builder.properties(this.properties);
            }
            if (this.primaryKeys != null) {
                builder.primaryKeys(this.primaryKeys);
            }
            if (this.nullableKeys != null) {
                builder.nullableKeys(this.nullableKeys);
            }
            if (this.enableLabelIndex != null) {
                builder.enableLabelIndex(this.enableLabelIndex.booleanValue());
            }
            if (this.userdata != null) {
                builder.userdata((Map)this.userdata);
            }
            if (this.checkExist != null) {
                builder.checkExist(this.checkExist.booleanValue());
            }
            if (this.ttl != 0L) {
                builder.ttl(this.ttl);
            }
            if (this.ttlStartTime != null) {
                E.checkArgument((this.ttl > 0L ? 1 : 0) != 0, (String)"Only set ttlStartTime when ttl is positive,  but got ttl: %s", (Object[])new Object[]{this.ttl});
                builder.ttlStartTime(this.ttlStartTime);
            }
            return builder;
        }

        public String toString() {
            return String.format("JsonVertexLabel{name=%s, idStrategy=%s, primaryKeys=%s, nullableKeys=%s, properties=%s, ttl=%s, ttlStartTime=%s}", this.name, this.idStrategy, Arrays.toString(this.primaryKeys), Arrays.toString(this.nullableKeys), Arrays.toString(this.properties), this.ttl, this.ttlStartTime);
        }
    }
}

