/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.graph;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.CompressInterceptor;
import org.apache.hugegraph.api.filter.DecompressInterceptor;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.api.graph.BatchAPI;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.backend.id.EdgeId;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.UpdateStrategy;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.optimize.TraversalUtil;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.function.TriFunction;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/graph/edges")
@Singleton
@Tag(name="EdgeAPI")
public class EdgeAPI
extends BatchAPI {
    private static final Logger LOG = Log.logger(EdgeAPI.class);

    @POST
    @Timed(name="single-create")
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=edge_write"})
    public String create(@Context GraphManager manager, @PathParam(value="graph") String graph, JsonEdge jsonEdge) {
        LOG.debug("Graph [{}] create edge: {}", (Object)graph, (Object)jsonEdge);
        EdgeAPI.checkCreatingBody(jsonEdge);
        HugeGraph g = EdgeAPI.graph(manager, graph);
        if (jsonEdge.sourceLabel != null && jsonEdge.targetLabel != null) {
            EdgeAPI.vertexLabel(g, jsonEdge.sourceLabel, "Invalid source vertex label '%s'");
            EdgeAPI.vertexLabel(g, jsonEdge.targetLabel, "Invalid target vertex label '%s'");
        }
        Vertex srcVertex = EdgeAPI.getVertex(g, jsonEdge.source, jsonEdge.sourceLabel);
        Vertex tgtVertex = EdgeAPI.getVertex(g, jsonEdge.target, jsonEdge.targetLabel);
        Edge edge = EdgeAPI.commit(g, () -> srcVertex.addEdge(jsonEdge.label, tgtVertex, jsonEdge.properties()));
        return manager.serializer((Graph)g).writeEdge(edge);
    }

    @POST
    @Timed(name="batch-create")
    @DecompressInterceptor.Decompress
    @Path(value="batch")
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=edge_write"})
    public String create(@Context HugeConfig config, @Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="check_vertex") @DefaultValue(value="true") boolean checkVertex, List<JsonEdge> jsonEdges) {
        LOG.debug("Graph [{}] create edges: {}", (Object)graph, jsonEdges);
        EdgeAPI.checkCreatingBody(jsonEdges);
        EdgeAPI.checkBatchSize(config, jsonEdges);
        HugeGraph g = EdgeAPI.graph(manager, graph);
        TriFunction getVertex = checkVertex ? EdgeAPI::getVertex : EdgeAPI::newVertex;
        return this.commit(config, g, jsonEdges.size(), () -> {
            ArrayList<Id> ids = new ArrayList<Id>(jsonEdges.size());
            for (JsonEdge jsonEdge : jsonEdges) {
                Vertex srcVertex = (Vertex)getVertex.apply((Object)g, jsonEdge.source, (Object)jsonEdge.sourceLabel);
                Vertex tgtVertex = (Vertex)getVertex.apply((Object)g, jsonEdge.target, (Object)jsonEdge.targetLabel);
                Edge edge = srcVertex.addEdge(jsonEdge.label, tgtVertex, jsonEdge.properties());
                ids.add((Id)edge.id());
            }
            return manager.serializer((Graph)g).writeIds(ids);
        });
    }

    @PUT
    @Timed(name="batch-update")
    @DecompressInterceptor.Decompress
    @Path(value="batch")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=edge_write"})
    public String update(@Context HugeConfig config, @Context GraphManager manager, @PathParam(value="graph") String graph, BatchEdgeRequest req) {
        BatchEdgeRequest.checkUpdate(req);
        LOG.debug("Graph [{}] update edges: {}", (Object)graph, (Object)req);
        EdgeAPI.checkUpdatingBody(req.jsonEdges);
        EdgeAPI.checkBatchSize(config, req.jsonEdges);
        HugeGraph g = EdgeAPI.graph(manager, graph);
        HashMap map = new HashMap(req.jsonEdges.size());
        TriFunction getVertex = req.checkVertex ? EdgeAPI::getVertex : EdgeAPI::newVertex;
        return this.commit(config, g, 0, () -> {
            req.jsonEdges.forEach(newEdge -> {
                Id newEdgeId = this.getEdgeId(EdgeAPI.graph(manager, graph), (JsonEdge)newEdge);
                JsonEdge oldEdge = (JsonEdge)map.get(newEdgeId);
                this.updateExistElement(oldEdge, (BatchAPI.JsonElement)newEdge, req.updateStrategies);
                map.put(newEdgeId, newEdge);
            });
            Object[] ids = map.keySet().toArray();
            Iterator oldEdges = g.edges(ids);
            oldEdges.forEachRemaining(oldEdge -> {
                JsonEdge newEdge = (JsonEdge)map.get(oldEdge.id());
                this.updateExistElement(g, (Element)oldEdge, newEdge, req.updateStrategies);
            });
            ArrayList edges = new ArrayList(map.size());
            map.values().forEach(finalEdge -> {
                Vertex srcVertex = (Vertex)getVertex.apply((Object)g, finalEdge.source, (Object)finalEdge.sourceLabel);
                Vertex tgtVertex = (Vertex)getVertex.apply((Object)g, finalEdge.target, (Object)finalEdge.targetLabel);
                edges.add(srcVertex.addEdge(finalEdge.label, tgtVertex, finalEdge.properties()));
            });
            return manager.serializer((Graph)g).writeEdges(edges.iterator(), false);
        });
    }

    @PUT
    @Timed(name="single-update")
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=edge_write"})
    public String update(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") String id, @QueryParam(value="action") String action, JsonEdge jsonEdge) {
        LOG.debug("Graph [{}] update edge: {}", (Object)graph, (Object)jsonEdge);
        EdgeAPI.checkUpdatingBody(jsonEdge);
        if (jsonEdge.id != null) {
            E.checkArgument((boolean)id.equals(jsonEdge.id), (String)"The ids are different between url and request body ('%s' != '%s')", (Object[])new Object[]{id, jsonEdge.id});
        }
        boolean append = EdgeAPI.checkAndParseAction(action);
        HugeGraph g = EdgeAPI.graph(manager, graph);
        HugeEdge edge = (HugeEdge)g.edge((Object)id);
        EdgeLabel edgeLabel = edge.schemaLabel();
        for (String key : jsonEdge.properties.keySet()) {
            PropertyKey pkey = g.propertyKey(key);
            E.checkArgument((boolean)edgeLabel.properties().contains(pkey.id()), (String)"Can't update property for edge '%s' because there is no property key '%s' in its edge label", (Object[])new Object[]{id, key});
        }
        EdgeAPI.commit(g, () -> EdgeAPI.updateProperties((HugeElement)edge, jsonEdge, append));
        return manager.serializer((Graph)g).writeEdge((Edge)edge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Timed
    @CompressInterceptor.Compress
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=edge_read"})
    public String list(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="vertex_id") String vertexId, @QueryParam(value="direction") String direction, @QueryParam(value="label") String label, @QueryParam(value="properties") String properties, @QueryParam(value="keep_start_p") @DefaultValue(value="false") boolean keepStartP, @QueryParam(value="offset") @DefaultValue(value="0") long offset, @QueryParam(value="page") String page, @QueryParam(value="limit") @DefaultValue(value="100") long limit) {
        LOG.debug("Graph [{}] query edges by vertex: {}, direction: {}, label: {}, properties: {}, offset: {}, page: {}, limit: {}", new Object[]{graph, vertexId, direction, label, properties, offset, page, limit});
        Map<String, Object> props = EdgeAPI.parseProperties(properties);
        if (page != null) {
            E.checkArgument((offset == 0L ? 1 : 0) != 0, (String)"Not support querying edges based on paging and offset together", (Object[])new Object[0]);
        }
        Id vertex = VertexAPI.checkAndParseVertexId(vertexId);
        Direction dir = EdgeAPI.parseDirection(direction);
        HugeGraph g = EdgeAPI.graph(manager, graph);
        GraphTraversal traversal = vertex != null ? (label != null ? g.traversal().V(new Object[]{vertex}).toE(dir, new String[]{label}) : g.traversal().V(new Object[]{vertex}).toE(dir, new String[0])) : (label != null ? g.traversal().E(new Object[0]).hasLabel(label, new String[0]) : g.traversal().E(new Object[0]));
        for (Map.Entry<String, Object> prop : props.entrySet()) {
            Object value = prop.getValue();
            if (keepStartP || !(value instanceof String) || !((String)value).startsWith("P.")) continue;
            prop.setValue(TraversalUtil.parsePredicate((String)((String)value)));
        }
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            traversal = traversal.has(entry.getKey(), entry.getValue());
        }
        traversal = page == null ? traversal.range(offset, offset + limit) : traversal.has("~page", (Object)page).limit(limit);
        try {
            String string = manager.serializer((Graph)g).writeEdges((Iterator<Edge>)traversal, page != null);
            return string;
        }
        finally {
            if (g.tx().isOpen()) {
                g.tx().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Timed
    @Path(value="{id}")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=edge_read"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") String id) {
        LOG.debug("Graph [{}] get edge by id '{}'", (Object)graph, (Object)id);
        HugeGraph g = EdgeAPI.graph(manager, graph);
        try {
            Edge edge = g.edge((Object)id);
            String string = manager.serializer((Graph)g).writeEdge(edge);
            return string;
        }
        finally {
            if (g.tx().isOpen()) {
                g.tx().close();
            }
        }
    }

    @DELETE
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=edge_delete"})
    public void delete(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") String id, @QueryParam(value="label") String label) {
        LOG.debug("Graph [{}] remove vertex by id '{}'", (Object)graph, (Object)id);
        HugeGraph g = EdgeAPI.graph(manager, graph);
        EdgeAPI.commit(g, () -> {
            try {
                g.removeEdge(label, (Object)id);
            }
            catch (NotFoundException e) {
                throw new IllegalArgumentException(String.format("No such edge with id: '%s', %s", new Object[]{id, e}));
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException(String.format("No such edge with id: '%s'", id));
            }
        });
    }

    private static void checkBatchSize(HugeConfig config, List<JsonEdge> edges) {
        int max = (Integer)config.get(ServerOptions.MAX_EDGES_PER_BATCH);
        if (edges.size() > max) {
            throw new IllegalArgumentException(String.format("Too many edges for one time post, the maximum number is '%s'", max));
        }
        if (edges.isEmpty()) {
            throw new IllegalArgumentException("The number of edges can't be 0");
        }
    }

    private static Vertex getVertex(HugeGraph graph, Object id, String label) {
        HugeVertex vertex;
        try {
            vertex = (HugeVertex)graph.vertices(new Object[]{id}).next();
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException(String.format("Invalid vertex id '%s'", id));
        }
        if (label != null && !vertex.label().equals(label)) {
            throw new IllegalArgumentException(String.format("The label of vertex '%s' is unmatched, users expect label '%s', actual label stored is '%s'", id, label, vertex.label()));
        }
        return vertex.copy();
    }

    private static Vertex newVertex(HugeGraph g, Object id, String label) {
        VertexLabel vl = EdgeAPI.vertexLabel(g, label, "Invalid vertex label '%s'");
        Id idValue = HugeVertex.getIdValue((Object)id);
        return new HugeVertex(g, idValue, vl);
    }

    private static VertexLabel vertexLabel(HugeGraph graph, String label, String message) {
        try {
            return graph.vertexLabel(label);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(message, label));
        }
    }

    public static Direction parseDirection(String direction) {
        if (direction == null || direction.isEmpty()) {
            return Direction.BOTH;
        }
        try {
            return Direction.valueOf((String)direction);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Direction value must be in [OUT, IN, BOTH], but got '%s'", direction));
        }
    }

    private Id getEdgeId(HugeGraph g, JsonEdge newEdge) {
        String sortKeys = "";
        Id labelId = g.edgeLabel(newEdge.label).id();
        List sortKeyIds = g.edgeLabel(labelId).sortKeys();
        if (!sortKeyIds.isEmpty()) {
            ArrayList sortKeyValues = new ArrayList(sortKeyIds.size());
            sortKeyIds.forEach(skId -> {
                PropertyKey pk = g.propertyKey(skId);
                String sortKey = pk.name();
                Object sortKeyValue = newEdge.properties.get(sortKey);
                E.checkArgument((sortKeyValue != null ? 1 : 0) != 0, (String)"The value of sort key '%s' can't be null", (Object[])new Object[]{sortKey});
                sortKeyValue = pk.validValueOrThrow(sortKeyValue);
                sortKeyValues.add(sortKeyValue);
            });
            sortKeys = ConditionQuery.concatValues(sortKeyValues);
        }
        EdgeId edgeId = new EdgeId(HugeVertex.getIdValue((Object)newEdge.source), Directions.OUT, labelId, sortKeys, HugeVertex.getIdValue((Object)newEdge.target));
        if (newEdge.id != null) {
            E.checkArgument((boolean)edgeId.asString().equals(newEdge.id), (String)"The ids are different between server and request body ('%s' != '%s'). And note the sort key values should either be null or equal to the origin value when specified edge id", (Object[])new Object[]{edgeId, newEdge.id});
        }
        return edgeId;
    }

    private static class JsonEdge
    extends BatchAPI.JsonElement {
        @JsonProperty(value="outV")
        public Object source;
        @JsonProperty(value="outVLabel")
        public String sourceLabel;
        @JsonProperty(value="inV")
        public Object target;
        @JsonProperty(value="inVLabel")
        public String targetLabel;

        private JsonEdge() {
        }

        @Override
        public void checkCreate(boolean isBatch) {
            E.checkArgumentNotNull((Object)this.label, (String)"Expect the label of edge", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)this.source, (String)"Expect source vertex id", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)this.target, (String)"Expect target vertex id", (Object[])new Object[0]);
            if (isBatch) {
                E.checkArgumentNotNull((Object)this.sourceLabel, (String)"Expect source vertex label", (Object[])new Object[0]);
                E.checkArgumentNotNull((Object)this.targetLabel, (String)"Expect target vertex label", (Object[])new Object[0]);
            } else {
                E.checkArgument((this.sourceLabel == null && this.targetLabel == null || this.sourceLabel != null && this.targetLabel != null ? 1 : 0) != 0, (String)"The both source and target vertex label are either passed in, or not passed in", (Object[])new Object[0]);
            }
            this.checkUpdate();
        }

        @Override
        public void checkUpdate() {
            E.checkArgumentNotNull((Object)this.properties, (String)"The properties of edge can't be null", (Object[])new Object[0]);
            for (Map.Entry entry : this.properties.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                E.checkArgumentNotNull(value, (String)"Not allowed to set value of property '%s' to null for edge '%s'", (Object[])new Object[]{key, this.id});
            }
        }

        @Override
        public Object[] properties() {
            return API.properties(this.properties);
        }

        public String toString() {
            return String.format("JsonEdge{label=%s, source-vertex=%s, source-vertex-label=%s, target-vertex=%s, target-vertex-label=%s, properties=%s}", this.label, this.source, this.sourceLabel, this.target, this.targetLabel, this.properties);
        }
    }

    protected static class BatchEdgeRequest {
        @JsonProperty(value="edges")
        public List<JsonEdge> jsonEdges;
        @JsonProperty(value="update_strategies")
        public Map<String, UpdateStrategy> updateStrategies;
        @JsonProperty(value="check_vertex")
        public boolean checkVertex = false;
        @JsonProperty(value="create_if_not_exist")
        public boolean createIfNotExist = true;

        protected BatchEdgeRequest() {
        }

        private static void checkUpdate(BatchEdgeRequest req) {
            E.checkArgumentNotNull((Object)req, (String)"BatchEdgeRequest can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull(req.jsonEdges, (String)"Parameter 'edges' can't be null", (Object[])new Object[0]);
            E.checkArgument((req.updateStrategies != null && !req.updateStrategies.isEmpty() ? 1 : 0) != 0, (String)"Parameter 'update_strategies' can't be empty", (Object[])new Object[0]);
            E.checkArgument((boolean)req.createIfNotExist, (String)"Parameter 'create_if_not_exist' dose not support false now", (Object[])new Object[0]);
        }

        public String toString() {
            return String.format("BatchEdgeRequest{jsonEdges=%s,updateStrategies=%s,checkVertex=%s,createIfNotExist=%s}", this.jsonEdges, this.updateStrategies, this.checkVertex, this.createIfNotExist);
        }
    }
}

