/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.optimize;

import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.apache.hugegraph.HugeException;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.SingleGremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversal;

public final class HugeScriptTraversal<S, E>
extends DefaultTraversal<S, E> {
    private static final long serialVersionUID = 4617322697747299673L;
    private final String script;
    private final String language;
    private final Map<String, Object> bindings;
    private final Map<String, String> aliases;
    private Object result;

    public HugeScriptTraversal(TraversalSource traversalSource, String language, String script, Map<String, Object> bindings, Map<String, String> aliases) {
        this.graph = traversalSource.getGraph();
        this.language = language;
        this.script = script;
        this.bindings = bindings;
        this.aliases = aliases;
        this.result = null;
    }

    public Object result() {
        return this.result;
    }

    public String script() {
        return this.script;
    }

    public void applyStrategies() throws IllegalStateException {
        GremlinScriptEngine engine = SingleGremlinScriptEngineManager.get((String)this.language);
        Bindings bindings = engine.createBindings();
        bindings.putAll((Map<? extends String, ? extends Object>)this.bindings);
        TraversalStrategy[] strategies = this.getStrategies().toList().toArray(new TraversalStrategy[0]);
        GraphTraversalSource g = this.graph.traversal();
        if (strategies.length > 0) {
            g = g.withStrategies(strategies);
        }
        bindings.put("g", (Object)g);
        bindings.put("graph", (Object)this.graph);
        for (Map.Entry<String, String> entry : this.aliases.entrySet()) {
            Object value = bindings.get(entry.getValue());
            if (value == null) {
                throw new IllegalArgumentException(String.format("Invalid alias '%s':'%s'", entry.getKey(), entry.getValue()));
            }
            bindings.put(entry.getKey(), value);
        }
        try {
            Object result = engine.eval(this.script, bindings);
            if (result instanceof Traversal.Admin) {
                Traversal.Admin traversal = (Traversal.Admin)result;
                traversal.getSideEffects().mergeInto(this.sideEffects);
                traversal.getSteps().forEach(arg_0 -> ((HugeScriptTraversal)this).addStep(arg_0));
                this.strategies = traversal.getStrategies();
            } else {
                this.result = result;
            }
            super.applyStrategies();
        }
        catch (ScriptException e) {
            throw new HugeException(e.getMessage(), e);
        }
    }
}

