/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store;

import java.util.Iterator;
import java.util.Map;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendFeatures;
import org.apache.hugegraph.backend.store.BackendMutation;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.backend.store.SystemSchemaStore;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.E;

public interface BackendStore {
    public String store();

    public String storedVersion();

    public String database();

    public BackendStoreProvider provider();

    public SystemSchemaStore systemSchemaStore();

    public boolean isSchemaStore();

    public void open(HugeConfig var1);

    public void close();

    public boolean opened();

    public void init();

    public void clear(boolean var1);

    public boolean initialized();

    public void truncate();

    public void mutate(BackendMutation var1);

    public Iterator<BackendEntry> query(Query var1);

    public Number queryNumber(Query var1);

    public void beginTx();

    public void commitTx();

    public void rollbackTx();

    public <R> R metadata(HugeType var1, String var2, Object[] var3);

    public BackendFeatures features();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Id nextId(HugeType type) {
        int MAX_TIMES = 1000;
        long counter = 0L;
        long expect = -1L;
        BackendStore backendStore = this;
        synchronized (backendStore) {
            for (int i = 0; i < 1000 && (counter = this.getCounter(type)) != expect; ++i) {
                expect = counter + 1L;
                this.increaseCounter(type, 1L);
            }
        }
        E.checkState((counter != 0L ? 1 : 0) != 0, (String)"Please check whether '%s' is OK", (Object[])new Object[]{this.provider().type()});
        E.checkState((counter == expect ? 1 : 0) != 0, (String)"'%s' is busy please try again", (Object[])new Object[]{this.provider().type()});
        return IdGenerator.of(expect);
    }

    default public void setCounterLowest(HugeType type, long lowest) {
        long current = this.getCounter(type);
        if (current >= lowest) {
            return;
        }
        long increment = lowest - current;
        this.increaseCounter(type, increment);
    }

    default public String olapTableName(HugeType type) {
        StringBuilder builder = new StringBuilder(7);
        builder.append(this.store()).append("_").append(HugeType.OLAP.string()).append("_").append(type.string());
        return builder.toString().toLowerCase();
    }

    default public String olapTableName(Id id) {
        StringBuilder builder = new StringBuilder(9);
        builder.append(this.store()).append("_").append(HugeType.OLAP.string()).append("_").append(id.asLong());
        return builder.toString().toLowerCase();
    }

    public void increaseCounter(HugeType var1, long var2);

    public long getCounter(HugeType var1);

    default public void createOlapTable(Id pkId) {
        throw new UnsupportedOperationException("BackendStore.createOlapTable()");
    }

    default public void checkAndRegisterOlapTable(Id pkId) {
        throw new UnsupportedOperationException("BackendStore.checkAndRegisterOlapTable()");
    }

    default public void clearOlapTable(Id pkId) {
        throw new UnsupportedOperationException("BackendStore.clearOlapTable()");
    }

    default public void removeOlapTable(Id pkId) {
        throw new UnsupportedOperationException("BackendStore.removeOlapTable()");
    }

    default public Map<String, String> createSnapshot(String snapshotDir) {
        throw new UnsupportedOperationException("createSnapshot");
    }

    default public void resumeSnapshot(String snapshotDir, boolean deleteSnapshot) {
        throw new UnsupportedOperationException("resumeSnapshot");
    }

    public static enum TxState {
        BEGIN,
        COMMITTING,
        COMMITT_FAIL,
        ROLLBACKING,
        ROLLBACK_FAIL,
        CLEAN;

    }
}

