/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.serializer;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.EdgeId;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.id.IdUtil;
import org.apache.hugegraph.backend.id.SplicingIdGenerator;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.IdPrefixQuery;
import org.apache.hugegraph.backend.query.IdRangeQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.serializer.AbstractSerializer;
import org.apache.hugegraph.backend.serializer.TextBackendEntry;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeEdgeProperty;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeIndex;
import org.apache.hugegraph.structure.HugeProperty;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.structure.HugeVertexProperty;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.AggregateType;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.Frequency;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.type.define.IdStrategy;
import org.apache.hugegraph.type.define.IndexType;
import org.apache.hugegraph.type.define.SchemaStatus;
import org.apache.hugegraph.type.define.WriteType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;

public class TextSerializer
extends AbstractSerializer {
    private static final String VALUE_SPLITOR = "\u0003";
    private static final String EDGE_NAME_ENDING = "\u0000";
    private static final String EDGE_OUT_TYPE = TextSerializer.writeType(HugeType.EDGE_OUT);

    public TextSerializer(HugeConfig config) {
        super(config);
    }

    @Override
    public TextBackendEntry newBackendEntry(HugeType type, Id id) {
        return new TextBackendEntry(type, id);
    }

    private TextBackendEntry newBackendEntry(HugeElement elem) {
        Id id = IdGenerator.of(TextSerializer.writeEntryId(elem.id()));
        return new TextBackendEntry(elem.type(), id);
    }

    private TextBackendEntry newBackendEntry(SchemaElement elem) {
        Id id = IdGenerator.of(TextSerializer.writeId(elem.id()));
        return new TextBackendEntry(elem.type(), id);
    }

    @Override
    protected TextBackendEntry convertEntry(BackendEntry backendEntry) {
        if (!(backendEntry instanceof TextBackendEntry)) {
            throw new HugeException("The entry '%s' is not TextBackendEntry", backendEntry);
        }
        return (TextBackendEntry)backendEntry;
    }

    private String formatSyspropName(String name) {
        return SplicingIdGenerator.concat(TextSerializer.writeType(HugeType.SYS_PROPERTY), name);
    }

    private String formatSyspropName(HugeKeys col) {
        return this.formatSyspropName(col.string());
    }

    private String formatPropertyName(String key) {
        return SplicingIdGenerator.concat(TextSerializer.writeType(HugeType.PROPERTY), key);
    }

    private String formatPropertyName(HugeProperty<?> prop) {
        return this.formatPropertyName(TextSerializer.writeId(prop.propertyKey().id()));
    }

    private String formatPropertyValue(HugeProperty<?> prop) {
        return JsonUtil.toJson(prop.value());
    }

    private String formatPropertyName() {
        return HugeType.PROPERTY.string();
    }

    private String formatPropertyValues(HugeVertex vertex) {
        int size = vertex.sizeOfProperties();
        StringBuilder sb = new StringBuilder(64 * size);
        int i = 0;
        for (HugeProperty<?> property : vertex.getProperties()) {
            sb.append(this.formatPropertyName(property));
            sb.append(VALUE_SPLITOR);
            sb.append(this.formatPropertyValue(property));
            if (++i >= size) continue;
            sb.append(VALUE_SPLITOR);
        }
        return sb.toString();
    }

    private void parseProperty(String colName, String colValue, HugeElement owner) {
        String[] colParts = SplicingIdGenerator.split(colName);
        assert (colParts.length == 2) : colName;
        PropertyKey pkey = owner.graph().propertyKey(TextSerializer.readId(colParts[1]));
        Object value = JsonUtil.fromJson(colValue, pkey.implementClazz());
        if (pkey.cardinality() == Cardinality.SINGLE) {
            owner.addProperty(pkey, value);
        } else {
            if (!(value instanceof Collection)) {
                throw new BackendException("Invalid value of non-single property: %s", colValue);
            }
            for (Object v : (Collection)value) {
                v = JsonUtil.castNumber(v, pkey.dataType().clazz());
                owner.addProperty(pkey, v);
            }
        }
    }

    private void parseProperties(String colValue, HugeVertex vertex) {
        if (colValue == null || colValue.isEmpty()) {
            return;
        }
        Object[] valParts = colValue.split(VALUE_SPLITOR);
        E.checkState((valParts.length % 2 == 0 ? 1 : 0) != 0, (String)"The property key values length must be even number, but got %s, length is '%s'", (Object[])new Object[]{Arrays.toString(valParts), valParts.length});
        for (int i = 0; i < valParts.length; i += 2) {
            assert (i + 1 < valParts.length);
            this.parseProperty((String)valParts[i], (String)valParts[i + 1], vertex);
        }
    }

    private String formatEdgeName(HugeEdge edge) {
        return this.writeEdgeId(edge.idWithDirection(), false);
    }

    private String formatEdgeValue(HugeEdge edge) {
        StringBuilder sb = new StringBuilder(256 * edge.sizeOfProperties());
        sb.append(edge.id().asString());
        sb.append(VALUE_SPLITOR);
        sb.append(this.formatSyspropName(HugeKeys.EXPIRED_TIME));
        sb.append(VALUE_SPLITOR);
        sb.append(edge.expiredTime());
        for (HugeProperty<?> property : edge.getProperties()) {
            sb.append(VALUE_SPLITOR);
            sb.append(this.formatPropertyName(property));
            sb.append(VALUE_SPLITOR);
            sb.append(this.formatPropertyValue(property));
        }
        return sb.toString();
    }

    private void parseEdge(String colName, String colValue, HugeVertex vertex) {
        String[] colParts = EdgeId.split(colName);
        HugeGraph graph = vertex.graph();
        boolean direction = colParts[0].equals(EDGE_OUT_TYPE);
        String sortValues = TextSerializer.readEdgeName(colParts[2]);
        EdgeLabel edgeLabel = graph.edgeLabelOrNone(TextSerializer.readId(colParts[1]));
        Id otherVertexId = TextSerializer.readEntryId(colParts[3]);
        HugeEdge edge = HugeEdge.constructEdge(vertex, direction, edgeLabel, sortValues, otherVertexId);
        String[] valParts = colValue.split(VALUE_SPLITOR);
        String name = this.formatSyspropName(HugeKeys.EXPIRED_TIME);
        E.checkState((boolean)valParts[1].equals(name), (String)"Invalid system property name '%s'", (Object[])new Object[]{valParts[1]});
        edge.expiredTime(JsonUtil.fromJson(valParts[2], Long.class));
        for (int i = 3; i < valParts.length; i += 2) {
            this.parseProperty(valParts[i], valParts[i + 1], edge);
        }
    }

    private void parseColumn(String colName, String colValue, HugeVertex vertex) {
        String type = SplicingIdGenerator.split(colName)[0];
        if (type.equals(TextSerializer.writeType(HugeType.PROPERTY))) {
            this.parseProperties(colValue, vertex);
        } else if (type.equals(TextSerializer.writeType(HugeType.EDGE_OUT)) || type.equals(TextSerializer.writeType(HugeType.EDGE_IN))) {
            this.parseEdge(colName, colValue, vertex);
        } else if (!type.equals(TextSerializer.writeType(HugeType.SYS_PROPERTY))) {
            E.checkState((boolean)false, (String)"Invalid entry with unknown type(%s): %s", (Object[])new Object[]{type, colName});
        }
    }

    @Override
    public BackendEntry writeVertex(HugeVertex vertex) {
        TextBackendEntry entry = this.newBackendEntry(vertex);
        if (vertex.schemaLabel() != null) {
            entry.column(this.formatSyspropName(HugeKeys.LABEL), TextSerializer.writeId(vertex.schemaLabel().id()));
        }
        entry.column(this.formatSyspropName(HugeKeys.EXPIRED_TIME), TextSerializer.writeLong(vertex.expiredTime()));
        entry.column(this.formatPropertyName(), this.formatPropertyValues(vertex));
        return entry;
    }

    @Override
    public BackendEntry writeOlapVertex(HugeVertex vertex) {
        throw new NotImplementedException("Unsupported writeOlapVertex()");
    }

    @Override
    public BackendEntry writeVertexProperty(HugeVertexProperty<?> prop) {
        throw new NotImplementedException("Unsupported writeVertexProperty()");
    }

    @Override
    public HugeVertex readVertex(HugeGraph graph, BackendEntry backendEntry) {
        E.checkNotNull((Object)graph, (String)"serializer graph");
        if (backendEntry == null) {
            return null;
        }
        TextBackendEntry entry = this.convertEntry(backendEntry);
        String labelId = entry.column(this.formatSyspropName(HugeKeys.LABEL));
        VertexLabel vertexLabel = VertexLabel.NONE;
        if (labelId != null) {
            vertexLabel = graph.vertexLabelOrNone(TextSerializer.readId(labelId));
        }
        Id id = IdUtil.readString(entry.id().asString());
        HugeVertex vertex = new HugeVertex(graph, id, vertexLabel);
        String expiredTime = entry.column(this.formatSyspropName(HugeKeys.EXPIRED_TIME));
        if (expiredTime != null) {
            vertex.expiredTime(TextSerializer.readLong(expiredTime));
        }
        for (String name : entry.columnNames()) {
            this.parseColumn(name, entry.column(name), vertex);
        }
        return vertex;
    }

    @Override
    public BackendEntry writeEdge(HugeEdge edge) {
        Id id = IdGenerator.of(edge.idWithDirection().asString());
        TextBackendEntry entry = this.newBackendEntry(edge.type(), id);
        entry.column(this.formatEdgeName(edge), this.formatEdgeValue(edge));
        return entry;
    }

    @Override
    public BackendEntry writeEdgeProperty(HugeEdgeProperty<?> prop) {
        HugeEdge edge = prop.element();
        Id id = IdGenerator.of(edge.idWithDirection().asString());
        TextBackendEntry entry = this.newBackendEntry(edge.type(), id);
        entry.subId(IdGenerator.of(prop.key()));
        entry.column(this.formatEdgeName(edge), this.formatEdgeValue(edge));
        return entry;
    }

    @Override
    public HugeEdge readEdge(HugeGraph graph, BackendEntry backendEntry) {
        E.checkNotNull((Object)graph, (String)"serializer graph");
        throw new NotImplementedException("Unsupported readEdge()");
    }

    @Override
    public BackendEntry writeIndex(HugeIndex index) {
        TextBackendEntry entry = this.newBackendEntry(index.type(), index.id());
        if (index.fieldValues() == null && index.elementIds().isEmpty()) {
            entry.column(HugeKeys.INDEX_LABEL_ID, TextSerializer.writeId(index.indexLabelId()));
        } else {
            entry.column(this.formatSyspropName(HugeKeys.FIELD_VALUES), JsonUtil.toJson(index.fieldValues()));
            entry.column(this.formatSyspropName(HugeKeys.INDEX_LABEL_ID), TextSerializer.writeId(index.indexLabelId()));
            entry.column(this.formatSyspropName(HugeKeys.ELEMENT_IDS), TextSerializer.writeElementId(index.elementId(), index.expiredTime()));
            entry.subId(index.elementId());
        }
        return entry;
    }

    @Override
    public HugeIndex readIndex(HugeGraph graph, ConditionQuery query, BackendEntry backendEntry) {
        E.checkNotNull((Object)graph, (String)"serializer graph");
        if (backendEntry == null) {
            return null;
        }
        TextBackendEntry entry = this.convertEntry(backendEntry);
        String indexValues = entry.column(this.formatSyspropName(HugeKeys.FIELD_VALUES));
        String indexLabelId = entry.column(this.formatSyspropName(HugeKeys.INDEX_LABEL_ID));
        String elemIds = entry.column(this.formatSyspropName(HugeKeys.ELEMENT_IDS));
        IndexLabel indexLabel = IndexLabel.label(graph, TextSerializer.readId(indexLabelId));
        HugeIndex index = new HugeIndex(graph, indexLabel);
        index.fieldValues(JsonUtil.fromJson(indexValues, Object.class));
        for (HugeIndex.IdWithExpiredTime elemId : TextSerializer.readElementIds(elemIds)) {
            long expiredTime = elemId.expiredTime();
            Id id = indexLabel.queryType().isEdge() ? EdgeId.parse(elemId.id().asString()) : elemId.id();
            index.elementIds(id, expiredTime);
        }
        return index;
    }

    @Override
    public TextBackendEntry writeId(HugeType type, Id id) {
        id = this.writeQueryId(type, id);
        return this.newBackendEntry(type, id);
    }

    @Override
    protected Id writeQueryId(HugeType type, Id id) {
        if (type.isEdge()) {
            id = IdGenerator.of(this.writeEdgeId(id, true));
        } else if (type.isGraph()) {
            id = IdGenerator.of(TextSerializer.writeEntryId(id));
        } else {
            assert (type.isSchema());
            id = IdGenerator.of(TextSerializer.writeId(id));
        }
        return id;
    }

    @Override
    protected Query writeQueryEdgeCondition(Query query) {
        ConditionQuery cq = (ConditionQuery)query;
        if (cq.hasRangeCondition()) {
            return this.writeQueryEdgeRangeCondition(cq);
        }
        return this.writeQueryEdgePrefixCondition(cq);
    }

    private Query writeQueryEdgeRangeCondition(ConditionQuery cq) {
        List<Condition> sortValues = cq.syspropConditions(HugeKeys.SORT_VALUES);
        E.checkArgument((sortValues.size() >= 1 && sortValues.size() <= 2 ? 1 : 0) != 0, (String)"Edge range query must be with sort-values range", (Object[])new Object[0]);
        Object vertex = cq.condition((Object)HugeKeys.OWNER_VERTEX);
        Object direction = cq.condition((Object)HugeKeys.DIRECTION);
        if (direction == null) {
            direction = Directions.OUT;
        }
        Object label = cq.condition((Object)HugeKeys.LABEL);
        ArrayList<String> start = new ArrayList<String>(cq.conditionsSize());
        start.add(TextSerializer.writeEntryId((Id)vertex));
        start.add(TextSerializer.writeType(((Directions)direction).type()));
        start.add(TextSerializer.writeId((Id)label));
        ArrayList<String> end = new ArrayList<String>(start);
        Condition.RangeConditions range = new Condition.RangeConditions(sortValues);
        if (range.keyMin() != null) {
            start.add((String)range.keyMin());
        }
        if (range.keyMax() != null) {
            end.add((String)range.keyMax());
        }
        String startId = EdgeId.concat(start.toArray(new String[0]));
        String endId = EdgeId.concat(end.toArray(new String[0]));
        if (range.keyMax() == null) {
            return new IdPrefixQuery(cq, IdGenerator.of(startId), range.keyMinEq(), IdGenerator.of(endId));
        }
        return new IdRangeQuery(cq, IdGenerator.of(startId), range.keyMinEq(), IdGenerator.of(endId), range.keyMaxEq());
    }

    private Query writeQueryEdgePrefixCondition(ConditionQuery cq) {
        HugeKeys key;
        Object value;
        ArrayList<String> condParts = new ArrayList<String>(cq.conditionsSize());
        HugeKeys[] hugeKeysArray = EdgeId.KEYS;
        int n = hugeKeysArray.length;
        for (int i = 0; i < n && (value = cq.condition((Object)(key = hugeKeysArray[i]))) != null; ++i) {
            if (key == HugeKeys.OWNER_VERTEX || key == HugeKeys.OTHER_VERTEX) {
                condParts.add(TextSerializer.writeEntryId((Id)value));
                continue;
            }
            if (key == HugeKeys.DIRECTION) {
                condParts.add(TextSerializer.writeType(((Directions)value).type()));
                continue;
            }
            if (key == HugeKeys.LABEL) {
                condParts.add(TextSerializer.writeId((Id)value));
                continue;
            }
            condParts.add(value.toString());
        }
        if (!condParts.isEmpty()) {
            String id = EdgeId.concat(condParts.toArray(new String[0]));
            return new IdPrefixQuery(cq, IdGenerator.of(id));
        }
        return null;
    }

    @Override
    protected Query writeQueryCondition(Query query) {
        ConditionQuery result = (ConditionQuery)query;
        assert (result.allSysprop());
        for (Condition.Relation r : result.relations()) {
            if (query.resultType().isSchema()) {
                r.serialKey(((HugeKeys)((Object)r.key())).string());
            } else {
                r.serialKey(this.formatSyspropName((HugeKeys)((Object)r.key())));
            }
            if (r.value() instanceof Id) {
                r.serialValue(TextSerializer.writeId((Id)r.value()));
            } else {
                r.serialValue(JsonUtil.toJson(r.value()));
            }
            if (r.relation() != Condition.RelationType.CONTAINS_KEY) continue;
            String key = (String)r.serialValue();
            r.serialValue(this.formatPropertyName(key));
        }
        return result;
    }

    @Override
    public BackendEntry writeVertexLabel(VertexLabel vertexLabel) {
        TextBackendEntry entry = this.newBackendEntry(vertexLabel);
        entry.column(HugeKeys.NAME, JsonUtil.toJson(vertexLabel.name()));
        entry.column(HugeKeys.ID_STRATEGY, JsonUtil.toJson(vertexLabel.idStrategy()));
        entry.column(HugeKeys.PROPERTIES, TextSerializer.writeIds(vertexLabel.properties()));
        entry.column(HugeKeys.PRIMARY_KEYS, TextSerializer.writeIds(vertexLabel.primaryKeys()));
        entry.column(HugeKeys.NULLABLE_KEYS, TextSerializer.writeIds(vertexLabel.nullableKeys()));
        entry.column(HugeKeys.INDEX_LABELS, TextSerializer.writeIds(vertexLabel.indexLabels()));
        entry.column(HugeKeys.ENABLE_LABEL_INDEX, JsonUtil.toJson(vertexLabel.enableLabelIndex()));
        TextSerializer.writeUserdata(vertexLabel, entry);
        entry.column(HugeKeys.STATUS, JsonUtil.toJson(vertexLabel.status()));
        return entry;
    }

    @Override
    public VertexLabel readVertexLabel(HugeGraph graph, BackendEntry backendEntry) {
        if (backendEntry == null) {
            return null;
        }
        TextBackendEntry entry = this.convertEntry(backendEntry);
        Id id = TextSerializer.readId(entry.id());
        String name = JsonUtil.fromJson(entry.column(HugeKeys.NAME), String.class);
        String idStrategy = entry.column(HugeKeys.ID_STRATEGY);
        String properties = entry.column(HugeKeys.PROPERTIES);
        String primaryKeys = entry.column(HugeKeys.PRIMARY_KEYS);
        String nullableKeys = entry.column(HugeKeys.NULLABLE_KEYS);
        String indexLabels = entry.column(HugeKeys.INDEX_LABELS);
        String enableLabelIndex = entry.column(HugeKeys.ENABLE_LABEL_INDEX);
        String status = entry.column(HugeKeys.STATUS);
        VertexLabel vertexLabel = new VertexLabel(graph, id, name);
        vertexLabel.idStrategy(JsonUtil.fromJson(idStrategy, IdStrategy.class));
        vertexLabel.properties(TextSerializer.readIds(properties));
        vertexLabel.primaryKeys(TextSerializer.readIds(primaryKeys));
        vertexLabel.nullableKeys(TextSerializer.readIds(nullableKeys));
        vertexLabel.addIndexLabels(TextSerializer.readIds(indexLabels));
        vertexLabel.enableLabelIndex(JsonUtil.fromJson(enableLabelIndex, Boolean.class));
        TextSerializer.readUserdata(vertexLabel, entry);
        vertexLabel.status(JsonUtil.fromJson(status, SchemaStatus.class));
        return vertexLabel;
    }

    @Override
    public BackendEntry writeEdgeLabel(EdgeLabel edgeLabel) {
        TextBackendEntry entry = this.newBackendEntry(edgeLabel);
        entry.column(HugeKeys.NAME, JsonUtil.toJson(edgeLabel.name()));
        entry.column(HugeKeys.SOURCE_LABEL, TextSerializer.writeId(edgeLabel.sourceLabel()));
        entry.column(HugeKeys.TARGET_LABEL, TextSerializer.writeId(edgeLabel.targetLabel()));
        entry.column(HugeKeys.FREQUENCY, JsonUtil.toJson(edgeLabel.frequency()));
        entry.column(HugeKeys.PROPERTIES, TextSerializer.writeIds(edgeLabel.properties()));
        entry.column(HugeKeys.SORT_KEYS, TextSerializer.writeIds(edgeLabel.sortKeys()));
        entry.column(HugeKeys.NULLABLE_KEYS, TextSerializer.writeIds(edgeLabel.nullableKeys()));
        entry.column(HugeKeys.INDEX_LABELS, TextSerializer.writeIds(edgeLabel.indexLabels()));
        entry.column(HugeKeys.ENABLE_LABEL_INDEX, JsonUtil.toJson(edgeLabel.enableLabelIndex()));
        TextSerializer.writeUserdata(edgeLabel, entry);
        entry.column(HugeKeys.STATUS, JsonUtil.toJson(edgeLabel.status()));
        entry.column(HugeKeys.TTL, JsonUtil.toJson(edgeLabel.ttl()));
        entry.column(HugeKeys.TTL_START_TIME, TextSerializer.writeId(edgeLabel.ttlStartTime()));
        return entry;
    }

    @Override
    public EdgeLabel readEdgeLabel(HugeGraph graph, BackendEntry backendEntry) {
        if (backendEntry == null) {
            return null;
        }
        TextBackendEntry entry = this.convertEntry(backendEntry);
        Id id = TextSerializer.readId(entry.id());
        String name = JsonUtil.fromJson(entry.column(HugeKeys.NAME), String.class);
        String sourceLabel = entry.column(HugeKeys.SOURCE_LABEL);
        String targetLabel = entry.column(HugeKeys.TARGET_LABEL);
        String frequency = entry.column(HugeKeys.FREQUENCY);
        String sortKeys = entry.column(HugeKeys.SORT_KEYS);
        String nullablekeys = entry.column(HugeKeys.NULLABLE_KEYS);
        String properties = entry.column(HugeKeys.PROPERTIES);
        String indexLabels = entry.column(HugeKeys.INDEX_LABELS);
        String enableLabelIndex = entry.column(HugeKeys.ENABLE_LABEL_INDEX);
        String status = entry.column(HugeKeys.STATUS);
        String ttl = entry.column(HugeKeys.TTL);
        String ttlStartTime = entry.column(HugeKeys.TTL_START_TIME);
        EdgeLabel edgeLabel = new EdgeLabel(graph, id, name);
        edgeLabel.sourceLabel(TextSerializer.readId(sourceLabel));
        edgeLabel.targetLabel(TextSerializer.readId(targetLabel));
        edgeLabel.frequency(JsonUtil.fromJson(frequency, Frequency.class));
        edgeLabel.properties(TextSerializer.readIds(properties));
        edgeLabel.sortKeys(TextSerializer.readIds(sortKeys));
        edgeLabel.nullableKeys(TextSerializer.readIds(nullablekeys));
        edgeLabel.addIndexLabels(TextSerializer.readIds(indexLabels));
        edgeLabel.enableLabelIndex(JsonUtil.fromJson(enableLabelIndex, Boolean.class));
        TextSerializer.readUserdata(edgeLabel, entry);
        edgeLabel.status(JsonUtil.fromJson(status, SchemaStatus.class));
        edgeLabel.ttl(JsonUtil.fromJson(ttl, Long.class));
        edgeLabel.ttlStartTime(TextSerializer.readId(ttlStartTime));
        return edgeLabel;
    }

    @Override
    public BackendEntry writePropertyKey(PropertyKey propertyKey) {
        TextBackendEntry entry = this.newBackendEntry(propertyKey);
        entry.column(HugeKeys.NAME, JsonUtil.toJson(propertyKey.name()));
        entry.column(HugeKeys.DATA_TYPE, JsonUtil.toJson(propertyKey.dataType()));
        entry.column(HugeKeys.CARDINALITY, JsonUtil.toJson(propertyKey.cardinality()));
        entry.column(HugeKeys.AGGREGATE_TYPE, JsonUtil.toJson(propertyKey.aggregateType()));
        entry.column(HugeKeys.WRITE_TYPE, JsonUtil.toJson(propertyKey.writeType()));
        entry.column(HugeKeys.PROPERTIES, TextSerializer.writeIds(propertyKey.properties()));
        TextSerializer.writeUserdata(propertyKey, entry);
        entry.column(HugeKeys.STATUS, JsonUtil.toJson(propertyKey.status()));
        return entry;
    }

    @Override
    public PropertyKey readPropertyKey(HugeGraph graph, BackendEntry backendEntry) {
        if (backendEntry == null) {
            return null;
        }
        TextBackendEntry entry = this.convertEntry(backendEntry);
        Id id = TextSerializer.readId(entry.id());
        String name = JsonUtil.fromJson(entry.column(HugeKeys.NAME), String.class);
        String dataType = entry.column(HugeKeys.DATA_TYPE);
        String cardinality = entry.column(HugeKeys.CARDINALITY);
        String aggregateType = entry.column(HugeKeys.AGGREGATE_TYPE);
        String writeType = entry.column(HugeKeys.WRITE_TYPE);
        String properties = entry.column(HugeKeys.PROPERTIES);
        String status = entry.column(HugeKeys.STATUS);
        PropertyKey propertyKey = new PropertyKey(graph, id, name);
        propertyKey.dataType(JsonUtil.fromJson(dataType, DataType.class));
        propertyKey.cardinality(JsonUtil.fromJson(cardinality, Cardinality.class));
        propertyKey.aggregateType(JsonUtil.fromJson(aggregateType, AggregateType.class));
        propertyKey.writeType(JsonUtil.fromJson(writeType, WriteType.class));
        propertyKey.properties(TextSerializer.readIds(properties));
        TextSerializer.readUserdata(propertyKey, entry);
        propertyKey.status(JsonUtil.fromJson(status, SchemaStatus.class));
        return propertyKey;
    }

    @Override
    public BackendEntry writeIndexLabel(IndexLabel indexLabel) {
        TextBackendEntry entry = this.newBackendEntry(indexLabel);
        entry.column(HugeKeys.NAME, JsonUtil.toJson(indexLabel.name()));
        entry.column(HugeKeys.BASE_TYPE, JsonUtil.toJson(indexLabel.baseType()));
        entry.column(HugeKeys.BASE_VALUE, TextSerializer.writeId(indexLabel.baseValue()));
        entry.column(HugeKeys.INDEX_TYPE, JsonUtil.toJson(indexLabel.indexType()));
        entry.column(HugeKeys.FIELDS, TextSerializer.writeIds(indexLabel.indexFields()));
        TextSerializer.writeUserdata(indexLabel, entry);
        entry.column(HugeKeys.STATUS, JsonUtil.toJson(indexLabel.status()));
        return entry;
    }

    @Override
    public IndexLabel readIndexLabel(HugeGraph graph, BackendEntry backendEntry) {
        if (backendEntry == null) {
            return null;
        }
        TextBackendEntry entry = this.convertEntry(backendEntry);
        Id id = TextSerializer.readId(entry.id());
        String name = JsonUtil.fromJson(entry.column(HugeKeys.NAME), String.class);
        String baseType = entry.column(HugeKeys.BASE_TYPE);
        String baseValue = entry.column(HugeKeys.BASE_VALUE);
        String indexType = entry.column(HugeKeys.INDEX_TYPE);
        String indexFields = entry.column(HugeKeys.FIELDS);
        String status = entry.column(HugeKeys.STATUS);
        IndexLabel indexLabel = new IndexLabel(graph, id, name);
        indexLabel.baseType(JsonUtil.fromJson(baseType, HugeType.class));
        indexLabel.baseValue(TextSerializer.readId(baseValue));
        indexLabel.indexType(JsonUtil.fromJson(indexType, IndexType.class));
        indexLabel.indexFields(TextSerializer.readIds(indexFields));
        TextSerializer.readUserdata(indexLabel, entry);
        indexLabel.status(JsonUtil.fromJson(status, SchemaStatus.class));
        return indexLabel;
    }

    private String writeEdgeId(Id id, boolean withOwnerVertex) {
        EdgeId edgeId = id instanceof EdgeId ? (EdgeId)id : EdgeId.parse(id.asString());
        ArrayList<String> list = new ArrayList<String>(5);
        if (withOwnerVertex) {
            list.add(TextSerializer.writeEntryId(edgeId.ownerVertexId()));
        }
        list.add(TextSerializer.writeType(edgeId.direction().type()));
        list.add(TextSerializer.writeId(edgeId.edgeLabelId()));
        list.add(TextSerializer.writeEdgeName(edgeId.sortValues()));
        list.add(TextSerializer.writeEntryId(edgeId.otherVertexId()));
        return EdgeId.concat(list.toArray(new String[0]));
    }

    private static String writeType(HugeType type) {
        return type.string();
    }

    private static String writeEntryId(Id id) {
        return IdUtil.writeString(id);
    }

    private static Id readEntryId(String id) {
        return IdUtil.readString(id);
    }

    private static String writeEdgeName(String name) {
        return name + EDGE_NAME_ENDING;
    }

    private static String readEdgeName(String name) {
        E.checkState((boolean)name.endsWith(EDGE_NAME_ENDING), (String)"Invalid edge name: %s", (Object[])new Object[]{name});
        return name.substring(0, name.length() - 1);
    }

    private static String writeId(Id id) {
        if (id.number()) {
            return JsonUtil.toJson(id.asLong());
        }
        return JsonUtil.toJson(id.asString());
    }

    private static Id readId(String id) {
        Object value = JsonUtil.fromJson(id, Object.class);
        if (value instanceof Number) {
            return IdGenerator.of(((Number)value).longValue());
        }
        assert (value instanceof String);
        return IdGenerator.of(value.toString());
    }

    private static Id readId(Id id) {
        return TextSerializer.readId(id.asString());
    }

    private static String writeIds(Collection<Id> ids) {
        Object[] array = new Object[ids.size()];
        int i = 0;
        for (Id id : ids) {
            if (id.number()) {
                array[i++] = id.asLong();
                continue;
            }
            array[i++] = id.asString();
        }
        return JsonUtil.toJson(array);
    }

    private static Id[] readIds(String str) {
        Object[] values = JsonUtil.fromJson(str, Object[].class);
        Id[] ids = new Id[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value instanceof Number) {
                ids[i] = IdGenerator.of(((Number)value).longValue());
                continue;
            }
            assert (value instanceof String);
            ids[i] = IdGenerator.of(value.toString());
        }
        return ids;
    }

    private static String writeElementId(Id id, long expiredTime) {
        Object[] array = new Object[1];
        Object idValue = id.number() ? Long.valueOf(id.asLong()) : id.asString();
        array[0] = expiredTime <= 0L ? id : ImmutableMap.of((Object)HugeKeys.ID.string(), (Object)idValue, (Object)HugeKeys.EXPIRED_TIME.string(), (Object)expiredTime);
        return JsonUtil.toJson(array);
    }

    private static HugeIndex.IdWithExpiredTime[] readElementIds(String str) {
        Object[] values = JsonUtil.fromJson(str, Object[].class);
        HugeIndex.IdWithExpiredTime[] ids = new HugeIndex.IdWithExpiredTime[values.length];
        for (int i = 0; i < values.length; ++i) {
            Id id;
            long expiredTime;
            Object idValue;
            if (values[i] instanceof Map) {
                Map map = (Map)values[i];
                idValue = map.get(HugeKeys.ID.string());
                expiredTime = ((Number)map.get(HugeKeys.EXPIRED_TIME.string())).longValue();
            } else {
                idValue = values[i];
                expiredTime = 0L;
            }
            if (idValue instanceof Number) {
                id = IdGenerator.of(((Number)idValue).longValue());
            } else {
                assert (idValue instanceof String);
                id = IdGenerator.of(idValue.toString());
            }
            ids[i] = new HugeIndex.IdWithExpiredTime(id, expiredTime);
        }
        return ids;
    }

    private static String writeLong(long value) {
        return JsonUtil.toJson(value);
    }

    private static long readLong(String value) {
        return Long.parseLong(value);
    }

    private static void writeUserdata(SchemaElement schema, TextBackendEntry entry) {
        entry.column(HugeKeys.USER_DATA, JsonUtil.toJson(schema.userdata()));
    }

    private static void readUserdata(SchemaElement schema, TextBackendEntry entry) {
        String userdataStr = entry.column(HugeKeys.USER_DATA);
        Map userdata = JsonUtil.fromJson(userdataStr, Map.class);
        for (Map.Entry e : userdata.entrySet()) {
            schema.userdata((String)e.getKey(), e.getValue());
        }
    }
}

