/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.query;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.IdQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.iterator.CIter;
import org.apache.hugegraph.iterator.FlatMapperIterator;
import org.apache.hugegraph.iterator.ListIterator;
import org.apache.hugegraph.iterator.MapperIterator;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.type.Idfiable;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public class QueryResults<R> {
    private static final Iterator<?> EMPTY_ITERATOR = new EmptyIterator();
    private static final QueryResults<?> EMPTY = new QueryResults(QueryResults.emptyIterator(), Query.NONE);
    private final Iterator<R> results;
    private final List<Query> queries;

    public QueryResults(Iterator<R> results, Query query) {
        this(results);
        super.addQuery(query);
    }

    private QueryResults(Iterator<R> results) {
        this.results = results;
        this.queries = InsertionOrderUtil.newList();
    }

    public void setQuery(Query query) {
        if (!this.queries.isEmpty()) {
            this.queries.clear();
        }
        this.addQuery(query);
    }

    private void addQuery(Query query) {
        E.checkNotNull((Object)query, (String)"query");
        this.queries.add(query);
    }

    private void addQueries(List<Query> queries) {
        assert (!queries.isEmpty());
        for (Query query : queries) {
            this.addQuery(query);
        }
    }

    public Iterator<R> iterator() {
        return this.results;
    }

    public R one() {
        return QueryResults.one(this.results);
    }

    public QueryResults<R> toList() {
        QueryResults<R> fetched = new QueryResults<R>(QueryResults.toList(this.results));
        super.addQueries(this.queries);
        return fetched;
    }

    public List<Query> queries() {
        return Collections.unmodifiableList(this.queries);
    }

    public <T extends Idfiable> Iterator<T> keepInputOrderIfNeeded(Iterator<T> origin) {
        Collection<Id> ids;
        if (!origin.hasNext()) {
            return origin;
        }
        if (!this.mustSortByInputIds() || this.paging() || (ids = this.queryIds()).size() <= 1) {
            return origin;
        }
        Map map = InsertionOrderUtil.newMap();
        QueryResults.fillMap(origin, map);
        if (map.size() > ids.size()) {
            ids = map.keySet();
        }
        return new MapperIterator(ids.iterator(), map::get);
    }

    private boolean mustSortByInputIds() {
        assert (!this.queries.isEmpty()) : this;
        for (Query query : this.queries) {
            if (!(query instanceof IdQuery) || !((IdQuery)query).mustSortByInput()) continue;
            return true;
        }
        return false;
    }

    private boolean paging() {
        assert (!this.queries.isEmpty());
        for (Query query : this.queries) {
            Query origin = query.originQuery();
            if (!query.paging() && (origin == null || !origin.paging())) continue;
            return true;
        }
        return false;
    }

    private boolean bigCapacity() {
        assert (!this.queries.isEmpty());
        for (Query query : this.queries) {
            if (!query.bigCapacity()) continue;
            return true;
        }
        return false;
    }

    private Collection<Id> queryIds() {
        assert (!this.queries.isEmpty());
        if (this.queries.size() == 1) {
            return this.queries.get(0).ids();
        }
        Set ids = InsertionOrderUtil.newSet();
        for (Query query : this.queries) {
            ids.addAll(query.ids());
        }
        return ids;
    }

    @PerfUtil.Watched
    public static <T> ListIterator<T> toList(Iterator<T> iterator) {
        try {
            ListIterator listIterator = new ListIterator(800000L, iterator);
            return listIterator;
        }
        finally {
            CloseableIterator.closeIterator(iterator);
        }
    }

    @PerfUtil.Watched
    public static <T> void fillList(Iterator<T> iterator, List<T> list) {
        try {
            while (iterator.hasNext()) {
                T result = iterator.next();
                list.add(result);
                Query.checkForceCapacity(list.size());
            }
        }
        finally {
            CloseableIterator.closeIterator(iterator);
        }
    }

    @PerfUtil.Watched
    public static <T extends Idfiable> void fillMap(Iterator<T> iterator, Map<Id, T> map) {
        try {
            while (iterator.hasNext()) {
                Idfiable result = (Idfiable)iterator.next();
                assert (result.id() != null);
                map.put(result.id(), result);
                Query.checkForceCapacity(map.size());
            }
        }
        finally {
            CloseableIterator.closeIterator(iterator);
        }
    }

    public static <T, R> QueryResults<R> flatMap(Iterator<T> iterator, Function<T, QueryResults<R>> func) {
        QueryResults[] qr;
        qr = new QueryResults[]{new QueryResults<R>(new FlatMapperIterator(iterator, i -> {
            QueryResults results = (QueryResults)func.apply(i);
            if (results == null || !results.iterator().hasNext()) {
                return null;
            }
            qr[0].addQueries(results.queries());
            return results.iterator();
        }))};
        return qr[0];
    }

    @PerfUtil.Watched
    public static <T> T one(Iterator<T> iterator) {
        try {
            if (iterator.hasNext()) {
                T result = iterator.next();
                if (iterator.hasNext()) {
                    throw new HugeException("Expect just one result, but got at least two: [%s, %s]", result, iterator.next());
                }
                T t = result;
                return t;
            }
        }
        finally {
            CloseableIterator.closeIterator(iterator);
        }
        return null;
    }

    public static <T> Iterator<T> iterator(T elem) {
        return new OneIterator<T>(elem);
    }

    public static <T> QueryResults<T> empty() {
        return EMPTY;
    }

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    private static class OneIterator<T>
    implements CIter<T> {
        private T element;

        public OneIterator(T element) {
            assert (element != null);
            this.element = element;
        }

        public Object metadata(String meta, Object ... args) {
            return null;
        }

        public boolean hasNext() {
            return this.element != null;
        }

        public T next() {
            if (this.element == null) {
                throw new NoSuchElementException();
            }
            T result = this.element;
            this.element = null;
            return result;
        }

        public void close() throws Exception {
        }
    }

    private static class EmptyIterator<T>
    implements CIter<T> {
        private EmptyIterator() {
        }

        public Object metadata(String meta, Object ... args) {
            return null;
        }

        public boolean hasNext() {
            return false;
        }

        public T next() {
            throw new NoSuchElementException();
        }

        public void close() throws Exception {
        }
    }

    public static interface Fetcher<R>
    extends Function<Query, QueryResults<R>> {
    }
}

