/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.SplicingIdGenerator;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.IdQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeProperty;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.LongEncoding;
import org.apache.hugegraph.util.NumericUtil;

public class ConditionQuery
extends IdQuery {
    public static final char INDEX_SYM_MIN = '\u0000';
    public static final String INDEX_SYM_ENDING = "\u0000";
    public static final String INDEX_SYM_NULL = "\u0001";
    public static final String INDEX_SYM_EMPTY = "\u0002";
    public static final char INDEX_SYM_MAX = '\u0003';
    public static final String INDEX_VALUE_NULL = "<null>";
    public static final String INDEX_VALUE_EMPTY = "<empty>";
    public static final Set<String> IGNORE_SYM_SET;
    private static final List<Condition> EMPTY_CONDITIONS;
    private List<Condition> conditions = EMPTY_CONDITIONS;
    private OptimizedType optimizedType = OptimizedType.NONE;
    private ResultsFilter resultsFilter = null;
    private Element2IndexValueMap element2IndexValueMap = null;

    public ConditionQuery(HugeType resultType) {
        super(resultType);
    }

    public ConditionQuery(HugeType resultType, Query originQuery) {
        super(resultType, originQuery);
    }

    public ConditionQuery query(Condition condition) {
        Condition.Relation relation;
        if (condition instanceof Condition.Relation && (relation = (Condition.Relation)condition).key().equals((Object)HugeKeys.ID) && relation.relation() == Condition.RelationType.EQ) {
            E.checkArgument((boolean)(relation.value() instanceof Id), (String)"Invalid id value '%s'", (Object[])new Object[]{relation.value()});
            super.query((Id)relation.value());
            return this;
        }
        if (this.conditions == EMPTY_CONDITIONS) {
            this.conditions = InsertionOrderUtil.newList();
        }
        this.conditions.add(condition);
        return this;
    }

    public ConditionQuery query(List<Condition> conditions) {
        for (Condition condition : conditions) {
            this.query(condition);
        }
        return this;
    }

    public ConditionQuery eq(HugeKeys key, Object value) {
        return this.query(Condition.eq(key, value));
    }

    public ConditionQuery gt(HugeKeys key, Object value) {
        return this.query(Condition.gt(key, value));
    }

    public ConditionQuery gte(HugeKeys key, Object value) {
        return this.query(Condition.gte(key, value));
    }

    public ConditionQuery lt(HugeKeys key, Object value) {
        return this.query(Condition.lt(key, value));
    }

    public ConditionQuery lte(HugeKeys key, Object value) {
        return this.query(Condition.lte(key, value));
    }

    public ConditionQuery neq(HugeKeys key, Object value) {
        return this.query(Condition.neq(key, value));
    }

    public ConditionQuery prefix(HugeKeys key, Id value) {
        return this.query(Condition.prefix(key, value));
    }

    public ConditionQuery key(HugeKeys key, Object value) {
        return this.query(Condition.containsKey(key, value));
    }

    public ConditionQuery scan(String start, String end) {
        return this.query(Condition.scan(start, end));
    }

    @Override
    public int conditionsSize() {
        return this.conditions.size();
    }

    @Override
    public Collection<Condition> conditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    public void resetConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public void resetConditions() {
        this.conditions = EMPTY_CONDITIONS;
    }

    public void recordIndexValue(Id propertyId, Id id, Object indexValue) {
        this.element2IndexValueMap().addIndexValue(propertyId, id, indexValue);
    }

    public void selectedIndexField(Id indexField) {
        this.element2IndexValueMap().selectedIndexField(indexField);
    }

    public void removeElementLeftIndex(Id elementId) {
        if (this.element2IndexValueMap == null) {
            return;
        }
        this.element2IndexValueMap.removeElementLeftIndex(elementId);
    }

    public boolean existLeftIndex(Id elementId) {
        return this.getLeftIndexOfElement(elementId) != null;
    }

    public Set<LeftIndex> getLeftIndexOfElement(Id elementId) {
        if (this.element2IndexValueMap == null) {
            return null;
        }
        return this.element2IndexValueMap.getLeftIndex(elementId);
    }

    private Element2IndexValueMap element2IndexValueMap() {
        if (this.element2IndexValueMap == null) {
            this.element2IndexValueMap = new Element2IndexValueMap();
        }
        return this.element2IndexValueMap;
    }

    public List<Condition.Relation> relations() {
        ArrayList<Condition.Relation> relations = new ArrayList<Condition.Relation>();
        for (Condition c : this.conditions) {
            relations.addAll(c.relations());
        }
        return relations;
    }

    public Condition.Relation relation(Id key) {
        for (Condition.Relation r : this.relations()) {
            if (!r.key().equals(key)) continue;
            return r;
        }
        return null;
    }

    @PerfUtil.Watched
    public <T> T condition(Object key) {
        Object valueAsList;
        Object value;
        List valuesEQ = InsertionOrderUtil.newList();
        List valuesIN = InsertionOrderUtil.newList();
        for (Condition condition : this.conditions) {
            Condition.Relation r;
            if (!condition.isRelation() || !(r = (Condition.Relation)condition).key().equals(key)) continue;
            if (r.relation() == Condition.RelationType.EQ) {
                valuesEQ.add(r.value());
                continue;
            }
            if (r.relation() != Condition.RelationType.IN) continue;
            Object value2 = r.value();
            assert (value2 instanceof List);
            valuesIN.add(value2);
        }
        if (valuesEQ.isEmpty() && valuesIN.isEmpty()) {
            return null;
        }
        if (valuesEQ.size() == 1 && valuesIN.isEmpty()) {
            value = valuesEQ.get(0);
            return (T)value;
        }
        if (valuesEQ.isEmpty() && valuesIN.size() == 1) {
            value = valuesIN.get(0);
            return (T)value;
        }
        Set intersectValues = InsertionOrderUtil.newSet();
        for (Object value3 : valuesEQ) {
            valueAsList = ImmutableList.of(value3);
            if (intersectValues.isEmpty()) {
                intersectValues.addAll(valueAsList);
                continue;
            }
            CollectionUtil.intersectWithModify((Collection)intersectValues, (Collection)valueAsList);
        }
        for (Object value2 : valuesIN) {
            valueAsList = (List)value2;
            if (intersectValues.isEmpty()) {
                intersectValues.addAll(valueAsList);
                continue;
            }
            CollectionUtil.intersectWithModify((Collection)intersectValues, (Collection)valueAsList);
        }
        if (intersectValues.isEmpty()) {
            return null;
        }
        E.checkState((intersectValues.size() == 1 ? 1 : 0) != 0, (String)"Illegal key '%s' with more than one value: %s", (Object[])new Object[]{key, intersectValues});
        Object e = intersectValues.iterator().next();
        return (T)e;
    }

    public void unsetCondition(Object key) {
        this.conditions.removeIf(c -> c.isRelation() && ((Condition.Relation)c).key().equals(key));
    }

    public boolean containsCondition(HugeKeys key) {
        for (Condition c : this.conditions) {
            Condition.Relation r;
            if (!c.isRelation() || !(r = (Condition.Relation)c).key().equals((Object)key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsRelation(HugeKeys key, Condition.RelationType type) {
        for (Condition.Relation r : this.relations()) {
            if (!r.key().equals((Object)key) || !r.relation().equals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean containsRelation(Condition.RelationType type) {
        for (Condition.Relation r : this.relations()) {
            if (!r.relation().equals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean containsScanRelation() {
        return this.containsRelation(Condition.RelationType.SCAN);
    }

    public boolean containsContainsCondition(Id key) {
        for (Condition.Relation r : this.relations()) {
            if (!r.key().equals(key)) continue;
            return r.relation().equals(Condition.RelationType.CONTAINS) || r.relation().equals(Condition.RelationType.TEXT_CONTAINS);
        }
        return false;
    }

    public boolean allSysprop() {
        for (Condition c : this.conditions) {
            if (c.isSysprop()) continue;
            return false;
        }
        return true;
    }

    public boolean allRelation() {
        for (Condition c : this.conditions) {
            if (c.isRelation()) continue;
            return false;
        }
        return true;
    }

    public List<Condition> syspropConditions() {
        this.checkFlattened();
        ArrayList<Condition> conds = new ArrayList<Condition>();
        for (Condition c : this.conditions) {
            if (!c.isSysprop()) continue;
            conds.add(c);
        }
        return conds;
    }

    public List<Condition> syspropConditions(HugeKeys key) {
        this.checkFlattened();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (Condition condition : this.conditions) {
            Condition.Relation relation = (Condition.Relation)condition;
            if (!relation.key().equals((Object)key)) continue;
            conditions.add(relation);
        }
        return conditions;
    }

    public List<Condition> userpropConditions() {
        this.checkFlattened();
        ArrayList<Condition> conds = new ArrayList<Condition>();
        for (Condition c : this.conditions) {
            if (c.isSysprop()) continue;
            conds.add(c);
        }
        return conds;
    }

    public List<Condition> userpropConditions(Id key) {
        this.checkFlattened();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (Condition condition : this.conditions) {
            Condition.Relation relation = (Condition.Relation)condition;
            if (!relation.key().equals(key)) continue;
            conditions.add(relation);
        }
        return conditions;
    }

    public List<Condition.Relation> userpropRelations() {
        ArrayList<Condition.Relation> relations = new ArrayList<Condition.Relation>();
        for (Condition.Relation r : this.relations()) {
            if (r.isSysprop()) continue;
            relations.add(r);
        }
        return relations;
    }

    public void resetUserpropConditions() {
        this.conditions.removeIf(condition -> !condition.isSysprop());
    }

    public Set<Id> userpropKeys() {
        LinkedHashSet<Id> keys = new LinkedHashSet<Id>();
        for (Condition.Relation r : this.relations()) {
            if (r.isSysprop()) continue;
            Condition.UserpropRelation ur = (Condition.UserpropRelation)r;
            keys.add(ur.key());
        }
        return keys;
    }

    public String userpropValuesString(List<Id> fields) {
        ArrayList<Object> values = new ArrayList<Object>(fields.size());
        for (Id field : fields) {
            boolean got = false;
            for (Condition.Relation r : this.userpropRelations()) {
                if (!r.key().equals(field) || r.isSysprop()) continue;
                E.checkState((r.relation == Condition.RelationType.EQ || r.relation == Condition.RelationType.CONTAINS ? 1 : 0) != 0, (String)"Method userpropValues(List<String>) only used for secondary index, relation must be EQ or CONTAINS, but got %s", (Object[])new Object[]{r.relation()});
                values.add(r.serialValue());
                got = true;
            }
            if (got) continue;
            throw new BackendException("No such userprop named '%s' in the query '%s'", field, this);
        }
        return ConditionQuery.concatValues(values);
    }

    public Set<Object> userpropValues(Id field) {
        HashSet<Object> values = new HashSet<Object>();
        for (Condition.Relation r : this.userpropRelations()) {
            if (!r.key().equals(field)) continue;
            values.add(r.serialValue());
        }
        return values;
    }

    public Object userpropValue(Id field) {
        Set<Object> values = this.userpropValues(field);
        if (values.isEmpty()) {
            return null;
        }
        E.checkState((values.size() == 1 ? 1 : 0) != 0, (String)"Expect one user-property value of field '%s', but got '%s'", (Object[])new Object[]{field, values.size()});
        return values.iterator().next();
    }

    public boolean hasRangeCondition() {
        for (Condition.Relation r : this.relations()) {
            if (!r.relation().isRangeType()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSearchCondition() {
        for (Condition.Relation r : this.relations()) {
            if (!r.relation().isSearchType()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSecondaryCondition() {
        for (Condition.Relation r : this.relations()) {
            if (!r.relation().isSecondaryType()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNeqCondition() {
        for (Condition.Relation r : this.relations()) {
            if (r.relation() != Condition.RelationType.NEQ) continue;
            return true;
        }
        return false;
    }

    public boolean matchUserpropKeys(List<Id> keys) {
        Set<Id> conditionKeys = this.userpropKeys();
        return !keys.isEmpty() && conditionKeys.containsAll(keys);
    }

    @Override
    public ConditionQuery copy() {
        ConditionQuery query = (ConditionQuery)super.copy();
        query.originQuery(this);
        if (query.conditions != EMPTY_CONDITIONS) {
            query.conditions = InsertionOrderUtil.newList(this.conditions);
        }
        query.optimizedType = OptimizedType.NONE;
        query.resultsFilter = null;
        return query;
    }

    public ConditionQuery copyAndResetUnshared() {
        ConditionQuery query = this.copy();
        query.optimizedType = OptimizedType.NONE;
        query.resultsFilter = null;
        return query;
    }

    public Condition.Relation copyRelationAndUpdateQuery(Object key) {
        Condition.Relation copyRes = null;
        for (int i = 0; i < this.conditions.size(); ++i) {
            Condition.Relation r;
            Condition c = this.conditions.get(i);
            if (!c.isRelation() || !(r = (Condition.Relation)c).key().equals(key)) continue;
            copyRes = r.copy();
            this.conditions.set(i, copyRes);
            break;
        }
        E.checkArgument((copyRes != null ? 1 : 0) != 0, (String)"Failed to copy Condition.Relation: %s", (Object[])new Object[]{key});
        return copyRes;
    }

    @Override
    public boolean test(HugeElement element) {
        if (!this.ids().isEmpty() && !super.test(element)) {
            return false;
        }
        if (this.resultsFilter != null && !element.fresh()) {
            return this.resultsFilter.test(element);
        }
        boolean valid = true;
        for (Condition cond : this.conditions) {
            valid &= cond.test(element);
            valid &= this.element2IndexValueMap == null || this.element2IndexValueMap.checkRangeIndex(element, cond);
        }
        return valid;
    }

    public void checkFlattened() {
        E.checkState((boolean)this.isFlattened(), (String)"Query has none-flatten condition: %s", (Object[])new Object[]{this});
    }

    public boolean isFlattened() {
        for (Condition condition : this.conditions) {
            if (condition.isFlattened()) continue;
            return false;
        }
        return true;
    }

    public boolean mayHasDupKeys(Set<HugeKeys> keys) {
        HashMap<HugeKeys, Integer> keyCounts = new HashMap<HugeKeys, Integer>();
        for (Condition condition : this.conditions) {
            if (!condition.isRelation()) {
                return true;
            }
            Condition.Relation relation = (Condition.Relation)condition;
            if (!keys.contains(relation.key())) continue;
            int keyCount = keyCounts.getOrDefault(relation.key(), 0);
            if (++keyCount > 1) {
                return true;
            }
            keyCounts.put((HugeKeys)((Object)relation.key()), keyCount);
        }
        return false;
    }

    public void optimized(OptimizedType optimizedType) {
        assert (this.optimizedType.ordinal() <= optimizedType.ordinal()) : (Object)((Object)this.optimizedType) + " !<= " + (Object)((Object)optimizedType);
        this.optimizedType = optimizedType;
        Query originQuery = this.originQuery();
        if (originQuery instanceof ConditionQuery) {
            ConditionQuery cq = (ConditionQuery)originQuery;
            if (optimizedType.ordinal() > cq.optimized().ordinal()) {
                cq.optimized(optimizedType);
            }
        }
    }

    public OptimizedType optimized() {
        return this.optimizedType;
    }

    public void registerResultsFilter(ResultsFilter filter) {
        assert (this.resultsFilter == null);
        this.resultsFilter = filter;
    }

    public void updateResultsFilter() {
        Query originQuery = this.originQuery();
        if (originQuery instanceof ConditionQuery) {
            ConditionQuery originCQ = (ConditionQuery)originQuery;
            if (this.resultsFilter != null) {
                originCQ.updateResultsFilter(this.resultsFilter);
            } else {
                originCQ.updateResultsFilter();
            }
        }
    }

    protected void updateResultsFilter(ResultsFilter filter) {
        this.resultsFilter = filter;
        Query originQuery = this.originQuery();
        if (originQuery instanceof ConditionQuery) {
            ConditionQuery originCQ = (ConditionQuery)originQuery;
            originCQ.updateResultsFilter(filter);
        }
    }

    public ConditionQuery originConditionQuery() {
        Query originQuery = this.originQuery();
        if (!(originQuery instanceof ConditionQuery)) {
            return null;
        }
        while (originQuery.originQuery() instanceof ConditionQuery) {
            originQuery = originQuery.originQuery();
        }
        return (ConditionQuery)originQuery;
    }

    public static String concatValues(List<?> values) {
        assert (!values.isEmpty());
        ArrayList<String> newValues = new ArrayList<String>(values.size());
        for (Object v : values) {
            newValues.add(ConditionQuery.concatValues(v));
        }
        return SplicingIdGenerator.concatValues(newValues);
    }

    public static String concatValues(Object value) {
        if (value instanceof String) {
            return ConditionQuery.escapeSpecialValueIfNeeded((String)value);
        }
        if (value instanceof List) {
            return ConditionQuery.concatValues((List)value);
        }
        if (ConditionQuery.needConvertNumber(value)) {
            return LongEncoding.encodeNumber((Object)value);
        }
        return ConditionQuery.escapeSpecialValueIfNeeded(value.toString());
    }

    private static boolean needConvertNumber(Object value) {
        return NumericUtil.isNumber((Object)value) || value instanceof Date;
    }

    private static String escapeSpecialValueIfNeeded(String value) {
        if (value.isEmpty()) {
            value = INDEX_SYM_EMPTY;
        } else if (value == INDEX_VALUE_EMPTY) {
            value = "";
        } else if (value == INDEX_VALUE_NULL) {
            value = INDEX_SYM_NULL;
        } else {
            char ch = value.charAt(0);
            if (ch <= '\u0003') {
                E.checkArgument((boolean)false, (String)"Illegal leading char '\\u%s' in index property: '%s'", (Object[])new Object[]{(int)ch, value});
            }
        }
        return value;
    }

    static {
        ArrayList<String> list = new ArrayList<String>(3);
        for (char ch = '\u0000'; ch <= '\u0003'; ch = (char)(ch + '\u0001')) {
            list.add(String.valueOf(ch));
        }
        IGNORE_SYM_SET = ImmutableSet.copyOf(list);
        EMPTY_CONDITIONS = ImmutableList.of();
    }

    public static interface ResultsFilter {
        public boolean test(HugeElement var1);
    }

    public static final class LeftIndex {
        private final Set<Object> indexFieldValues;
        private final Id indexField;

        public LeftIndex(Set<Object> indexFieldValues, Id indexField) {
            this.indexFieldValues = indexFieldValues;
            this.indexField = indexField;
        }

        public Set<Object> indexFieldValues() {
            return this.indexFieldValues;
        }

        public Id indexField() {
            return this.indexField;
        }
    }

    public static final class Element2IndexValueMap {
        private final Map<Id, Set<LeftIndex>> leftIndexMap;
        private final Map<Id, Map<Id, Set<Object>>> filed2IndexValues = new HashMap<Id, Map<Id, Set<Object>>>();
        private Id selectedIndexField;

        public Element2IndexValueMap() {
            this.leftIndexMap = new HashMap<Id, Set<LeftIndex>>();
        }

        public void addIndexValue(Id indexField, Id elementId, Object indexValue) {
            Map<Id, Set<Object>> element2IndexValueMap;
            if (!this.filed2IndexValues.containsKey(indexField)) {
                this.filed2IndexValues.putIfAbsent(indexField, new HashMap());
            }
            if ((element2IndexValueMap = this.filed2IndexValues.get(indexField)).containsKey(elementId)) {
                element2IndexValueMap.get(elementId).add(indexValue);
            } else {
                element2IndexValueMap.put(elementId, Sets.newHashSet((Object[])new Object[]{indexValue}));
            }
        }

        public void selectedIndexField(Id indexField) {
            this.selectedIndexField = indexField;
        }

        public Set<Object> toRemoveIndexValues(Id indexField, Id elementId) {
            if (!this.filed2IndexValues.containsKey(indexField)) {
                return null;
            }
            return this.filed2IndexValues.get(indexField).get(elementId);
        }

        public void addLeftIndex(Id elementId, Id indexField, Set<Object> indexValues) {
            LeftIndex leftIndex = new LeftIndex(indexValues, indexField);
            if (this.leftIndexMap.containsKey(elementId)) {
                this.leftIndexMap.get(elementId).add(leftIndex);
            } else {
                this.leftIndexMap.put(elementId, Sets.newHashSet((Object[])new LeftIndex[]{leftIndex}));
            }
        }

        public Set<LeftIndex> getLeftIndex(Id elementId) {
            return this.leftIndexMap.get(elementId);
        }

        public void removeElementLeftIndex(Id elementId) {
            this.leftIndexMap.remove(elementId);
        }

        public boolean checkRangeIndex(HugeElement element, Condition cond) {
            if (!(cond instanceof Condition.UserpropRelation)) {
                return true;
            }
            Condition.UserpropRelation propRelation = (Condition.UserpropRelation)cond;
            Id propId = propRelation.key();
            Set<Object> fieldValues = this.toRemoveIndexValues(propId, element.id());
            if (fieldValues == null) {
                return true;
            }
            HugeProperty property = element.getProperty(propId);
            if (property == null) {
                this.addLeftIndex(element.id(), propId, fieldValues);
                return false;
            }
            boolean hasRightValue = Element2IndexValueMap.removeFieldValue(fieldValues, property.value());
            if (!fieldValues.isEmpty()) {
                this.addLeftIndex(element.id(), propId, fieldValues);
            }
            if (this.selectedIndexField != null) {
                return !propId.equals(this.selectedIndexField) || hasRightValue;
            }
            return hasRightValue;
        }

        private static boolean removeFieldValue(Set<Object> values, Object value) {
            for (Object elem : values) {
                if (!Element2IndexValueMap.numberEquals(elem, value)) continue;
                values.remove(elem);
                return true;
            }
            return false;
        }

        private static boolean numberEquals(Object number1, Object number2) {
            BigDecimal b2;
            if (number1.getClass().equals(number2.getClass())) {
                return number1.equals(number2);
            }
            Number n1 = NumericUtil.convertToNumber((Object)number1);
            Number n2 = NumericUtil.convertToNumber((Object)number2);
            BigDecimal b1 = BigDecimal.valueOf(n1.doubleValue());
            return b1.compareTo(b2 = BigDecimal.valueOf(n2.doubleValue())) == 0;
        }
    }

    public static enum OptimizedType {
        NONE,
        PRIMARY_KEY,
        SORT_KEYS,
        INDEX,
        INDEX_FILTER;

    }
}

