//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v3.20.1
// source: meta_service.proto

package metaservicepb

import (
	clusterpb "github.com/apache/incubator-horaedb-proto/golang/pkg/clusterpb"
	commonpb "github.com/apache/incubator-horaedb-proto/golang/pkg/commonpb"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ShardInfo_Status int32

const (
	ShardInfo_Ready       ShardInfo_Status = 0
	ShardInfo_PartialOpen ShardInfo_Status = 1
)

// Enum value maps for ShardInfo_Status.
var (
	ShardInfo_Status_name = map[int32]string{
		0: "Ready",
		1: "PartialOpen",
	}
	ShardInfo_Status_value = map[string]int32{
		"Ready":       0,
		"PartialOpen": 1,
	}
)

func (x ShardInfo_Status) Enum() *ShardInfo_Status {
	p := new(ShardInfo_Status)
	*p = x
	return p
}

func (x ShardInfo_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ShardInfo_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_meta_service_proto_enumTypes[0].Descriptor()
}

func (ShardInfo_Status) Type() protoreflect.EnumType {
	return &file_meta_service_proto_enumTypes[0]
}

func (x ShardInfo_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ShardInfo_Status.Descriptor instead.
func (ShardInfo_Status) EnumDescriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{19, 0}
}

type RequestHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Node        string `protobuf:"bytes,1,opt,name=node,proto3" json:"node,omitempty"`
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
}

func (x *RequestHeader) Reset() {
	*x = RequestHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestHeader) ProtoMessage() {}

func (x *RequestHeader) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestHeader.ProtoReflect.Descriptor instead.
func (*RequestHeader) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{0}
}

func (x *RequestHeader) GetNode() string {
	if x != nil {
		return x.Node
	}
	return ""
}

func (x *RequestHeader) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

type AllocSchemaIdRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Name   string         `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *AllocSchemaIdRequest) Reset() {
	*x = AllocSchemaIdRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocSchemaIdRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocSchemaIdRequest) ProtoMessage() {}

func (x *AllocSchemaIdRequest) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocSchemaIdRequest.ProtoReflect.Descriptor instead.
func (*AllocSchemaIdRequest) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{1}
}

func (x *AllocSchemaIdRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *AllocSchemaIdRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type AllocSchemaIdResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *commonpb.ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Name   string                   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Id     uint32                   `protobuf:"varint,3,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *AllocSchemaIdResponse) Reset() {
	*x = AllocSchemaIdResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocSchemaIdResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocSchemaIdResponse) ProtoMessage() {}

func (x *AllocSchemaIdResponse) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocSchemaIdResponse.ProtoReflect.Descriptor instead.
func (*AllocSchemaIdResponse) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{2}
}

func (x *AllocSchemaIdResponse) GetHeader() *commonpb.ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *AllocSchemaIdResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AllocSchemaIdResponse) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

type CreateTableRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header             *RequestHeader      `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	SchemaName         string              `protobuf:"bytes,2,opt,name=schema_name,json=schemaName,proto3" json:"schema_name,omitempty"`
	Name               string              `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	EncodedSchema      []byte              `protobuf:"bytes,4,opt,name=encoded_schema,json=encodedSchema,proto3" json:"encoded_schema,omitempty"`
	Engine             string              `protobuf:"bytes,5,opt,name=engine,proto3" json:"engine,omitempty"`
	CreateIfNotExist   bool                `protobuf:"varint,6,opt,name=create_if_not_exist,json=createIfNotExist,proto3" json:"create_if_not_exist,omitempty"`
	Options            map[string]string   `protobuf:"bytes,7,rep,name=options,proto3" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	PartitionTableInfo *PartitionTableInfo `protobuf:"bytes,8,opt,name=partition_table_info,json=partitionTableInfo,proto3" json:"partition_table_info,omitempty"`
}

func (x *CreateTableRequest) Reset() {
	*x = CreateTableRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTableRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTableRequest) ProtoMessage() {}

func (x *CreateTableRequest) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTableRequest.ProtoReflect.Descriptor instead.
func (*CreateTableRequest) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateTableRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *CreateTableRequest) GetSchemaName() string {
	if x != nil {
		return x.SchemaName
	}
	return ""
}

func (x *CreateTableRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateTableRequest) GetEncodedSchema() []byte {
	if x != nil {
		return x.EncodedSchema
	}
	return nil
}

func (x *CreateTableRequest) GetEngine() string {
	if x != nil {
		return x.Engine
	}
	return ""
}

func (x *CreateTableRequest) GetCreateIfNotExist() bool {
	if x != nil {
		return x.CreateIfNotExist
	}
	return false
}

func (x *CreateTableRequest) GetOptions() map[string]string {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *CreateTableRequest) GetPartitionTableInfo() *PartitionTableInfo {
	if x != nil {
		return x.PartitionTableInfo
	}
	return nil
}

type PartitionTableInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PartitionInfo *clusterpb.PartitionInfo `protobuf:"bytes,1,opt,name=partition_info,json=partitionInfo,proto3" json:"partition_info,omitempty"`
	SubTableNames []string                 `protobuf:"bytes,2,rep,name=sub_table_names,json=subTableNames,proto3" json:"sub_table_names,omitempty"`
}

func (x *PartitionTableInfo) Reset() {
	*x = PartitionTableInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionTableInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionTableInfo) ProtoMessage() {}

func (x *PartitionTableInfo) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionTableInfo.ProtoReflect.Descriptor instead.
func (*PartitionTableInfo) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{4}
}

func (x *PartitionTableInfo) GetPartitionInfo() *clusterpb.PartitionInfo {
	if x != nil {
		return x.PartitionInfo
	}
	return nil
}

func (x *PartitionTableInfo) GetSubTableNames() []string {
	if x != nil {
		return x.SubTableNames
	}
	return nil
}

type TableInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id            uint64                   `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Name          string                   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	SchemaId      uint32                   `protobuf:"varint,3,opt,name=schema_id,json=schemaId,proto3" json:"schema_id,omitempty"`
	SchemaName    string                   `protobuf:"bytes,4,opt,name=schema_name,json=schemaName,proto3" json:"schema_name,omitempty"`
	PartitionInfo *clusterpb.PartitionInfo `protobuf:"bytes,5,opt,name=partition_info,json=partitionInfo,proto3" json:"partition_info,omitempty"`
}

func (x *TableInfo) Reset() {
	*x = TableInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableInfo) ProtoMessage() {}

func (x *TableInfo) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableInfo.ProtoReflect.Descriptor instead.
func (*TableInfo) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{5}
}

func (x *TableInfo) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *TableInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TableInfo) GetSchemaId() uint32 {
	if x != nil {
		return x.SchemaId
	}
	return 0
}

func (x *TableInfo) GetSchemaName() string {
	if x != nil {
		return x.SchemaName
	}
	return ""
}

func (x *TableInfo) GetPartitionInfo() *clusterpb.PartitionInfo {
	if x != nil {
		return x.PartitionInfo
	}
	return nil
}

type CreateTableResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header       *commonpb.ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	CreatedTable *TableInfo               `protobuf:"bytes,2,opt,name=created_table,json=createdTable,proto3" json:"created_table,omitempty"`
	ShardInfo    *ShardInfo               `protobuf:"bytes,3,opt,name=shard_info,json=shardInfo,proto3" json:"shard_info,omitempty"`
}

func (x *CreateTableResponse) Reset() {
	*x = CreateTableResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTableResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTableResponse) ProtoMessage() {}

func (x *CreateTableResponse) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTableResponse.ProtoReflect.Descriptor instead.
func (*CreateTableResponse) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{6}
}

func (x *CreateTableResponse) GetHeader() *commonpb.ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *CreateTableResponse) GetCreatedTable() *TableInfo {
	if x != nil {
		return x.CreatedTable
	}
	return nil
}

func (x *CreateTableResponse) GetShardInfo() *ShardInfo {
	if x != nil {
		return x.ShardInfo
	}
	return nil
}

type GetTablesOfShardsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header   *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	ShardIds []uint32       `protobuf:"varint,2,rep,packed,name=shard_ids,json=shardIds,proto3" json:"shard_ids,omitempty"`
}

func (x *GetTablesOfShardsRequest) Reset() {
	*x = GetTablesOfShardsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTablesOfShardsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTablesOfShardsRequest) ProtoMessage() {}

func (x *GetTablesOfShardsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTablesOfShardsRequest.ProtoReflect.Descriptor instead.
func (*GetTablesOfShardsRequest) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{7}
}

func (x *GetTablesOfShardsRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetTablesOfShardsRequest) GetShardIds() []uint32 {
	if x != nil {
		return x.ShardIds
	}
	return nil
}

type TablesOfShard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ShardInfo *ShardInfo   `protobuf:"bytes,1,opt,name=shard_info,json=shardInfo,proto3" json:"shard_info,omitempty"`
	Tables    []*TableInfo `protobuf:"bytes,2,rep,name=tables,proto3" json:"tables,omitempty"`
}

func (x *TablesOfShard) Reset() {
	*x = TablesOfShard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TablesOfShard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TablesOfShard) ProtoMessage() {}

func (x *TablesOfShard) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TablesOfShard.ProtoReflect.Descriptor instead.
func (*TablesOfShard) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{8}
}

func (x *TablesOfShard) GetShardInfo() *ShardInfo {
	if x != nil {
		return x.ShardInfo
	}
	return nil
}

func (x *TablesOfShard) GetTables() []*TableInfo {
	if x != nil {
		return x.Tables
	}
	return nil
}

type GetTablesOfShardsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *commonpb.ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// ShardId -> TablesOfShard
	TablesByShard map[uint32]*TablesOfShard `protobuf:"bytes,2,rep,name=tables_by_shard,json=tablesByShard,proto3" json:"tables_by_shard,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *GetTablesOfShardsResponse) Reset() {
	*x = GetTablesOfShardsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTablesOfShardsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTablesOfShardsResponse) ProtoMessage() {}

func (x *GetTablesOfShardsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTablesOfShardsResponse.ProtoReflect.Descriptor instead.
func (*GetTablesOfShardsResponse) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{9}
}

func (x *GetTablesOfShardsResponse) GetHeader() *commonpb.ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetTablesOfShardsResponse) GetTablesByShard() map[uint32]*TablesOfShard {
	if x != nil {
		return x.TablesByShard
	}
	return nil
}

type RouteTablesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header     *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	SchemaName string         `protobuf:"bytes,2,opt,name=schema_name,json=schemaName,proto3" json:"schema_name,omitempty"`
	TableNames []string       `protobuf:"bytes,3,rep,name=table_names,json=tableNames,proto3" json:"table_names,omitempty"`
}

func (x *RouteTablesRequest) Reset() {
	*x = RouteTablesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteTablesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteTablesRequest) ProtoMessage() {}

func (x *RouteTablesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteTablesRequest.ProtoReflect.Descriptor instead.
func (*RouteTablesRequest) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{10}
}

func (x *RouteTablesRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *RouteTablesRequest) GetSchemaName() string {
	if x != nil {
		return x.SchemaName
	}
	return ""
}

func (x *RouteTablesRequest) GetTableNames() []string {
	if x != nil {
		return x.TableNames
	}
	return nil
}

type NodeShard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Endpoint  string     `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	ShardInfo *ShardInfo `protobuf:"bytes,2,opt,name=shard_info,json=shardInfo,proto3" json:"shard_info,omitempty"`
}

func (x *NodeShard) Reset() {
	*x = NodeShard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeShard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeShard) ProtoMessage() {}

func (x *NodeShard) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeShard.ProtoReflect.Descriptor instead.
func (*NodeShard) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{11}
}

func (x *NodeShard) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *NodeShard) GetShardInfo() *ShardInfo {
	if x != nil {
		return x.ShardInfo
	}
	return nil
}

type RouteEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Table      *TableInfo   `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	NodeShards []*NodeShard `protobuf:"bytes,2,rep,name=node_shards,json=nodeShards,proto3" json:"node_shards,omitempty"`
}

func (x *RouteEntry) Reset() {
	*x = RouteEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteEntry) ProtoMessage() {}

func (x *RouteEntry) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteEntry.ProtoReflect.Descriptor instead.
func (*RouteEntry) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{12}
}

func (x *RouteEntry) GetTable() *TableInfo {
	if x != nil {
		return x.Table
	}
	return nil
}

func (x *RouteEntry) GetNodeShards() []*NodeShard {
	if x != nil {
		return x.NodeShards
	}
	return nil
}

type RouteTablesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header                 *commonpb.ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	ClusterTopologyVersion uint64                   `protobuf:"varint,2,opt,name=cluster_topology_version,json=clusterTopologyVersion,proto3" json:"cluster_topology_version,omitempty"`
	// TableName -> RouteEntry
	Entries map[string]*RouteEntry `protobuf:"bytes,3,rep,name=entries,proto3" json:"entries,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *RouteTablesResponse) Reset() {
	*x = RouteTablesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteTablesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteTablesResponse) ProtoMessage() {}

func (x *RouteTablesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteTablesResponse.ProtoReflect.Descriptor instead.
func (*RouteTablesResponse) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{13}
}

func (x *RouteTablesResponse) GetHeader() *commonpb.ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *RouteTablesResponse) GetClusterTopologyVersion() uint64 {
	if x != nil {
		return x.ClusterTopologyVersion
	}
	return 0
}

func (x *RouteTablesResponse) GetEntries() map[string]*RouteEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

type GetNodesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *GetNodesRequest) Reset() {
	*x = GetNodesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNodesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNodesRequest) ProtoMessage() {}

func (x *GetNodesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNodesRequest.ProtoReflect.Descriptor instead.
func (*GetNodesRequest) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{14}
}

func (x *GetNodesRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type GetNodesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header                 *commonpb.ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	ClusterTopologyVersion uint64                   `protobuf:"varint,2,opt,name=cluster_topology_version,json=clusterTopologyVersion,proto3" json:"cluster_topology_version,omitempty"`
	NodeShards             []*NodeShard             `protobuf:"bytes,3,rep,name=node_shards,json=nodeShards,proto3" json:"node_shards,omitempty"`
}

func (x *GetNodesResponse) Reset() {
	*x = GetNodesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNodesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNodesResponse) ProtoMessage() {}

func (x *GetNodesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNodesResponse.ProtoReflect.Descriptor instead.
func (*GetNodesResponse) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{15}
}

func (x *GetNodesResponse) GetHeader() *commonpb.ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetNodesResponse) GetClusterTopologyVersion() uint64 {
	if x != nil {
		return x.ClusterTopologyVersion
	}
	return 0
}

func (x *GetNodesResponse) GetNodeShards() []*NodeShard {
	if x != nil {
		return x.NodeShards
	}
	return nil
}

type DropTableRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header             *RequestHeader      `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	SchemaName         string              `protobuf:"bytes,2,opt,name=schema_name,json=schemaName,proto3" json:"schema_name,omitempty"`
	Name               string              `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	PartitionTableInfo *PartitionTableInfo `protobuf:"bytes,4,opt,name=partition_table_info,json=partitionTableInfo,proto3" json:"partition_table_info,omitempty"`
}

func (x *DropTableRequest) Reset() {
	*x = DropTableRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DropTableRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DropTableRequest) ProtoMessage() {}

func (x *DropTableRequest) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DropTableRequest.ProtoReflect.Descriptor instead.
func (*DropTableRequest) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{16}
}

func (x *DropTableRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *DropTableRequest) GetSchemaName() string {
	if x != nil {
		return x.SchemaName
	}
	return ""
}

func (x *DropTableRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DropTableRequest) GetPartitionTableInfo() *PartitionTableInfo {
	if x != nil {
		return x.PartitionTableInfo
	}
	return nil
}

type DropTableResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header       *commonpb.ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	DroppedTable *TableInfo               `protobuf:"bytes,2,opt,name=dropped_table,json=droppedTable,proto3" json:"dropped_table,omitempty"`
}

func (x *DropTableResponse) Reset() {
	*x = DropTableResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DropTableResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DropTableResponse) ProtoMessage() {}

func (x *DropTableResponse) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DropTableResponse.ProtoReflect.Descriptor instead.
func (*DropTableResponse) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{17}
}

func (x *DropTableResponse) GetHeader() *commonpb.ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *DropTableResponse) GetDroppedTable() *TableInfo {
	if x != nil {
		return x.DroppedTable
	}
	return nil
}

type NodeHeartbeatRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Info   *NodeInfo      `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
}

func (x *NodeHeartbeatRequest) Reset() {
	*x = NodeHeartbeatRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeHeartbeatRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeHeartbeatRequest) ProtoMessage() {}

func (x *NodeHeartbeatRequest) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeHeartbeatRequest.ProtoReflect.Descriptor instead.
func (*NodeHeartbeatRequest) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{18}
}

func (x *NodeHeartbeatRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *NodeHeartbeatRequest) GetInfo() *NodeInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

type ShardInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id      uint32              `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Role    clusterpb.ShardRole `protobuf:"varint,2,opt,name=role,proto3,enum=cluster.ShardRole" json:"role,omitempty"`
	Version uint64              `protobuf:"varint,3,opt,name=version,proto3" json:"version,omitempty"`
	// When status is missing, it means Ready
	Status *ShardInfo_Status `protobuf:"varint,4,opt,name=status,proto3,enum=meta_service.ShardInfo_Status,oneof" json:"status,omitempty"`
}

func (x *ShardInfo) Reset() {
	*x = ShardInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShardInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardInfo) ProtoMessage() {}

func (x *ShardInfo) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardInfo.ProtoReflect.Descriptor instead.
func (*ShardInfo) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{19}
}

func (x *ShardInfo) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *ShardInfo) GetRole() clusterpb.ShardRole {
	if x != nil {
		return x.Role
	}
	return clusterpb.ShardRole(0)
}

func (x *ShardInfo) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *ShardInfo) GetStatus() ShardInfo_Status {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return ShardInfo_Ready
}

type NodeInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ip:port
	Endpoint      string       `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Lease         uint32       `protobuf:"varint,2,opt,name=lease,proto3" json:"lease,omitempty"`
	Zone          string       `protobuf:"bytes,3,opt,name=zone,proto3" json:"zone,omitempty"`
	BinaryVersion string       `protobuf:"bytes,4,opt,name=binary_version,json=binaryVersion,proto3" json:"binary_version,omitempty"`
	ShardInfos    []*ShardInfo `protobuf:"bytes,5,rep,name=shard_infos,json=shardInfos,proto3" json:"shard_infos,omitempty"`
}

func (x *NodeInfo) Reset() {
	*x = NodeInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeInfo) ProtoMessage() {}

func (x *NodeInfo) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeInfo.ProtoReflect.Descriptor instead.
func (*NodeInfo) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{20}
}

func (x *NodeInfo) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *NodeInfo) GetLease() uint32 {
	if x != nil {
		return x.Lease
	}
	return 0
}

func (x *NodeInfo) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *NodeInfo) GetBinaryVersion() string {
	if x != nil {
		return x.BinaryVersion
	}
	return ""
}

func (x *NodeInfo) GetShardInfos() []*ShardInfo {
	if x != nil {
		return x.ShardInfos
	}
	return nil
}

type NodeHeartbeatResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *commonpb.ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *NodeHeartbeatResponse) Reset() {
	*x = NodeHeartbeatResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_meta_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeHeartbeatResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeHeartbeatResponse) ProtoMessage() {}

func (x *NodeHeartbeatResponse) ProtoReflect() protoreflect.Message {
	mi := &file_meta_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeHeartbeatResponse.ProtoReflect.Descriptor instead.
func (*NodeHeartbeatResponse) Descriptor() ([]byte, []int) {
	return file_meta_service_proto_rawDescGZIP(), []int{21}
}

func (x *NodeHeartbeatResponse) GetHeader() *commonpb.ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

var File_meta_service_proto protoreflect.FileDescriptor

var file_meta_service_proto_rawDesc = []byte{
	0x0a, 0x12, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0c, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x1a, 0x0c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x46, 0x0a, 0x0d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x6f, 0x64, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x5f, 0x0a, 0x14, 0x41, 0x6c, 0x6c, 0x6f, 0x63,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x33, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6b, 0x0a, 0x15, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x2e, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x02, 0x69, 0x64, 0x22, 0xc5, 0x03, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x06,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65,
	0x64, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d,
	0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x16, 0x0a,
	0x06, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x2d, 0x0a, 0x13, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x69, 0x66, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x65, 0x78, 0x69, 0x73, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x66, 0x4e, 0x6f, 0x74, 0x45,
	0x78, 0x69, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x52, 0x0a,
	0x14, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x6d, 0x65,
	0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x12, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x1a, 0x3a, 0x0a, 0x0c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7b, 0x0a,
	0x12, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x3d, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x26, 0x0a, 0x0f, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x75, 0x62,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0xac, 0x01, 0x0a, 0x09, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x08, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x0e, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xbb, 0x01, 0x0a, 0x13, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x2e, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x12, 0x3c, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x36, 0x0a, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x73, 0x68,
	0x61, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x6c, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x4f, 0x66, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x68, 0x61, 0x72,
	0x64, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x08, 0x73, 0x68, 0x61,
	0x72, 0x64, 0x49, 0x64, 0x73, 0x22, 0x78, 0x0a, 0x0d, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x4f,
	0x66, 0x53, 0x68, 0x61, 0x72, 0x64, 0x12, 0x36, 0x0a, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6d, 0x65, 0x74,
	0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x09, 0x73, 0x68, 0x61, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2f,
	0x0a, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x22,
	0x8e, 0x02, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x4f, 0x66, 0x53,
	0x68, 0x61, 0x72, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e, 0x0a,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x62, 0x0a,
	0x0f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x5f, 0x62, 0x79, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x4f,
	0x66, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x42, 0x79, 0x53, 0x68, 0x61, 0x72, 0x64, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x42, 0x79, 0x53, 0x68, 0x61, 0x72,
	0x64, 0x1a, 0x5d, 0x0a, 0x12, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x42, 0x79, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x31, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x4f, 0x66,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x8b, 0x01, 0x0a, 0x12, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x5f,
	0x0a, 0x09, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x36, 0x0a, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6d, 0x65,
	0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x73, 0x68, 0x61, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x22,
	0x75, 0x0a, 0x0a, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2d, 0x0a,
	0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x38, 0x0a, 0x0b,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x22, 0x9f, 0x02, 0x0a, 0x13, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e,
	0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x38,
	0x0a, 0x18, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f,
	0x67, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x16, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67,
	0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x6d, 0x65, 0x74, 0x61,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x45, 0x6e, 0x74,
	0x72, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x1a, 0x54, 0x0a, 0x0c, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x46, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x4e,
	0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6d, 0x65,
	0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x22, 0xb6, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x38, 0x0a, 0x18, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x16, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x38, 0x0a, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x0a, 0x6e,
	0x6f, 0x64, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x22, 0xd0, 0x01, 0x0a, 0x10, 0x44, 0x72,
	0x6f, 0x70, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x33,
	0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x14, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x12, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x81, 0x01, 0x0a,
	0x11, 0x44, 0x72, 0x6f, 0x70, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x2e, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x12, 0x3c, 0x0a, 0x0d, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6d, 0x65, 0x74, 0x61,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x0c, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x77, 0x0a, 0x14, 0x4e, 0x6f, 0x64, 0x65, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x2a, 0x0a,
	0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6d, 0x65,
	0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0xcb, 0x01, 0x0a, 0x09, 0x53, 0x68,
	0x61, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x26, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x6d, 0x65, 0x74, 0x61,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x49, 0x6e,
	0x66, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x88, 0x01, 0x01, 0x22, 0x24, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x09, 0x0a, 0x05, 0x52, 0x65, 0x61, 0x64, 0x79, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x4f, 0x70, 0x65, 0x6e, 0x10, 0x01, 0x42, 0x09, 0x0a, 0x07,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xb1, 0x01, 0x0a, 0x08, 0x4e, 0x6f, 0x64, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x14, 0x0a, 0x05, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x05, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x62, 0x69,
	0x6e, 0x61, 0x72, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x38, 0x0a, 0x0b, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x22, 0x47, 0x0a, 0x15, 0x4e,
	0x6f, 0x64, 0x65, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x32, 0xf9, 0x04, 0x0a, 0x0e, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x70, 0x63,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x5a, 0x0a, 0x0d, 0x41, 0x6c, 0x6c, 0x6f, 0x63,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49, 0x44, 0x12, 0x22, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x49, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x12, 0x66, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x4f, 0x66, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x12, 0x26, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x73, 0x4f, 0x66, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x27, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x47, 0x65, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x4f, 0x66, 0x53, 0x68, 0x61, 0x72, 0x64,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x54, 0x0a, 0x0b, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x20, 0x2e, 0x6d, 0x65, 0x74,
	0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x12, 0x4e, 0x0a, 0x09, 0x44, 0x72, 0x6f, 0x70, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1e,
	0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x44, 0x72,
	0x6f, 0x70, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f,
	0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x44, 0x72,
	0x6f, 0x70, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x12, 0x54, 0x0a, 0x0b, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x12, 0x20, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x21, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4b, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x4e, 0x6f,
	0x64, 0x65, 0x73, 0x12, 0x1d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x5a, 0x0a, 0x0d, 0x4e, 0x6f, 0x64, 0x65, 0x48, 0x65, 0x61, 0x72,
	0x74, 0x62, 0x65, 0x61, 0x74, 0x12, 0x22, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65,
	0x61, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x6d, 0x65, 0x74, 0x61,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x48, 0x65, 0x61,
	0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x42, 0x44, 0x5a, 0x42, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2f, 0x69, 0x6e, 0x63, 0x75, 0x62, 0x61, 0x74, 0x6f, 0x72, 0x2d,
	0x68, 0x6f, 0x72, 0x61, 0x65, 0x64, 0x62, 0x2d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_meta_service_proto_rawDescOnce sync.Once
	file_meta_service_proto_rawDescData = file_meta_service_proto_rawDesc
)

func file_meta_service_proto_rawDescGZIP() []byte {
	file_meta_service_proto_rawDescOnce.Do(func() {
		file_meta_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_meta_service_proto_rawDescData)
	})
	return file_meta_service_proto_rawDescData
}

var file_meta_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_meta_service_proto_msgTypes = make([]protoimpl.MessageInfo, 25)
var file_meta_service_proto_goTypes = []interface{}{
	(ShardInfo_Status)(0),             // 0: meta_service.ShardInfo.Status
	(*RequestHeader)(nil),             // 1: meta_service.RequestHeader
	(*AllocSchemaIdRequest)(nil),      // 2: meta_service.AllocSchemaIdRequest
	(*AllocSchemaIdResponse)(nil),     // 3: meta_service.AllocSchemaIdResponse
	(*CreateTableRequest)(nil),        // 4: meta_service.CreateTableRequest
	(*PartitionTableInfo)(nil),        // 5: meta_service.PartitionTableInfo
	(*TableInfo)(nil),                 // 6: meta_service.TableInfo
	(*CreateTableResponse)(nil),       // 7: meta_service.CreateTableResponse
	(*GetTablesOfShardsRequest)(nil),  // 8: meta_service.GetTablesOfShardsRequest
	(*TablesOfShard)(nil),             // 9: meta_service.TablesOfShard
	(*GetTablesOfShardsResponse)(nil), // 10: meta_service.GetTablesOfShardsResponse
	(*RouteTablesRequest)(nil),        // 11: meta_service.RouteTablesRequest
	(*NodeShard)(nil),                 // 12: meta_service.NodeShard
	(*RouteEntry)(nil),                // 13: meta_service.RouteEntry
	(*RouteTablesResponse)(nil),       // 14: meta_service.RouteTablesResponse
	(*GetNodesRequest)(nil),           // 15: meta_service.GetNodesRequest
	(*GetNodesResponse)(nil),          // 16: meta_service.GetNodesResponse
	(*DropTableRequest)(nil),          // 17: meta_service.DropTableRequest
	(*DropTableResponse)(nil),         // 18: meta_service.DropTableResponse
	(*NodeHeartbeatRequest)(nil),      // 19: meta_service.NodeHeartbeatRequest
	(*ShardInfo)(nil),                 // 20: meta_service.ShardInfo
	(*NodeInfo)(nil),                  // 21: meta_service.NodeInfo
	(*NodeHeartbeatResponse)(nil),     // 22: meta_service.NodeHeartbeatResponse
	nil,                               // 23: meta_service.CreateTableRequest.OptionsEntry
	nil,                               // 24: meta_service.GetTablesOfShardsResponse.TablesByShardEntry
	nil,                               // 25: meta_service.RouteTablesResponse.EntriesEntry
	(*commonpb.ResponseHeader)(nil),   // 26: common.ResponseHeader
	(*clusterpb.PartitionInfo)(nil),   // 27: cluster.PartitionInfo
	(clusterpb.ShardRole)(0),          // 28: cluster.ShardRole
}
var file_meta_service_proto_depIdxs = []int32{
	1,  // 0: meta_service.AllocSchemaIdRequest.header:type_name -> meta_service.RequestHeader
	26, // 1: meta_service.AllocSchemaIdResponse.header:type_name -> common.ResponseHeader
	1,  // 2: meta_service.CreateTableRequest.header:type_name -> meta_service.RequestHeader
	23, // 3: meta_service.CreateTableRequest.options:type_name -> meta_service.CreateTableRequest.OptionsEntry
	5,  // 4: meta_service.CreateTableRequest.partition_table_info:type_name -> meta_service.PartitionTableInfo
	27, // 5: meta_service.PartitionTableInfo.partition_info:type_name -> cluster.PartitionInfo
	27, // 6: meta_service.TableInfo.partition_info:type_name -> cluster.PartitionInfo
	26, // 7: meta_service.CreateTableResponse.header:type_name -> common.ResponseHeader
	6,  // 8: meta_service.CreateTableResponse.created_table:type_name -> meta_service.TableInfo
	20, // 9: meta_service.CreateTableResponse.shard_info:type_name -> meta_service.ShardInfo
	1,  // 10: meta_service.GetTablesOfShardsRequest.header:type_name -> meta_service.RequestHeader
	20, // 11: meta_service.TablesOfShard.shard_info:type_name -> meta_service.ShardInfo
	6,  // 12: meta_service.TablesOfShard.tables:type_name -> meta_service.TableInfo
	26, // 13: meta_service.GetTablesOfShardsResponse.header:type_name -> common.ResponseHeader
	24, // 14: meta_service.GetTablesOfShardsResponse.tables_by_shard:type_name -> meta_service.GetTablesOfShardsResponse.TablesByShardEntry
	1,  // 15: meta_service.RouteTablesRequest.header:type_name -> meta_service.RequestHeader
	20, // 16: meta_service.NodeShard.shard_info:type_name -> meta_service.ShardInfo
	6,  // 17: meta_service.RouteEntry.table:type_name -> meta_service.TableInfo
	12, // 18: meta_service.RouteEntry.node_shards:type_name -> meta_service.NodeShard
	26, // 19: meta_service.RouteTablesResponse.header:type_name -> common.ResponseHeader
	25, // 20: meta_service.RouteTablesResponse.entries:type_name -> meta_service.RouteTablesResponse.EntriesEntry
	1,  // 21: meta_service.GetNodesRequest.header:type_name -> meta_service.RequestHeader
	26, // 22: meta_service.GetNodesResponse.header:type_name -> common.ResponseHeader
	12, // 23: meta_service.GetNodesResponse.node_shards:type_name -> meta_service.NodeShard
	1,  // 24: meta_service.DropTableRequest.header:type_name -> meta_service.RequestHeader
	5,  // 25: meta_service.DropTableRequest.partition_table_info:type_name -> meta_service.PartitionTableInfo
	26, // 26: meta_service.DropTableResponse.header:type_name -> common.ResponseHeader
	6,  // 27: meta_service.DropTableResponse.dropped_table:type_name -> meta_service.TableInfo
	1,  // 28: meta_service.NodeHeartbeatRequest.header:type_name -> meta_service.RequestHeader
	21, // 29: meta_service.NodeHeartbeatRequest.info:type_name -> meta_service.NodeInfo
	28, // 30: meta_service.ShardInfo.role:type_name -> cluster.ShardRole
	0,  // 31: meta_service.ShardInfo.status:type_name -> meta_service.ShardInfo.Status
	20, // 32: meta_service.NodeInfo.shard_infos:type_name -> meta_service.ShardInfo
	26, // 33: meta_service.NodeHeartbeatResponse.header:type_name -> common.ResponseHeader
	9,  // 34: meta_service.GetTablesOfShardsResponse.TablesByShardEntry.value:type_name -> meta_service.TablesOfShard
	13, // 35: meta_service.RouteTablesResponse.EntriesEntry.value:type_name -> meta_service.RouteEntry
	2,  // 36: meta_service.MetaRpcService.AllocSchemaID:input_type -> meta_service.AllocSchemaIdRequest
	8,  // 37: meta_service.MetaRpcService.GetTablesOfShards:input_type -> meta_service.GetTablesOfShardsRequest
	4,  // 38: meta_service.MetaRpcService.CreateTable:input_type -> meta_service.CreateTableRequest
	17, // 39: meta_service.MetaRpcService.DropTable:input_type -> meta_service.DropTableRequest
	11, // 40: meta_service.MetaRpcService.RouteTables:input_type -> meta_service.RouteTablesRequest
	15, // 41: meta_service.MetaRpcService.GetNodes:input_type -> meta_service.GetNodesRequest
	19, // 42: meta_service.MetaRpcService.NodeHeartbeat:input_type -> meta_service.NodeHeartbeatRequest
	3,  // 43: meta_service.MetaRpcService.AllocSchemaID:output_type -> meta_service.AllocSchemaIdResponse
	10, // 44: meta_service.MetaRpcService.GetTablesOfShards:output_type -> meta_service.GetTablesOfShardsResponse
	7,  // 45: meta_service.MetaRpcService.CreateTable:output_type -> meta_service.CreateTableResponse
	18, // 46: meta_service.MetaRpcService.DropTable:output_type -> meta_service.DropTableResponse
	14, // 47: meta_service.MetaRpcService.RouteTables:output_type -> meta_service.RouteTablesResponse
	16, // 48: meta_service.MetaRpcService.GetNodes:output_type -> meta_service.GetNodesResponse
	22, // 49: meta_service.MetaRpcService.NodeHeartbeat:output_type -> meta_service.NodeHeartbeatResponse
	43, // [43:50] is the sub-list for method output_type
	36, // [36:43] is the sub-list for method input_type
	36, // [36:36] is the sub-list for extension type_name
	36, // [36:36] is the sub-list for extension extendee
	0,  // [0:36] is the sub-list for field type_name
}

func init() { file_meta_service_proto_init() }
func file_meta_service_proto_init() {
	if File_meta_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_meta_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocSchemaIdRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllocSchemaIdResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTableRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionTableInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTableResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTablesOfShardsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TablesOfShard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTablesOfShardsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteTablesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeShard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteTablesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNodesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNodesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DropTableRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DropTableResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeHeartbeatRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShardInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_meta_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeHeartbeatResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_meta_service_proto_msgTypes[19].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_meta_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   25,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_meta_service_proto_goTypes,
		DependencyIndexes: file_meta_service_proto_depIdxs,
		EnumInfos:         file_meta_service_proto_enumTypes,
		MessageInfos:      file_meta_service_proto_msgTypes,
	}.Build()
	File_meta_service_proto = out.File
	file_meta_service_proto_rawDesc = nil
	file_meta_service_proto_goTypes = nil
	file_meta_service_proto_depIdxs = nil
}
