/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.utils;

import java.nio.ByteBuffer;

public class ByteOrderUtils {
    public static long readLeLong(ByteBuffer buffer) {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value |= (long)buffer.get() << i * 8;
        }
        return value;
    }

    public static void writeLeLong(ByteBuffer buffer, long value) {
        for (int i = 0; i < 8; ++i) {
            buffer.put((byte)(value >> i * 8));
        }
    }

    public static int readLeInt(ByteBuffer buffer) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value |= (buffer.get() & 0xFF) << i * 8;
        }
        return value;
    }

    public static void writeLeInt(ByteBuffer buffer, int value) {
        for (int i = 0; i < 4; ++i) {
            buffer.put((byte)(value >> i * 8));
        }
    }

    public static char readLeChar(ByteBuffer buffer) {
        char value = '\u0000';
        for (int i = 0; i < 2; ++i) {
            value = (char)(value | (char)buffer.get() << i * 8);
        }
        return value;
    }

    public static void writeLeChar(ByteBuffer buffer, char value) {
        for (int i = 0; i < 2; ++i) {
            buffer.put((byte)(value >> i * 8));
        }
    }

    public static byte[] readBytes(ByteBuffer buffer, int size) {
        byte[] bytes = new byte[size];
        buffer.get(bytes);
        return bytes;
    }

    public static void writeBytes(ByteBuffer buffer, byte[] bytes) {
        buffer.put(bytes);
    }
}

