/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.subject;

import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.SubjectCreate;
import com.usthe.sureness.subject.SubjectFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SurenessSubjectFactory
implements SubjectFactory {
    private List<SubjectCreate> subjectCreators;

    @Override
    public List<Subject> createSubjects(Object request) {
        return this.loadSubjectCreators().stream().filter(creator -> creator.canSupportSubject(request)).map(creator -> creator.createSubject(request)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void registerSubjectCreator(List<SubjectCreate> creator) {
        if (this.subjectCreators == null) {
            this.subjectCreators = new LinkedList<SubjectCreate>();
        }
        this.subjectCreators.addAll(creator);
    }

    @Override
    public List<SubjectCreate> loadSubjectCreators() {
        if (this.subjectCreators == null) {
            throw new RuntimeException("subjectFactory not init, not have subjectCreator");
        }
        return this.subjectCreators;
    }
}

