/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.resolver;

import org.eclipse.persistence.jpa.jpql.tools.resolver.AbstractPathResolver;
import org.eclipse.persistence.jpa.jpql.tools.resolver.Resolver;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeVisitor;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.utility.iterable.EmptyIterable;

public class CollectionValuedFieldResolver
extends AbstractPathResolver {
    public CollectionValuedFieldResolver(Resolver parent, String path) {
        super(parent, path);
    }

    @Override
    protected IType buildType() {
        ITypeDeclaration[] typeParameters;
        ITypeDeclaration typeDeclaration = this.getTypeDeclaration();
        IType type = typeDeclaration.getType();
        if (this.getTypeHelper().isCollectionType(type)) {
            ITypeDeclaration[] typeParameters2 = typeDeclaration.getTypeParameters();
            if (typeParameters2.length > 0) {
                type = typeParameters2[0].getType();
            }
        } else if (this.getTypeHelper().isMapType(type) && (typeParameters = typeDeclaration.getTypeParameters()).length == 2) {
            type = typeParameters[1].getType();
        }
        return this.getTypeHelper().convertPrimitive(type);
    }

    @Override
    protected IManagedType resolveManagedType(IMapping mapping) {
        ITypeDeclaration typeDeclaration = mapping.getTypeDeclaration();
        IType type = typeDeclaration.getType();
        if (this.getTypeHelper().isCollectionType(type)) {
            ITypeDeclaration[] typeParameters = typeDeclaration.getTypeParameters();
            if (typeParameters.length == 0) {
                return null;
            }
            type = typeParameters[0].getType();
        } else if (this.getTypeHelper().isMapType(type)) {
            ITypeDeclaration[] typeParameters = typeDeclaration.getTypeParameters();
            if (typeParameters.length != 2) {
                return null;
            }
            type = typeParameters[1].getType();
        }
        return this.getProvider().getManagedType(type);
    }

    protected static class MapManagedType
    implements IManagedType {
        protected final IType mapType;
        protected final IManagedTypeProvider provider;

        protected MapManagedType(IManagedTypeProvider provider, IType mapType) {
            this.provider = provider;
            this.mapType = mapType;
        }

        @Override
        public void accept(IManagedTypeVisitor visitor) {
        }

        @Override
        public int compareTo(IManagedType managedType) {
            return this.getType().getName().compareTo(managedType.getType().getName());
        }

        @Override
        public IMapping getMappingNamed(String name) {
            return null;
        }

        @Override
        public IManagedTypeProvider getProvider() {
            return this.provider;
        }

        @Override
        public IType getType() {
            return this.mapType;
        }

        @Override
        public Iterable<IMapping> mappings() {
            return EmptyIterable.instance();
        }

        public String toString() {
            return this.getType().getName();
        }
    }
}

