/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.StringUtils;

public class ObjectMapperFactory {
    public static ObjectMapper getObjectMapper(String file) {
        String extension = ObjectMapperFactory.getFileExtension(file);
        switch (extension.toLowerCase()) {
            case ".json": {
                return new JsonMapper();
            }
            case ".toml": {
                return new TomlMapper();
            }
        }
        throw new FlywayException("No mapper found for '" + extension + "' extension");
    }

    private static String getFileExtension(String filename) {
        int dotLocation;
        if (StringUtils.hasText(filename) && (dotLocation = filename.lastIndexOf(46)) > 0) {
            return filename.substring(dotLocation);
        }
        return "";
    }
}

