/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.registry.discovery;

import java.util.Objects;
import org.apache.hertzbeat.collector.collect.registry.constant.DiscoveryClientInstance;
import org.apache.hertzbeat.collector.collect.registry.discovery.DiscoveryClient;
import org.apache.hertzbeat.collector.collect.registry.discovery.impl.ConsulDiscoveryClient;
import org.apache.hertzbeat.collector.collect.registry.discovery.impl.NacosDiscoveryClient;
import org.apache.hertzbeat.common.entity.job.protocol.RegistryProtocol;

public class DiscoveryClientManagement {
    public DiscoveryClient getClient(RegistryProtocol registryProtocol) {
        return this.createClient(registryProtocol, DiscoveryClientInstance.getByName(registryProtocol.getDiscoveryClientTypeName()));
    }

    private DiscoveryClient createClient(RegistryProtocol registryProtocol, DiscoveryClientInstance discoveryClientInstance) {
        if (Objects.equals((Object)discoveryClientInstance, (Object)DiscoveryClientInstance.NOT_SUPPORT)) {
            return null;
        }
        return this.doCreateClient(registryProtocol, discoveryClientInstance);
    }

    private DiscoveryClient doCreateClient(RegistryProtocol registryProtocol, DiscoveryClientInstance discoveryClientInstance) {
        DiscoveryClient discoveryClient;
        switch (discoveryClientInstance) {
            case CONSUL: {
                discoveryClient = new ConsulDiscoveryClient();
                break;
            }
            case NACOS: {
                discoveryClient = new NacosDiscoveryClient();
                break;
            }
            default: {
                return null;
            }
        }
        discoveryClient.initClient(discoveryClient.buildConnectConfig(registryProtocol));
        return discoveryClient;
    }
}

