/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.env.convert;

import com.alibaba.nacos.client.env.convert.AbstractPropertyConverter;
import com.alibaba.nacos.client.env.convert.BooleanConverter;
import com.alibaba.nacos.client.env.convert.IntegerConverter;
import com.alibaba.nacos.client.env.convert.LongConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingFormatArgumentException;

public class CompositeConverter {
    private final Map<Class<?>, AbstractPropertyConverter<?>> converterRegistry = new HashMap();

    public CompositeConverter() {
        this.converterRegistry.put(Boolean.class, new BooleanConverter());
        this.converterRegistry.put(Integer.class, new IntegerConverter());
        this.converterRegistry.put(Long.class, new LongConverter());
    }

    public <T> T convert(String property, Class<T> targetClass) {
        AbstractPropertyConverter<?> converter = this.converterRegistry.get(targetClass);
        if (converter == null) {
            throw new MissingFormatArgumentException("converter not found, can't convert from String to " + targetClass.getCanonicalName());
        }
        return (T)converter.convert(property);
    }
}

