/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.taosdata.jdbc.AbstractResultSet;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.DataType;
import com.taosdata.jdbc.rs.RestfulResultSetMetaData;
import com.taosdata.jdbc.utils.Utils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RestfulResultSet
extends AbstractResultSet {
    public static DateTimeFormatter rfc3339Parser = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 2, 9, true).optionalEnd().appendOffset("+HHMM", "Z").toFormatter().withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    Pattern pattern = Pattern.compile("^[0-9a-zT\\-:]+\\.([0-9]+).*$");
    private final Statement statement;
    private final List<List<Object>> resultSet = new ArrayList<List<Object>>();
    private final List<String> columnNames = new ArrayList<String>();
    private final List<Field> columns = new ArrayList<Field>();
    private final RestfulResultSetMetaData metaData;
    private volatile boolean isClosed;
    private int pos = -1;

    public RestfulResultSet(String database, Statement statement, JSONObject resultJson) throws SQLException {
        this.statement = statement;
        JSONArray columnMeta = resultJson.getJSONArray("column_meta");
        JSONArray data = resultJson.getJSONArray("data");
        this.parseColumnMeta_new(columnMeta);
        this.metaData = new RestfulResultSetMetaData(database, this.columns, this);
        if (data == null || data.isEmpty()) {
            return;
        }
        for (int rowIndex = 0; rowIndex < data.size(); ++rowIndex) {
            ArrayList<Object> row = new ArrayList<Object>();
            JSONArray jsonRow = data.getJSONArray(rowIndex);
            for (int colIndex = 0; colIndex < this.metaData.getColumnCount(); ++colIndex) {
                row.add(this.parseColumnData(jsonRow, colIndex, this.columns.get((int)colIndex).taos_type));
            }
            this.resultSet.add(row);
        }
    }

    private void parseColumnMeta_new(JSONArray columnMeta) {
        this.columnNames.clear();
        this.columns.clear();
        for (int colIndex = 0; colIndex < columnMeta.size(); ++colIndex) {
            JSONArray col = columnMeta.getJSONArray(colIndex);
            String col_name = col.getString(0);
            String typeName = col.getString(1);
            DataType type = DataType.getDataType(typeName);
            int col_type = type.getJdbcTypeValue();
            int col_length = col.getInteger(2);
            this.columnNames.add(col_name);
            this.columns.add(new Field(col_name, col_type, col_length, "", type.getTaosTypeValue()));
        }
    }

    private Object parseColumnData(JSONArray row, int colIndex, int taosType) throws SQLException {
        switch (taosType) {
            case 0: {
                return null;
            }
            case 1: {
                return row.getBoolean(colIndex);
            }
            case 2: {
                return row.getByte(colIndex);
            }
            case 3: {
                return row.getShort(colIndex);
            }
            case 4: {
                return row.getInteger(colIndex);
            }
            case 5: {
                return row.getLong(colIndex);
            }
            case 6: {
                return row.getFloat(colIndex);
            }
            case 7: {
                return row.getDouble(colIndex);
            }
            case 9: {
                return this.parseTimestampColumnData(row, colIndex);
            }
            case 8: {
                return row.getString(colIndex) == null ? null : row.getString(colIndex).getBytes();
            }
            case 10: {
                return row.getString(colIndex) == null ? null : row.getString(colIndex);
            }
            case 15: {
                return row.get(colIndex) != null && (row.get(colIndex) instanceof String || row.get(colIndex) instanceof JSONObject) ? JSON.toJSONString((Object)row.get(colIndex), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}) : row.get(colIndex);
            }
        }
        return row.get(colIndex);
    }

    private Timestamp parseTimestampColumnData(JSONArray row, int colIndex) throws SQLException {
        if (row.get(colIndex) == null) {
            return null;
        }
        String value = row.getString(colIndex);
        int index = value.lastIndexOf(":");
        if (index > 19) {
            value = value.substring(0, index) + value.substring(index + 1);
        }
        ZonedDateTime parse = ZonedDateTime.parse(value, rfc3339Parser);
        Matcher matcher = this.pattern.matcher(value);
        int len = 0;
        if (matcher.find()) {
            len = matcher.group(1).length();
        }
        this.timestampPrecision = len > 6 ? 2 : (len > 3 ? 1 : 0);
        return Timestamp.from(parse.toInstant());
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        ++this.pos;
        return this.pos <= this.resultSet.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Class<RestfulResultSet> clazz = RestfulResultSet.class;
        synchronized (RestfulResultSet.class) {
            this.isClosed = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        return value.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return 0;
        }
        long valueAsLong = Long.parseLong(value.toString());
        if (valueAsLong == -128L) {
            return 0;
        }
        if (valueAsLong < -128L || valueAsLong > 127L) {
            this.throwRangeException(value.toString(), columnIndex, -6);
        }
        return (byte)valueAsLong;
    }

    private void throwRangeException(String valueAsString, int columnIndex, int jdbcType) throws SQLException {
        throw TSDBError.createSQLException(8980, "'" + valueAsString + "' in column '" + columnIndex + "' is outside valid range for the jdbcType " + TSDBConstants.jdbcType2TaosTypeName(jdbcType));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return 0;
        }
        long valueAsLong = Long.parseLong(value.toString());
        if (valueAsLong == -32768L) {
            return 0;
        }
        if (valueAsLong < -32768L || valueAsLong > 32767L) {
            this.throwRangeException(value.toString(), columnIndex, 5);
        }
        return (short)valueAsLong;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return 0;
        }
        long valueAsLong = Long.parseLong(value.toString());
        if (valueAsLong == Integer.MIN_VALUE) {
            return 0;
        }
        if (valueAsLong < Integer.MIN_VALUE || valueAsLong > Integer.MAX_VALUE) {
            this.throwRangeException(value.toString(), columnIndex, 4);
        }
        return (int)valueAsLong;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return 0L;
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            switch (this.timestampPrecision) {
                default: {
                    return ts.getTime();
                }
                case 1: {
                    return ts.getTime() * 1000L + (long)(ts.getNanos() / 1000 % 1000);
                }
                case 2: 
            }
            return ts.getTime() * 1000000L + (long)(ts.getNanos() % 1000000);
        }
        long valueAsLong = 0L;
        try {
            valueAsLong = Long.parseLong(value.toString());
            if (valueAsLong == Long.MIN_VALUE) {
                return 0L;
            }
        }
        catch (NumberFormatException e) {
            this.throwRangeException(value.toString(), columnIndex, -5);
        }
        return valueAsLong;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Double) {
            return new Float((Double)value).floatValue();
        }
        return Float.parseFloat(value.toString());
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Double || value instanceof Float) {
            return (Double)value;
        }
        return Double.parseDouble(value.toString());
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return ((String)value).getBytes();
        }
        if (value instanceof Long) {
            return Longs.toByteArray((long)((Long)value));
        }
        if (value instanceof Integer) {
            return Ints.toByteArray((int)((Integer)value));
        }
        if (value instanceof Short) {
            return Shorts.toByteArray((short)((Short)value));
        }
        if (value instanceof Byte) {
            return new byte[]{(Byte)value};
        }
        return value.toString().getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return new Date(((Timestamp)value).getTime());
        }
        return Utils.parseDate(value.toString());
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return new Time(((Timestamp)value).getTime());
        }
        Time time = null;
        try {
            time = Utils.parseTime(value.toString());
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        return time;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Timestamp ret;
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Long) {
            if (10000000000000L > (Long)value) {
                return Timestamp.from(Instant.ofEpochMilli((Long)value));
            }
            long epochSec = (Long)value / 1000000L;
            long nanoAdjustment = (Long)value % 1000000L * 1000L;
            return Timestamp.from(Instant.ofEpochSecond(epochSec, nanoAdjustment));
        }
        try {
            ret = Utils.parseTimestamp(value.toString());
        }
        catch (Exception e) {
            ret = null;
            this.wasNull = true;
        }
        return ret;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.metaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        this.wasNull = value == null;
        return value;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        int columnIndex = this.columnNames.indexOf(columnLabel);
        if (columnIndex == -1) {
            throw new SQLException("cannot find Column in resultSet");
        }
        return columnIndex + 1;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        BigDecimal ret;
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return null;
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return new BigDecimal(Long.parseLong(value.toString()));
        }
        if (value instanceof Double || value instanceof Float) {
            return BigDecimal.valueOf(Double.parseDouble(value.toString()));
        }
        if (value instanceof Timestamp) {
            return new BigDecimal(((Timestamp)value).getTime());
        }
        try {
            ret = new BigDecimal(value.toString());
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.pos == -1 && this.resultSet.size() != 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.pos >= this.resultSet.size() && this.resultSet.size() != 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.pos == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.resultSet.size() == 0) {
            return false;
        }
        return this.pos == this.resultSet.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            if (this.resultSet.size() > 0) {
                this.pos = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            if (this.resultSet.size() > 0) {
                this.pos = this.resultSet.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.resultSet.size() == 0) {
            return false;
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            this.pos = 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.resultSet.size() == 0) {
            return false;
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            this.pos = this.resultSet.size() - 1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        int row;
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            if (this.pos < 0 || this.pos >= this.resultSet.size()) {
                return 0;
            }
            row = this.pos + 1;
        }
        return row;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.statement;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public static class Field {
        String name;
        int type;
        int length;
        String note;
        int taos_type;

        public Field(String name, int type, int length, String note, int taos_type) {
            this.name = name;
            this.type = type;
            this.length = length;
            this.note = note;
            this.taos_type = taos_type;
        }

        public int getTaosType() {
            return this.taos_type;
        }
    }
}

