/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.converters;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.storage.relational.converters.H2ExceptionConverter;
import org.apache.gravitino.storage.relational.converters.MySQLExceptionConverter;
import org.apache.gravitino.storage.relational.converters.PostgreSQLExceptionConverter;
import org.apache.gravitino.storage.relational.converters.SQLExceptionConverter;

public class SQLExceptionConverterFactory {
    private static final Pattern TYPE_PATTERN = Pattern.compile("jdbc:(\\w+):");
    private static volatile SQLExceptionConverter converter;

    private SQLExceptionConverterFactory() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void initConverter(Config config) {
        if (converter != null) return;
        String jdbcUrl = config.get(Configs.ENTITY_RELATIONAL_JDBC_BACKEND_URL);
        Matcher typeMatcher = TYPE_PATTERN.matcher(jdbcUrl);
        if (!typeMatcher.find()) throw new IllegalArgumentException(String.format("Cannot find jdbc type in jdbc url: %s", jdbcUrl));
        String jdbcType = typeMatcher.group(1);
        if (jdbcType.equalsIgnoreCase("mysql")) {
            converter = new MySQLExceptionConverter();
            return;
        } else if (jdbcType.equalsIgnoreCase("h2")) {
            converter = new H2ExceptionConverter();
            return;
        } else {
            if (!jdbcType.equalsIgnoreCase("postgresql")) throw new IllegalArgumentException(String.format("Unsupported jdbc type: %s", jdbcType));
            converter = new PostgreSQLExceptionConverter();
        }
    }

    public static SQLExceptionConverter getConverter() {
        Preconditions.checkState((converter != null ? 1 : 0) != 0, (Object)"Exception converter is not initialized.");
        return converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void close() {
        if (converter == null) return;
        Class<SQLExceptionConverterFactory> clazz = SQLExceptionConverterFactory.class;
        synchronized (SQLExceptionConverterFactory.class) {
            if (converter == null) return;
            converter = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

