/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.provider;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.gravitino.iceberg.common.IcebergConfig;
import org.apache.gravitino.iceberg.service.provider.IcebergConfigProvider;
import org.apache.gravitino.utils.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticIcebergConfigProvider
implements IcebergConfigProvider {
    public static final Logger LOG = LoggerFactory.getLogger(StaticIcebergConfigProvider.class);
    @VisibleForTesting
    Map<String, IcebergConfig> catalogConfigs;

    @Override
    public void initialize(Map<String, String> properties) {
        this.catalogConfigs = properties.keySet().stream().map(this::getCatalogName).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toMap(catalogName -> catalogName, catalogName -> new IcebergConfig(MapUtils.getPrefixMap((Map)properties, (String)String.format("catalog.%s.", catalogName)))));
        this.catalogConfigs.put("default_catalog", new IcebergConfig(properties));
    }

    @Override
    public Optional<IcebergConfig> getIcebergCatalogConfig(String catalogName) {
        return Optional.ofNullable(this.catalogConfigs.get(catalogName));
    }

    @Override
    public void close() {
    }

    private Optional<String> getCatalogName(String catalogConfigKey) {
        if (!catalogConfigKey.startsWith("catalog.")) {
            return Optional.empty();
        }
        if (catalogConfigKey.split("\\.").length < 3) {
            LOG.warn("{} format is illegal", (Object)catalogConfigKey);
            return Optional.empty();
        }
        return Optional.of(catalogConfigKey.split("\\.")[1]);
    }
}

