/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.time.Instant;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.EntityCombinedTopic;
import org.apache.gravitino.catalog.OperationDispatcher;
import org.apache.gravitino.catalog.PropertiesMetadataHelpers;
import org.apache.gravitino.catalog.SchemaDispatcher;
import org.apache.gravitino.catalog.TopicDispatcher;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.capability.Capability;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTopicException;
import org.apache.gravitino.exceptions.TopicAlreadyExistsException;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.messaging.DataLayout;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.messaging.TopicChange;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.TopicEntity;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicOperationDispatcher
extends OperationDispatcher
implements TopicDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(TopicOperationDispatcher.class);

    public TopicOperationDispatcher(CatalogManager catalogManager, EntityStore store, IdGenerator idGenerator) {
        super(catalogManager, store, idGenerator);
    }

    public NameIdentifier[] listTopics(Namespace namespace) throws NoSuchSchemaException {
        return this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(NameIdentifier.of((String[])namespace.levels())), c -> c.doWithTopicOps(t -> t.listTopics(namespace)), NoSuchSchemaException.class);
    }

    public Topic loadTopic(NameIdentifier ident) throws NoSuchTopicException {
        EntityCombinedTopic topic = TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.internalLoadTopic(ident));
        if (!topic.imported()) {
            SchemaDispatcher schemaDispatcher = GravitinoEnv.getInstance().schemaDispatcher();
            NameIdentifier schemaIdent = NameIdentifier.of((String[])ident.namespace().levels());
            schemaDispatcher.loadSchema(schemaIdent);
            TreeLockUtils.doWithTreeLock(schemaIdent, LockType.WRITE, () -> {
                this.importTopic(ident);
                return null;
            });
        }
        return topic;
    }

    public Topic createTopic(NameIdentifier ident, String comment, DataLayout dataLayout, Map<String, String> properties) throws NoSuchSchemaException, TopicAlreadyExistsException {
        SchemaDispatcher schemaDispatcher = GravitinoEnv.getInstance().schemaDispatcher();
        NameIdentifier schemaIdent = NameIdentifier.of((String[])ident.namespace().levels());
        schemaDispatcher.loadSchema(schemaIdent);
        return TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])ident.namespace().levels()), LockType.WRITE, () -> this.internalCreateTopic(ident, comment, dataLayout, properties));
    }

    public Topic alterTopic(NameIdentifier ident, TopicChange ... changes) throws NoSuchTopicException, IllegalArgumentException {
        this.validateAlterProperties(ident, HasPropertyMetadata::topicPropertiesMetadata, changes);
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        Topic alteredTopic = this.doWithCatalog(catalogIdent, c -> c.doWithTopicOps(t -> t.alterTopic(ident, changes)), NoSuchTopicException.class, IllegalArgumentException.class);
        TopicEntity updatedTopicEntity = this.operateOnEntity(ident, id -> this.store.update((NameIdentifier)id, TopicEntity.class, Entity.EntityType.TOPIC, topicEntity -> TopicEntity.builder().withId(topicEntity.id()).withName(topicEntity.name()).withNamespace(ident.namespace()).withComment(StringUtils.isBlank((CharSequence)alteredTopic.comment()) ? topicEntity.comment() : alteredTopic.comment()).withAuditInfo(AuditInfo.builder().withCreator(topicEntity.auditInfo().creator()).withCreateTime(topicEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build()).build()), "UPDATE", this.getStringIdFromProperties(alteredTopic.properties()).id());
        return EntityCombinedTopic.of(alteredTopic, updatedTopicEntity).withHiddenPropertiesSet(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::topicPropertiesMetadata, alteredTopic.properties()));
    }

    public boolean dropTopic(NameIdentifier ident) {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        boolean droppedFromCatalog = this.doWithCatalog(catalogIdent, c -> c.doWithTopicOps(t -> t.dropTopic(ident)), RuntimeException.class);
        boolean droppedFromStore = false;
        try {
            droppedFromStore = this.store.delete(ident, Entity.EntityType.TOPIC);
        }
        catch (NoSuchEntityException e) {
            LOG.warn("The topic to be dropped does not exist in the store: {}", (Object)ident, (Object)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.isManagedEntity(catalogIdent, Capability.Scope.TOPIC) ? droppedFromStore : droppedFromCatalog;
    }

    private void importTopic(NameIdentifier identifier) {
        long uid;
        EntityCombinedTopic topic = this.internalLoadTopic(identifier);
        if (topic.imported()) {
            return;
        }
        StringIdentifier stringId = null;
        try {
            stringId = topic.stringIdentifier();
        }
        catch (IllegalArgumentException ie) {
            LOG.warn("Failed to get string identifier from schema properties: {}, this maybe caused by the same-name string identifier is set by the user with unsupported format.", (Object)ie.getMessage());
        }
        if (stringId != null) {
            LOG.warn("The Topic uid {} existed but still needs to be imported, this could be happened when Topic is created externally without leveraging Gravitino. In this case, we need to store the stored entity to keep consistency.", (Object)stringId);
            uid = stringId.id();
        } else {
            uid = this.idGenerator.nextId();
        }
        TopicEntity topicEntity = TopicEntity.builder().withId(uid).withName(topic.name()).withComment(topic.comment()).withNamespace(identifier.namespace()).withAuditInfo(AuditInfo.builder().withCreator(topic.auditInfo().creator()).withCreateTime(topic.auditInfo().createTime()).withLastModifier(topic.auditInfo().lastModifier()).withLastModifiedTime(topic.auditInfo().lastModifiedTime()).build()).build();
        try {
            this.store.put(topicEntity, true);
        }
        catch (Exception e) {
            LOG.error("Failed to {} entity for {} in Gravitino, with this situation the returned object will not contain the metadata from Gravitino.", new Object[]{"put", identifier, e});
            throw new RuntimeException("Fail to import topic entity to store.", e);
        }
    }

    private EntityCombinedTopic internalLoadTopic(NameIdentifier ident) {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        Topic topic = this.doWithCatalog(catalogIdent, c -> c.doWithTopicOps(t -> t.loadTopic(ident)), NoSuchTopicException.class);
        StringIdentifier stringId = this.getStringIdFromProperties(topic.properties());
        if (stringId == null) {
            return EntityCombinedTopic.of(topic).withHiddenPropertiesSet(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::topicPropertiesMetadata, topic.properties())).withImported(this.isEntityExist(ident, Entity.EntityType.TOPIC));
        }
        TopicEntity topicEntity = this.operateOnEntity(ident, identifier -> this.store.get((NameIdentifier)identifier, Entity.EntityType.TOPIC, TopicEntity.class), "GET", this.getStringIdFromProperties(topic.properties()).id());
        return EntityCombinedTopic.of(topic, topicEntity).withHiddenPropertiesSet(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::topicPropertiesMetadata, topic.properties())).withImported(topicEntity != null);
    }

    private Topic internalCreateTopic(NameIdentifier ident, String comment, DataLayout dataLayout, Map<String, String> properties) {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        this.doWithCatalog(catalogIdent, c -> c.doWithPropertiesMeta(p -> {
            PropertiesMetadataHelpers.validatePropertyForCreate(p.topicPropertiesMetadata(), properties);
            return null;
        }), IllegalArgumentException.class);
        Long uid = this.idGenerator.nextId();
        StringIdentifier stringId = StringIdentifier.fromId(uid);
        Map<String, String> updatedProperties = StringIdentifier.newPropertiesWithId(stringId, properties);
        Topic topic = this.doWithCatalog(catalogIdent, c -> c.doWithTopicOps(t -> t.createTopic(ident, comment, dataLayout, updatedProperties)), NoSuchSchemaException.class, TopicAlreadyExistsException.class);
        TopicEntity topicEntity = TopicEntity.builder().withId(StringIdentifier.fromProperties(topic.properties()).id()).withName(ident.name()).withComment(comment).withNamespace(ident.namespace()).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
        try {
            this.store.put(topicEntity, true);
        }
        catch (Exception e) {
            LOG.error("Failed to {} entity for {} in Gravitino, with this situation the returned object will not contain the metadata from Gravitino.", new Object[]{"put", ident, e});
            return EntityCombinedTopic.of(topic).withHiddenPropertiesSet(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::topicPropertiesMetadata, topic.properties()));
        }
        return EntityCombinedTopic.of(topic, topicEntity).withHiddenPropertiesSet(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::topicPropertiesMetadata, topic.properties()));
    }
}

