/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.HashMap;
import org.apache.gravitino.trino.connector.GravitinoConfig;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorContext;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorFactory;
import org.apache.gravitino.trino.connector.catalog.hive.HiveConnectorAdapter;
import org.apache.gravitino.trino.connector.catalog.iceberg.IcebergConnectorAdapter;
import org.apache.gravitino.trino.connector.catalog.jdbc.mysql.MySQLConnectorAdapter;
import org.apache.gravitino.trino.connector.catalog.jdbc.postgresql.PostgreSQLConnectorAdapter;
import org.apache.gravitino.trino.connector.catalog.memory.MemoryConnectorAdapter;
import org.apache.gravitino.trino.connector.metadata.GravitinoCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCatalogConnectorFactory
implements CatalogConnectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCatalogConnectorFactory.class);
    protected final HashMap<String, CatalogConnectorContext.Builder> catalogBuilders = new HashMap();

    public DefaultCatalogConnectorFactory(GravitinoConfig config) {
        this.catalogBuilders.put("hive", new CatalogConnectorContext.Builder(new HiveConnectorAdapter()));
        this.catalogBuilders.put("memory", new CatalogConnectorContext.Builder(new MemoryConnectorAdapter()));
        this.catalogBuilders.put("lakehouse-iceberg", new CatalogConnectorContext.Builder(new IcebergConnectorAdapter()));
        this.catalogBuilders.put("jdbc-mysql", new CatalogConnectorContext.Builder(new MySQLConnectorAdapter()));
        this.catalogBuilders.put("jdbc-postgresql", new CatalogConnectorContext.Builder(new PostgreSQLConnectorAdapter()));
        LOG.info("Start the DefaultCatalogConnectorFactory");
    }

    @Override
    public CatalogConnectorContext.Builder createCatalogConnectorContextBuilder(GravitinoCatalog catalog) {
        String catalogProvider = catalog.getProvider();
        CatalogConnectorContext.Builder builder = this.catalogBuilders.get(catalogProvider);
        if (builder == null) {
            String message = String.format("Unsupported catalog provider %s.", catalogProvider);
            LOG.error(message);
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_UNSUPPORTED_CATALOG_PROVIDER, message);
        }
        return builder.clone(catalog);
    }
}

