/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import com.google.common.base.Function;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.AclUtil;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ChRootedFileSystem;
import org.apache.hadoop.fs.viewfs.Constants;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.hadoop.fs.viewfs.NflyFSystem;
import org.apache.hadoop.fs.viewfs.NotInMountpointException;
import org.apache.hadoop.fs.viewfs.ViewFsFileStatus;
import org.apache.hadoop.fs.viewfs.ViewFsLocatedFileStatus;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ViewFileSystem
extends FileSystem {
    private static final Path ROOT_PATH = new Path("/");
    final long creationTime;
    final UserGroupInformation ugi;
    URI myUri;
    private Path workingDir;
    Configuration config;
    InodeTree<FileSystem> fsState;
    Path homeDir = null;
    private boolean enableInnerCache = false;
    private InnerCache cache;
    private RenameStrategy renameStrategy = RenameStrategy.SAME_MOUNTPOINT;

    static AccessControlException readOnlyMountTable(String operation, String p) {
        return new AccessControlException("InternalDir of ViewFileSystem is readonly; operation=" + operation + "Path=" + p);
    }

    static AccessControlException readOnlyMountTable(String operation, Path p) {
        return ViewFileSystem.readOnlyMountTable(operation, p.toString());
    }

    private String getUriPath(Path p) {
        this.checkPath(p);
        return this.makeAbsolute(p).toUri().getPath();
    }

    private Path makeAbsolute(Path f) {
        return f.isAbsolute() ? f : new Path(this.workingDir, f);
    }

    public ViewFileSystem() throws IOException {
        this.ugi = UserGroupInformation.getCurrentUser();
        this.creationTime = Time.now();
    }

    @Override
    public String getScheme() {
        return "viewfs";
    }

    @Override
    public void initialize(URI theUri, Configuration conf) throws IOException {
        super.initialize(theUri, conf);
        this.setConf(conf);
        this.config = conf;
        this.enableInnerCache = this.config.getBoolean("fs.viewfs.enable.inner.cache", true);
        this.cache = new InnerCache();
        String authority = theUri.getAuthority();
        try {
            this.myUri = new URI("viewfs", authority, "/", null, null);
            this.fsState = new InodeTree<FileSystem>(conf, authority){

                @Override
                protected Function<URI, FileSystem> initAndGetTargetFs() {
                    return new Function<URI, FileSystem>(){

                        public FileSystem apply(final URI uri) {
                            try {
                                FileSystem fs = ViewFileSystem.this.ugi.doAs(new PrivilegedExceptionAction<FileSystem>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public FileSystem run() throws IOException {
                                        if (ViewFileSystem.this.enableInnerCache) {
                                            InnerCache innerCache = ViewFileSystem.this.cache;
                                            synchronized (innerCache) {
                                                return ViewFileSystem.this.cache.get(uri, ViewFileSystem.this.config);
                                            }
                                        }
                                        return FileSystem.get(uri, ViewFileSystem.this.config);
                                    }
                                });
                                return new ChRootedFileSystem(fs, uri);
                            }
                            catch (IOException | InterruptedException ex) {
                                FileSystem.LOG.error((Object)("Could not initialize the underlying FileSystem object. Exception: " + ex.toString()));
                                return null;
                            }
                        }
                    };
                }

                @Override
                protected FileSystem getTargetFileSystem(InodeTree.INodeDir<FileSystem> dir) throws URISyntaxException {
                    return new InternalDirOfViewFs(dir, ViewFileSystem.this.creationTime, ViewFileSystem.this.ugi, ViewFileSystem.this.myUri, ViewFileSystem.this.config);
                }

                @Override
                protected FileSystem getTargetFileSystem(String settings, URI[] uris) throws URISyntaxException, IOException {
                    return NflyFSystem.createFileSystem(uris, ViewFileSystem.this.config, settings);
                }
            };
            this.workingDir = this.getHomeDirectory();
            this.renameStrategy = RenameStrategy.valueOf(conf.get("fs.viewfs.rename.strategy", RenameStrategy.SAME_MOUNTPOINT.toString()));
        }
        catch (URISyntaxException e) {
            throw new IOException("URISyntax exception: " + theUri);
        }
    }

    ViewFileSystem(URI theUri, Configuration conf) throws IOException {
        this();
        this.initialize(theUri, conf);
    }

    public ViewFileSystem(Configuration conf) throws IOException {
        this(FsConstants.VIEWFS_URI, conf);
    }

    public Path getTrashCanLocation(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return res.isInternalDir() ? null : ((FileSystem)res.targetFileSystem).getHomeDirectory();
    }

    @Override
    public URI getUri() {
        return this.myUri;
    }

    @Override
    public Path resolvePath(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        if (res.isInternalDir()) {
            return f;
        }
        return ((FileSystem)res.targetFileSystem).resolvePath(res.remainingPath);
    }

    @Override
    public Path getHomeDirectory() {
        if (this.homeDir == null) {
            String base = this.fsState.getHomeDirPrefixValue();
            if (base == null) {
                base = "/user";
            }
            this.homeDir = base.equals("/") ? this.makeQualified(new Path(base + this.ugi.getShortUserName())) : this.makeQualified(new Path(base + "/" + this.ugi.getShortUserName()));
        }
        return this.homeDir;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDirectory(Path new_dir) {
        this.getUriPath(new_dir);
        this.workingDir = this.makeAbsolute(new_dir);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).append(res.remainingPath, bufferSize, progress);
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        InodeTree.ResolveResult<FileSystem> res;
        try {
            res = this.fsState.resolve(this.getUriPath(f), false);
        }
        catch (FileNotFoundException e) {
            throw ViewFileSystem.readOnlyMountTable("create", f);
        }
        assert (res.remainingPath != null);
        return ((FileSystem)res.targetFileSystem).createNonRecursive(res.remainingPath, permission, flags, bufferSize, replication, blockSize, progress);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        InodeTree.ResolveResult<FileSystem> res;
        try {
            res = this.fsState.resolve(this.getUriPath(f), false);
        }
        catch (FileNotFoundException e) {
            throw ViewFileSystem.readOnlyMountTable("create", f);
        }
        assert (res.remainingPath != null);
        return ((FileSystem)res.targetFileSystem).create(res.remainingPath, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        if (res.isInternalDir() || res.remainingPath == InodeTree.SlashPath) {
            throw ViewFileSystem.readOnlyMountTable("delete", f);
        }
        return ((FileSystem)res.targetFileSystem).delete(res.remainingPath, recursive);
    }

    @Override
    public boolean delete(Path f) throws AccessControlException, FileNotFoundException, IOException {
        return this.delete(f, true);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus fs, long start, long len) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(fs.getPath()), true);
        return ((FileSystem)res.targetFileSystem).getFileBlockLocations(new ViewFsFileStatus(fs, res.remainingPath), start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getFileChecksum(res.remainingPath);
    }

    private static FileStatus fixFileStatus(FileStatus orig, Path qualified) throws IOException {
        if ("file".equals(orig.getPath().toUri().getScheme())) {
            orig = ViewFileSystem.wrapLocalFileStatus(orig, qualified);
        }
        orig.setPath(qualified);
        return orig;
    }

    private static FileStatus wrapLocalFileStatus(FileStatus orig, Path qualified) {
        return orig instanceof LocatedFileStatus ? new ViewFsLocatedFileStatus((LocatedFileStatus)orig, qualified) : new ViewFsFileStatus(orig, qualified);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        FileStatus status = ((FileSystem)res.targetFileSystem).getFileStatus(res.remainingPath);
        return ViewFileSystem.fixFileStatus(status, this.makeQualified(f));
    }

    @Override
    public void access(Path path, FsAction mode) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).access(res.remainingPath, mode);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        FileStatus[] statusLst = ((FileSystem)res.targetFileSystem).listStatus(res.remainingPath);
        if (!res.isInternalDir()) {
            int i = 0;
            for (FileStatus status : statusLst) {
                statusLst[i++] = ViewFileSystem.fixFileStatus(status, this.getChrootedPath(res, status, f));
            }
        }
        return statusLst;
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path f, PathFilter filter) throws FileNotFoundException, IOException {
        final InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        final RemoteIterator<LocatedFileStatus> statusIter = ((FileSystem)res.targetFileSystem).listLocatedStatus(res.remainingPath);
        if (res.isInternalDir()) {
            return statusIter;
        }
        return new RemoteIterator<LocatedFileStatus>(){

            @Override
            public boolean hasNext() throws IOException {
                return statusIter.hasNext();
            }

            @Override
            public LocatedFileStatus next() throws IOException {
                LocatedFileStatus status = (LocatedFileStatus)statusIter.next();
                return (LocatedFileStatus)ViewFileSystem.fixFileStatus(status, ViewFileSystem.this.getChrootedPath(res, status, f));
            }
        };
    }

    private Path getChrootedPath(InodeTree.ResolveResult<FileSystem> res, FileStatus status, Path f) throws IOException {
        String suffix = res.targetFileSystem instanceof ChRootedFileSystem ? ((ChRootedFileSystem)res.targetFileSystem).stripOutRoot(status.getPath()) : ((NflyFSystem.NflyStatus)status).stripRoot();
        return this.makeQualified(suffix.length() == 0 ? f : new Path(res.resolvedPath, suffix));
    }

    @Override
    public boolean mkdirs(Path dir) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(dir), false);
        return ((FileSystem)res.targetFileSystem).mkdirs(res.remainingPath);
    }

    @Override
    public boolean mkdirs(Path dir, FsPermission permission) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(dir), false);
        return ((FileSystem)res.targetFileSystem).mkdirs(res.remainingPath, permission);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).open(res.remainingPath, bufferSize);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        InodeTree.ResolveResult<FileSystem> resSrc = this.fsState.resolve(this.getUriPath(src), false);
        if (resSrc.isInternalDir()) {
            throw ViewFileSystem.readOnlyMountTable("rename", src);
        }
        InodeTree.ResolveResult<FileSystem> resDst = this.fsState.resolve(this.getUriPath(dst), false);
        if (resDst.isInternalDir()) {
            throw ViewFileSystem.readOnlyMountTable("rename", dst);
        }
        URI srcUri = ((FileSystem)resSrc.targetFileSystem).getUri();
        URI dstUri = ((FileSystem)resDst.targetFileSystem).getUri();
        ViewFileSystem.verifyRenameStrategy(srcUri, dstUri, resSrc.targetFileSystem == resDst.targetFileSystem, this.renameStrategy);
        if (resSrc.targetFileSystem instanceof ChRootedFileSystem && resDst.targetFileSystem instanceof ChRootedFileSystem) {
            ChRootedFileSystem srcFS = (ChRootedFileSystem)resSrc.targetFileSystem;
            ChRootedFileSystem dstFS = (ChRootedFileSystem)resDst.targetFileSystem;
            return srcFS.getMyFs().rename(srcFS.fullPath(resSrc.remainingPath), dstFS.fullPath(resDst.remainingPath));
        }
        return ((FileSystem)resSrc.targetFileSystem).rename(resSrc.remainingPath, resDst.remainingPath);
    }

    static void verifyRenameStrategy(URI srcUri, URI dstUri, boolean isSrcDestSame, RenameStrategy renameStrategy) throws IOException {
        switch (renameStrategy) {
            case SAME_FILESYSTEM_ACROSS_MOUNTPOINT: {
                if (srcUri.getAuthority() == null || srcUri.getScheme().equals(dstUri.getScheme()) && srcUri.getAuthority().equals(dstUri.getAuthority())) break;
                throw new IOException("Renames across Mount points not supported");
            }
            case SAME_TARGET_URI_ACROSS_MOUNTPOINT: {
                if (srcUri.equals(dstUri)) break;
                throw new IOException("Renames across Mount points not supported");
            }
            case SAME_MOUNTPOINT: {
                if (isSrcDestSame) break;
                throw new IOException("Renames across Mount points not supported");
            }
            default: {
                throw new IllegalArgumentException("Unexpected rename strategy");
            }
        }
    }

    @Override
    public boolean truncate(Path f, long newLength) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).truncate(res.remainingPath, newLength);
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((FileSystem)res.targetFileSystem).setOwner(res.remainingPath, username, groupname);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((FileSystem)res.targetFileSystem).setPermission(res.remainingPath, permission);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).setReplication(res.remainingPath, replication);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws AccessControlException, FileNotFoundException, IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((FileSystem)res.targetFileSystem).setTimes(res.remainingPath, mtime, atime);
    }

    @Override
    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).modifyAclEntries(res.remainingPath, aclSpec);
    }

    @Override
    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeAclEntries(res.remainingPath, aclSpec);
    }

    @Override
    public void removeDefaultAcl(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeDefaultAcl(res.remainingPath);
    }

    @Override
    public void removeAcl(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeAcl(res.remainingPath);
    }

    @Override
    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).setAcl(res.remainingPath, aclSpec);
    }

    @Override
    public AclStatus getAclStatus(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getAclStatus(res.remainingPath);
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).setXAttr(res.remainingPath, name, value, flag);
    }

    @Override
    public byte[] getXAttr(Path path, String name) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getXAttr(res.remainingPath, name);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getXAttrs(res.remainingPath);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).getXAttrs(res.remainingPath, names);
    }

    @Override
    public List<String> listXAttrs(Path path) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).listXAttrs(res.remainingPath);
    }

    @Override
    public void removeXAttr(Path path, String name) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).removeXAttr(res.remainingPath, name);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) {
    }

    private Map<String, FileSystem> initializeMountedFileSystems(List<InodeTree.MountPoint<FileSystem>> mountPoints) {
        FileSystem fs = null;
        HashMap<String, FileSystem> fsMap = new HashMap<String, FileSystem>(mountPoints.size());
        for (InodeTree.MountPoint<FileSystem> mount : mountPoints) {
            try {
                fs = (FileSystem)mount.target.getTargetFileSystem();
                fsMap.put(mount.src, fs);
            }
            catch (IOException ex) {
                String errMsg = "Not able to initialize FileSystem for mount path " + mount.src + " with exception " + ex;
                LOG.error((Object)errMsg);
                throw new RuntimeException(errMsg, ex);
            }
        }
        return fsMap;
    }

    @Override
    public long getDefaultBlockSize() {
        throw new NotInMountpointException("getDefaultBlockSize");
    }

    @Override
    public short getDefaultReplication() {
        throw new NotInMountpointException("getDefaultReplication");
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        throw new NotInMountpointException("getServerDefaults");
    }

    @Override
    public long getDefaultBlockSize(Path f) {
        try {
            InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
            return ((FileSystem)res.targetFileSystem).getDefaultBlockSize(res.remainingPath);
        }
        catch (FileNotFoundException e) {
            throw new NotInMountpointException(f, "getDefaultBlockSize");
        }
        catch (IOException e) {
            throw new RuntimeException("Not able to initialize fs in  getDefaultBlockSize for path " + f + " with exception", e);
        }
    }

    @Override
    public short getDefaultReplication(Path f) {
        try {
            InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
            return ((FileSystem)res.targetFileSystem).getDefaultReplication(res.remainingPath);
        }
        catch (FileNotFoundException e) {
            throw new NotInMountpointException(f, "getDefaultReplication");
        }
        catch (IOException e) {
            throw new RuntimeException("Not able to initialize fs in  getDefaultReplication for path " + f + " with exception", e);
        }
    }

    @Override
    public FsServerDefaults getServerDefaults(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getServerDefaults(res.remainingPath);
    }

    @Override
    public ContentSummary getContentSummary(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getContentSummary(res.remainingPath);
    }

    @Override
    public QuotaUsage getQuotaUsage(Path f) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((FileSystem)res.targetFileSystem).getQuotaUsage(res.remainingPath);
    }

    @Override
    public void setWriteChecksum(boolean writeChecksum) {
    }

    @Override
    public FileSystem[] getChildFileSystems() {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        Map<String, FileSystem> fsMap = this.initializeMountedFileSystems(mountPoints);
        HashSet<FileSystem> children = new HashSet<FileSystem>();
        for (InodeTree.MountPoint<FileSystem> mountPoint : mountPoints) {
            FileSystem targetFs = fsMap.get(mountPoint.src);
            children.addAll(Arrays.asList(targetFs.getChildFileSystems()));
        }
        return children.toArray(new FileSystem[0]);
    }

    public MountPoint[] getMountPoints() {
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        MountPoint[] result = new MountPoint[mountPoints.size()];
        for (int i = 0; i < mountPoints.size(); ++i) {
            result[i] = new MountPoint(new Path(mountPoints.get((int)i).src), mountPoints.get((int)i).target.targetDirLinkList);
        }
        return result;
    }

    @Override
    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        return ((FileSystem)res.targetFileSystem).createSnapshot(res.remainingPath, snapshotName);
    }

    @Override
    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).renameSnapshot(res.remainingPath, snapshotOldName, snapshotNewName);
    }

    @Override
    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
        ((FileSystem)res.targetFileSystem).deleteSnapshot(res.remainingPath, snapshotName);
    }

    @Override
    public Path getTrashRoot(Path path) {
        try {
            InodeTree.ResolveResult<FileSystem> res = this.fsState.resolve(this.getUriPath(path), true);
            Path targetFSTrashRoot = ((FileSystem)res.targetFileSystem).getTrashRoot(res.remainingPath);
            if (!this.config.getBoolean("fs.viewfs.trash.force-inside-mount-point", false)) {
                return targetFSTrashRoot;
            }
            String targetFSTrashRootPath = targetFSTrashRoot.toUri().getPath();
            String mountTargetPath = ((FileSystem)res.targetFileSystem).getUri().getPath();
            if (!mountTargetPath.endsWith("/")) {
                mountTargetPath = mountTargetPath + "/";
            }
            Path targetFsUserHome = ((FileSystem)res.targetFileSystem).getHomeDirectory();
            if (targetFSTrashRootPath.startsWith(mountTargetPath) && (!mountTargetPath.equals(ROOT_PATH.toString()) || res.resolvedPath.equals(ROOT_PATH.toString()) || targetFsUserHome == null || !targetFSTrashRootPath.startsWith(targetFsUserHome.toUri().getPath()))) {
                String relativeTrashRoot = targetFSTrashRootPath.substring(mountTargetPath.length());
                return this.makeQualified(new Path(res.resolvedPath, relativeTrashRoot));
            }
            return this.makeQualified(new Path(res.resolvedPath, ".Trash/" + this.ugi.getShortUserName()));
        }
        catch (IOException | IllegalArgumentException e) {
            throw new NotInMountpointException(path, "getTrashRoot");
        }
    }

    @Override
    public Collection<FileStatus> getTrashRoots(boolean allUsers) {
        HashMap<Path, FileStatus> trashRoots = new HashMap<Path, FileStatus>();
        for (FileSystem fs : this.getChildFileSystems()) {
            for (FileStatus trash : fs.getTrashRoots(allUsers)) {
                trashRoots.put(trash.getPath(), trash);
            }
        }
        if (!this.config.getBoolean("fs.viewfs.trash.force-inside-mount-point", false)) {
            return trashRoots.values();
        }
        List<InodeTree.MountPoint<FileSystem>> mountPoints = this.fsState.getMountPoints();
        if (this.fsState.getRootFallbackLink() != null) {
            mountPoints.add(new InodeTree.MountPoint<FileSystem>("", this.fsState.getRootFallbackLink()));
        }
        try {
            for (InodeTree.MountPoint<FileSystem> mountPoint : mountPoints) {
                FileStatus[] mountPointTrashRoots;
                Path trashRoot = this.makeQualified(new Path(mountPoint.src + "/" + ".Trash"));
                if (!this.exists(trashRoot)) continue;
                FileSystem targetFS = (FileSystem)mountPoint.target.getTargetFileSystem();
                if (!allUsers) {
                    Path userTrashRoot = new Path(trashRoot, this.ugi.getShortUserName());
                    if (!this.exists(userTrashRoot)) continue;
                    Path targetFSUserTrashRoot = targetFS.makeQualified(new Path(targetFS.getUri().getPath(), ".Trash/" + this.ugi.getShortUserName()));
                    trashRoots.put(targetFSUserTrashRoot, this.getFileStatus(userTrashRoot));
                    continue;
                }
                for (FileStatus trash : mountPointTrashRoots = this.listStatus(trashRoot)) {
                    String targetFsTrash = trash.getPath().toUri().getPath().substring(mountPoint.src.length() + 1);
                    Path targetFsTrashPath = targetFS.makeQualified(new Path(targetFS.getUri().getPath(), targetFsTrash));
                    trashRoots.put(targetFsTrashPath, trash);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception in get all trash roots for mount points", (Throwable)e);
        }
        return trashRoots.values();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.enableInnerCache && this.cache != null) {
            this.cache.closeAll();
        }
    }

    static enum RenameStrategy {
        SAME_MOUNTPOINT,
        SAME_TARGET_URI_ACROSS_MOUNTPOINT,
        SAME_FILESYSTEM_ACROSS_MOUNTPOINT;

    }

    static class InternalDirOfViewFs
    extends FileSystem {
        final InodeTree.INodeDir<FileSystem> theInternalDir;
        final long creationTime;
        final UserGroupInformation ugi;
        final URI myUri;

        public InternalDirOfViewFs(InodeTree.INodeDir<FileSystem> dir, long cTime, UserGroupInformation ugi, URI uri, Configuration config) throws URISyntaxException {
            this.myUri = uri;
            try {
                this.initialize(this.myUri, config);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot occur");
            }
            this.theInternalDir = dir;
            this.creationTime = cTime;
            this.ugi = ugi;
        }

        private static void checkPathIsSlash(Path f) throws IOException {
            if (f != InodeTree.SlashPath) {
                throw new IOException("Internal implementation error: expected file name to be /");
            }
        }

        @Override
        public URI getUri() {
            return this.myUri;
        }

        @Override
        public Path getWorkingDirectory() {
            throw new RuntimeException("Internal impl error: getWorkingDir should not have been called");
        }

        @Override
        public void setWorkingDirectory(Path new_dir) {
            throw new RuntimeException("Internal impl error: getWorkingDir should not have been called");
        }

        @Override
        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
            throw ViewFileSystem.readOnlyMountTable("append", f);
        }

        @Override
        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws AccessControlException {
            throw ViewFileSystem.readOnlyMountTable("create", f);
        }

        @Override
        public boolean delete(Path f, boolean recursive) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("delete", f);
        }

        @Override
        public boolean delete(Path f) throws AccessControlException, IOException {
            return this.delete(f, true);
        }

        @Override
        public BlockLocation[] getFileBlockLocations(FileStatus fs, long start, long len) throws FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(fs.getPath());
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public FileChecksum getFileChecksum(Path f) throws FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public FileStatus getFileStatus(Path f) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            return new FileStatus(0L, true, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_555, this.ugi.getShortUserName(), this.ugi.getPrimaryGroupName(), new Path(this.theInternalDir.fullPath).makeQualified(this.myUri, ROOT_PATH));
        }

        @Override
        public FileStatus[] listStatus(Path f) throws AccessControlException, FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            FileStatus[] result = new FileStatus[this.theInternalDir.getChildren().size()];
            int i = 0;
            for (Map.Entry<String, InodeTree.INode<FileSystem>> iEntry : this.theInternalDir.getChildren().entrySet()) {
                InodeTree.INode<FileSystem> inode = iEntry.getValue();
                if (inode.isLink()) {
                    InodeTree.INodeLink link = (InodeTree.INodeLink)inode;
                    result[i++] = new FileStatus(0L, false, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_555, this.ugi.getShortUserName(), this.ugi.getPrimaryGroupName(), link.getTargetLink(), new Path(inode.fullPath).makeQualified(this.myUri, null));
                    continue;
                }
                result[i++] = new FileStatus(0L, true, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_555, this.ugi.getShortUserName(), this.ugi.getPrimaryGroupName(), new Path(inode.fullPath).makeQualified(this.myUri, null));
            }
            return result;
        }

        @Override
        public boolean mkdirs(Path dir, FsPermission permission) throws AccessControlException, FileAlreadyExistsException {
            if (this.theInternalDir.isRoot() && dir == null) {
                throw new FileAlreadyExistsException("/ already exits");
            }
            if (this.theInternalDir.getChildren().containsKey(dir.toString().substring(1))) {
                return true;
            }
            throw ViewFileSystem.readOnlyMountTable("mkdirs", dir);
        }

        @Override
        public boolean mkdirs(Path dir) throws AccessControlException, FileAlreadyExistsException {
            return this.mkdirs(dir, null);
        }

        @Override
        public FSDataInputStream open(Path f, int bufferSize) throws AccessControlException, FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public boolean rename(Path src, Path dst) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(src);
            InternalDirOfViewFs.checkPathIsSlash(dst);
            throw ViewFileSystem.readOnlyMountTable("rename", src);
        }

        @Override
        public boolean truncate(Path f, long newLength) throws IOException {
            throw ViewFileSystem.readOnlyMountTable("truncate", f);
        }

        @Override
        public void setOwner(Path f, String username, String groupname) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setOwner", f);
        }

        @Override
        public void setPermission(Path f, FsPermission permission) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setPermission", f);
        }

        @Override
        public boolean setReplication(Path f, short replication) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setReplication", f);
        }

        @Override
        public void setTimes(Path f, long mtime, long atime) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFileSystem.readOnlyMountTable("setTimes", f);
        }

        @Override
        public void setVerifyChecksum(boolean verifyChecksum) {
        }

        @Override
        public FsServerDefaults getServerDefaults(Path f) throws IOException {
            throw new NotInMountpointException(f, "getServerDefaults");
        }

        @Override
        public long getDefaultBlockSize(Path f) {
            throw new NotInMountpointException(f, "getDefaultBlockSize");
        }

        @Override
        public short getDefaultReplication(Path f) {
            throw new NotInMountpointException(f, "getDefaultReplication");
        }

        @Override
        public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("modifyAclEntries", path);
        }

        @Override
        public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("removeAclEntries", path);
        }

        @Override
        public void removeDefaultAcl(Path path) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("removeDefaultAcl", path);
        }

        @Override
        public void removeAcl(Path path) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("removeAcl", path);
        }

        @Override
        public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("setAcl", path);
        }

        @Override
        public AclStatus getAclStatus(Path path) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            return new AclStatus.Builder().owner(this.ugi.getShortUserName()).group(this.ugi.getPrimaryGroupName()).addEntries(AclUtil.getMinimalAcl(Constants.PERMISSION_555)).stickyBit(false).build();
        }

        @Override
        public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("setXAttr", path);
        }

        @Override
        public byte[] getXAttr(Path path, String name) throws IOException {
            throw new NotInMountpointException(path, "getXAttr");
        }

        @Override
        public Map<String, byte[]> getXAttrs(Path path) throws IOException {
            throw new NotInMountpointException(path, "getXAttrs");
        }

        @Override
        public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
            throw new NotInMountpointException(path, "getXAttrs");
        }

        @Override
        public List<String> listXAttrs(Path path) throws IOException {
            throw new NotInMountpointException(path, "listXAttrs");
        }

        @Override
        public void removeXAttr(Path path, String name) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("removeXAttr", path);
        }

        @Override
        public Path createSnapshot(Path path, String snapshotName) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("createSnapshot", path);
        }

        @Override
        public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("renameSnapshot", path);
        }

        @Override
        public void deleteSnapshot(Path path, String snapshotName) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(path);
            throw ViewFileSystem.readOnlyMountTable("deleteSnapshot", path);
        }

        @Override
        public QuotaUsage getQuotaUsage(Path f) throws IOException {
            throw new NotInMountpointException(f, "getQuotaUsage");
        }
    }

    public static class MountPoint {
        private Path src;
        private String[] targets;

        MountPoint(Path srcPath, String[] targetURIs) {
            this.src = srcPath;
            this.targets = targetURIs;
        }

        Path getSrc() {
            return this.src;
        }

        URI[] getTargets() {
            URI[] targetUris = new URI[this.targets.length];
            for (int i = 0; i < this.targets.length; ++i) {
                targetUris[i] = URI.create(this.targets[i]);
            }
            return targetUris;
        }

        public String[] getTargetFileSystemPaths() {
            return this.targets;
        }
    }

    static class InnerCache {
        private Map<Key, FileSystem> map = new HashMap<Key, FileSystem>();

        InnerCache() {
        }

        FileSystem get(URI uri, Configuration config) throws IOException {
            Key key = new Key(uri);
            if (this.map.get(key) == null) {
                FileSystem fs = FileSystem.newInstance(uri, config);
                this.map.put(key, fs);
                return fs;
            }
            return this.map.get(key);
        }

        void closeAll() {
            for (FileSystem fs : this.map.values()) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    FileSystem.LOG.info((Object)("Fail closing ViewFileSystem's child filesystem " + fs), (Throwable)e);
                }
            }
        }

        InnerCache unmodifiableCache() {
            this.map = Collections.unmodifiableMap(this.map);
            return this;
        }

        private static class Key {
            private final String scheme;
            private final String authority;

            Key(URI uri) {
                this.scheme = uri.getScheme() == null ? "" : uri.getScheme().toLowerCase();
                this.authority = uri.getAuthority() == null ? "" : uri.getAuthority().toLowerCase();
            }

            public int hashCode() {
                return Objects.hash(this.scheme, this.authority);
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj != null && obj instanceof Key) {
                    Key that = (Key)obj;
                    return this.scheme.equals(that.scheme) && this.authority.equals(that.authority);
                }
                return false;
            }
        }
    }
}

