/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.util;

import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class LatticeIndexUtil {
    public static void remember(Map<ByteString, NavigableMap<Long, Long>> historyMap, ByteString replicaId, long ver) {
        historyMap.compute(replicaId, (k, history) -> {
            if (history == null) {
                history = new ConcurrentSkipListMap<Long, Long>();
            }
            if (history.containsKey(ver)) {
                return history;
            }
            LatticeIndexUtil.remember(history, ver);
            return history;
        });
    }

    public static void remember(Map<ByteString, NavigableMap<Long, Long>> historyMap, ByteString replicaId, long startVer, long endVer) {
        historyMap.compute(replicaId, (k, history) -> {
            if (history == null) {
                history = new ConcurrentSkipListMap<Long, Long>();
            }
            LatticeIndexUtil.remember(history, startVer, endVer);
            return history;
        });
    }

    static void remember(NavigableMap<Long, Long> ranges, long ver) {
        LatticeIndexUtil.remember(ranges, ver, ver);
    }

    static void remember(NavigableMap<Long, Long> ranges, long startVer, long endVer) {
        Long startKey = ranges.floorKey(startVer);
        if (startKey == null) {
            startKey = startVer;
        } else if ((Long)ranges.get(startKey) + 1L < startVer) {
            startKey = startVer;
        }
        Long endKey = ranges.floorKey(endVer);
        if (endKey == null) {
            endKey = ranges.getOrDefault(endVer + 1L, endVer);
        } else if (ranges.containsKey((endKey = Long.valueOf(Math.max(endVer, (Long)ranges.get(endKey)))) + 1L)) {
            endKey = (Long)ranges.get(endKey + 1L);
        }
        ranges.subMap(startKey, true, endKey, true).clear();
        ranges.put(startKey, endKey);
    }
}

